/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.callback.RemoteCompletionCallback;
import com.jetbrains.cef.remote.network.RemoteRequestContextHandler;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.ArrayList;
import java.util.List;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefCompletionCallback;
import org.cef.handler.CefRequestContextHandler;
import org.cef.misc.CefLog;

public class RemoteRequestContext
extends CefRequestContext {
    private final List<Runnable> myDelayedActions = new ArrayList<Runnable>();
    private final CefRequestContextHandler myHandler;
    private RemoteRequestContextHandler myRemoteWrapper;
    private int myBid = -1;
    private RpcContext myRpc;

    public RemoteRequestContext(CefServer server) {
        this.myHandler = null;
        server.onConnected(() -> {
            List<Runnable> list = this.myDelayedActions;
            synchronized (list) {
                this.myRpc = server.getRpcContext();
                this.myDelayedActions.forEach(r -> r.run());
                this.myDelayedActions.clear();
            }
        }, "RemoteRequestContext(GLOBAL)", true);
    }

    public RemoteRequestContext(CefRequestContextHandler handler) {
        this.myHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBid(int bid, RpcContext ctx) {
        assert (bid >= 0);
        this.myBid = bid;
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            this.myRpc = ctx;
            this.myDelayedActions.forEach(r -> r.run());
            this.myDelayedActions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Runnable rpcCall, String name) {
        List<Runnable> list = this.myDelayedActions;
        synchronized (list) {
            if (this.myRpc != null) {
                rpcCall.run();
            } else {
                CefLog.Debug("RemoteRequestContext: %s: add delayed action %s", this, name);
                this.myDelayedActions.add(rpcCall);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.myRemoteWrapper != null) {
            RemoteRequestContextHandler.FACTORY.dispose(this.myRemoteWrapper.getId());
        }
    }

    @Override
    public boolean isGlobal() {
        return this.myHandler == null;
    }

    @Override
    public CefRequestContextHandler getHandler() {
        return this.myHandler;
    }

    public RemoteRequestContextHandler getRemoteHandler() {
        if (this.myHandler == null) {
            return null;
        }
        if (this.myRemoteWrapper == null) {
            this.myRemoteWrapper = RemoteRequestContextHandler.create(this.myHandler);
        }
        return this.myRemoteWrapper;
    }

    @Override
    public void ClearCertificateExceptions(CefCompletionCallback callback) {
        RObject cbId = callback != null ? RemoteCompletionCallback.create(callback).thriftId() : new RObject();
        this.execute(() -> this.myRpc.exec(s -> s.RequestContext_ClearCertificateExceptions(this.myBid, cbId)), "ClearCertificateExceptions");
    }

    @Override
    public void CloseAllConnections(CefCompletionCallback callback) {
        RObject cbId = callback != null ? RemoteCompletionCallback.create(callback).thriftId() : new RObject();
        this.execute(() -> this.myRpc.exec(s -> s.RequestContext_CloseAllConnections(this.myBid, cbId)), "CloseAllConnections");
    }
}

