/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.usbserial.windowsregistry.internal;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.DBT;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.usbserial.windowsregistry.internal.User32Ex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class WindowMessageHandler
implements Runnable,
WinUser.WindowProc {
    private final Logger logger = LoggerFactory.getLogger(WindowMessageHandler.class);
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final Set<WindowMessageListener> listeners = new CopyOnWriteArraySet<WindowMessageListener>();
    private final WinNT.HANDLE terminateEvent = Kernel32.INSTANCE.CreateEvent(null, false, false, null);

    public boolean addListener(WindowMessageListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(WindowMessageListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void run() {
        WinUser.HDEVNOTIFY hDevNotify;
        WinDef.HWND hWnd;
        WinDef.HMODULE hInst;
        User32Ex user32;
        String windowClass;
        String threadName;
        Thread currentThread;
        block21: {
            block22: {
                block19: {
                    block20: {
                        currentThread = Thread.currentThread();
                        threadName = currentThread.getName();
                        currentThread.setName("OH-window-message-handler");
                        windowClass = "OHMessageHandlerWindowClass";
                        user32 = User32Ex.INSTANCE;
                        hInst = Kernel32.INSTANCE.GetModuleHandle(null);
                        if (hInst == null) {
                            this.logger.debug("Failed to get module handle, aborting message window creation");
                            this.notifyTerminate();
                            currentThread.setName(threadName);
                            return;
                        }
                        WinUser.WNDCLASSEX wClass = new WinUser.WNDCLASSEX();
                        wClass.hInstance = hInst;
                        wClass.lpfnWndProc = this;
                        wClass.lpszClassName = windowClass;
                        if (user32.RegisterClassEx(wClass).intValue() == 0) {
                            this.logger.debug("Failed to register window class, aborting message window creation");
                            this.notifyTerminate();
                            currentThread.setName(threadName);
                            return;
                        }
                        hWnd = null;
                        hDevNotify = null;
                        hWnd = user32.CreateWindowEx(8, windowClass, "OH helper window, used only to receive window events", 0, 0, 0, 0, 0, null, null, (WinDef.HINSTANCE)hInst, null);
                        if (hWnd != null) break block19;
                        this.logger.debug("Failed to create window, aborting message window creation");
                        if (hDevNotify == null) break block20;
                        user32.UnregisterDeviceNotification(hDevNotify);
                    }
                    user32.UnregisterClass(windowClass, (WinDef.HINSTANCE)hInst);
                    if (hWnd != null) {
                        user32.DestroyWindow(hWnd);
                    }
                    this.notifyTerminate();
                    currentThread.setName(threadName);
                    return;
                }
                DBT.DEV_BROADCAST_DEVICEINTERFACE notificationFilter = new DBT.DEV_BROADCAST_DEVICEINTERFACE();
                notificationFilter.dbcc_size = notificationFilter.size();
                notificationFilter.dbcc_devicetype = 5;
                notificationFilter.dbcc_classguid = DBT.GUID_DEVINTERFACE_USB_DEVICE;
                hDevNotify = user32.RegisterDeviceNotification((WinNT.HANDLE)hWnd, (Structure)notificationFilter, 0);
                if (hDevNotify != null) break block21;
                this.logger.debug("Failed to register for device notification, terminating message window");
                if (hDevNotify == null) break block22;
                user32.UnregisterDeviceNotification(hDevNotify);
            }
            user32.UnregisterClass(windowClass, (WinDef.HINSTANCE)hInst);
            if (hWnd != null) {
                user32.DestroyWindow(hWnd);
            }
            this.notifyTerminate();
            currentThread.setName(threadName);
            return;
        }
        try {
            WinUser.MSG msg = new WinUser.MSG();
            WinNT.HANDLE[] handles = new WinNT.HANDLE[]{this.terminateEvent};
            boolean running = true;
            block8: while (running) {
                block3 : switch (user32.MsgWaitForMultipleObjects(handles.length, handles, false, -1, 7423)) {
                    case 0: {
                        this.logger.debug("Terminate event received, terminating message loop");
                        running = false;
                        user32.PostQuitMessage(0);
                        break;
                    }
                    case 1: {
                        while (user32.PeekMessage(msg, hWnd, 0, 0, 1)) {
                            if (msg.message == 18) {
                                user32.PostQuitMessage(msg.wParam.intValue());
                                running = false;
                                break block3;
                            }
                            user32.TranslateMessage(msg);
                            user32.DispatchMessage(msg);
                        }
                        continue block8;
                    }
                    default: {
                        int lastError = Native.getLastError();
                        this.logger.warn("An error ({}) occurred while waiting for a window message, terminating message loop: {}", (Object)lastError, (Object)Kernel32Util.formatMessage((int)lastError));
                        running = false;
                        user32.PostQuitMessage(0);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (hDevNotify != null) {
                user32.UnregisterDeviceNotification(hDevNotify);
            }
            user32.UnregisterClass(windowClass, (WinDef.HINSTANCE)hInst);
            if (hWnd != null) {
                user32.DestroyWindow(hWnd);
            }
            this.notifyTerminate();
            currentThread.setName(threadName);
            throw throwable;
        }
        if (hDevNotify != null) {
            user32.UnregisterDeviceNotification(hDevNotify);
        }
        user32.UnregisterClass(windowClass, (WinDef.HINSTANCE)hInst);
        if (hWnd != null) {
            user32.DestroyWindow(hWnd);
        }
        this.notifyTerminate();
        currentThread.setName(threadName);
    }

    public void terminate() {
        Kernel32.INSTANCE.SetEvent(this.terminateEvent);
    }

    private void notifyTerminate() {
        Set<WindowMessageListener> listeners = Set.copyOf(this.listeners);
        if (!listeners.isEmpty()) {
            this.createNotificationThread(() -> {
                for (WindowMessageListener listener : listeners) {
                    listener.serviceTerminated();
                }
            }).start();
        }
    }

    private Thread createNotificationThread(Runnable runnable) {
        return new Thread(runnable, "OH-window-message-notifier-" + this.threadCounter.incrementAndGet());
    }

    @NonNullByDefault(value={})
    public WinDef.LRESULT callback(WinDef.HWND hWnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (uMsg) {
            case 1: {
                this.logger.trace("Window message handler created");
                return new WinDef.LRESULT(0L);
            }
            case 2: {
                this.logger.trace("Window message handler destroyed");
                User32Ex.INSTANCE.PostQuitMessage(0);
                return new WinDef.LRESULT(0L);
            }
            case 537: {
                WinDef.LRESULT lResult = this.onDeviceChange(wParam, lParam);
                return lResult != null ? lResult : User32Ex.INSTANCE.DefWindowProc(hWnd, uMsg, wParam, lParam);
            }
        }
        return User32Ex.INSTANCE.DefWindowProc(hWnd, uMsg, wParam, lParam);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable WinDef.LRESULT onDeviceChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (wParam.intValue()) {
            case 32768: {
                return this.onDeviceAddedOrRemoved(lParam, true);
            }
            case 32772: {
                return this.onDeviceAddedOrRemoved(lParam, false);
            }
            case 7: {
                return new WinDef.LRESULT(1L);
            }
        }
        return null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable WinDef.LRESULT onDeviceAddedOrRemoved(WinDef.LPARAM lParam, boolean added) {
        DBT.DEV_BROADCAST_HDR bhdr = new DBT.DEV_BROADCAST_HDR(lParam.longValue());
        switch (bhdr.dbch_devicetype) {
            case 5: {
                DBT.DEV_BROADCAST_DEVICEINTERFACE bdif = new DBT.DEV_BROADCAST_DEVICEINTERFACE(bhdr.getPointer());
                Set<WindowMessageListener> listeners = Set.copyOf(this.listeners);
                if (listeners.isEmpty()) break;
                this.createNotificationThread(() -> {
                    for (WindowMessageListener listener : listeners) {
                        if (added) {
                            listener.deviceAdded(bdif.getDbcc_name());
                            continue;
                        }
                        listener.deviceRemoved(bdif.getDbcc_name());
                    }
                }).start();
                break;
            }
            case 3: {
                DBT.DEV_BROADCAST_PORT bpt = new DBT.DEV_BROADCAST_PORT(bhdr.getPointer());
                Set<WindowMessageListener> listeners = Set.copyOf(this.listeners);
                if (listeners.isEmpty()) break;
                this.createNotificationThread(() -> {
                    for (WindowMessageListener listener : listeners) {
                        if (added) {
                            listener.portAdded(bpt.getDbcpName());
                            continue;
                        }
                        listener.portRemoved(bpt.getDbcpName());
                    }
                }).start();
                break;
            }
            default: {
                return null;
            }
        }
        return new WinDef.LRESULT(1L);
    }

    public static interface WindowMessageListener {
        public void deviceAdded(String var1);

        public void deviceRemoved(String var1);

        public void portAdded(String var1);

        public void portRemoved(String var1);

        public void serviceTerminated();
    }
}

