/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.community;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.addon.marketplace.internal.community.SerializedNameAnnotationIntrospector;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.ui.components.RootUIComponent;
import org.openhab.core.ui.components.UIComponentRegistry;
import org.openhab.core.ui.components.UIComponentRegistryFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class CommunityUIWidgetAddonHandler
implements MarketplaceAddonHandler {
    private final Logger logger = LoggerFactory.getLogger(CommunityUIWidgetAddonHandler.class);
    private final ObjectMapper yamlMapper;
    private final UIComponentRegistry widgetRegistry;

    @Activate
    public CommunityUIWidgetAddonHandler(@Reference UIComponentRegistryFactory uiComponentRegistryFactory) {
        this.widgetRegistry = uiComponentRegistryFactory.getRegistry("ui:widget");
        this.yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.yamlMapper.findAndRegisterModules();
        this.yamlMapper.setDateFormat((DateFormat)new SimpleDateFormat("MMM d, yyyy, hh:mm:ss aa", Locale.ENGLISH));
        this.yamlMapper.setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)new SerializedNameAnnotationIntrospector(), this.yamlMapper.getSerializationConfig().getAnnotationIntrospector()));
    }

    @Override
    public boolean supports(String type, String contentType) {
        return "ui".equals(type) && "application/vnd.openhab.uicomponent;type=widget".equals(contentType);
    }

    @Override
    public boolean isInstalled(String id) {
        return this.widgetRegistry.getAll().stream().anyMatch(w -> w.hasTag(id));
    }

    @Override
    public void install(Addon addon) throws MarketplaceHandlerException {
        block5: {
            try {
                String yamlDownloadUrl = (String)addon.getProperties().get("yaml_download_url");
                String yamlContent = (String)addon.getProperties().get("yaml_content");
                if (yamlDownloadUrl != null) {
                    this.addWidgetAsYAML(addon.getUid(), this.getWidgetFromURL(yamlDownloadUrl));
                    break block5;
                }
                if (yamlContent != null) {
                    this.addWidgetAsYAML(addon.getUid(), yamlContent);
                    break block5;
                }
                throw new IllegalArgumentException("Couldn't find the widget in the add-on entry. The starting code fence may not be marked as ```yaml");
            }
            catch (IOException e) {
                this.logger.error("Widget from marketplace cannot be downloaded: {}", (Object)e.getMessage());
                throw new MarketplaceHandlerException("Widget cannot be downloaded.", e);
            }
            catch (Exception e) {
                this.logger.error("Widget from marketplace is invalid: {}", (Object)e.getMessage());
                throw new MarketplaceHandlerException("Widget is not valid.", e);
            }
        }
    }

    @Override
    public void uninstall(Addon addon) throws MarketplaceHandlerException {
        this.widgetRegistry.getAll().stream().filter(w -> w.hasTag(addon.getUid())).forEach(w -> this.widgetRegistry.remove((Object)w.getUID()));
    }

    private String getWidgetFromURL(String urlString) throws IOException {
        URL u = new URL(urlString);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = u.openStream();){
            return new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addWidgetAsYAML(String id, String yaml) {
        try {
            RootUIComponent widget = (RootUIComponent)this.yamlMapper.readValue(yaml, RootUIComponent.class);
            widget.addTag(id);
            this.widgetRegistry.add((Identifiable)widget);
        }
        catch (IOException e) {
            this.logger.error("Unable to parse YAML: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Unable to parse YAML");
        }
    }
}

