/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.codecs;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.logstash.StringInterpolation;

@LogstashPlugin(name="java_plain")
public class Plain
implements Codec {
    private static final PluginConfigSpec<String> CHARSET_CONFIG = PluginConfigSpec.stringSetting("charset", "UTF-8");
    private static final PluginConfigSpec<String> FORMAT_CONFIG = PluginConfigSpec.stringSetting("format");
    static final String MESSAGE_FIELD = "message";
    private Context context;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final Charset charset;
    private String format = null;
    private String id;
    private final CharBuffer charBuffer = ByteBuffer.allocateDirect(65536).asCharBuffer();
    private final CharsetDecoder decoder;

    public Plain(String id, Configuration configuration, Context context) {
        this(context, configuration.get(CHARSET_CONFIG), configuration.get(FORMAT_CONFIG), id != null && !id.isEmpty() ? id : UUID.randomUUID().toString());
    }

    public Plain(Configuration configuration, Context context) {
        this(null, configuration, context);
    }

    private Plain(Context context, String charsetName, String format, String id) {
        this.context = context;
        this.id = id;
        this.charset = Charset.forName(charsetName);
        this.format = format;
        this.decoder = this.charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.IGNORE);
    }

    @Override
    public void decode(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        if (buffer.position() < buffer.limit()) {
            this.decoder.decode(buffer, this.charBuffer, true);
            this.charBuffer.flip();
            eventConsumer.accept(this.simpleMap(this.charBuffer.toString()));
            this.charBuffer.clear();
        }
    }

    @Override
    public void flush(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        this.decode(buffer, eventConsumer);
    }

    @Override
    public void encode(Event event, OutputStream output) throws IOException {
        String outputString = this.format == null ? event.toString() : StringInterpolation.evaluate(event, this.format);
        output.write(outputString.getBytes(this.charset));
    }

    private Map<String, Object> simpleMap(String message) {
        this.map.put(MESSAGE_FIELD, message);
        return this.map;
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return Arrays.asList(CHARSET_CONFIG, FORMAT_CONFIG);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Codec cloneCodec() {
        return new Plain(this.context, this.charset.name(), this.format, UUID.randomUUID().toString());
    }
}

