/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableEnvironmentVariables
extends SystemFunctionCall
implements Callable {
    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return new SequenceExtent(AvailableEnvironmentVariables.getNames(context));
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new ListIterator(AvailableEnvironmentVariables.getNames(context));
    }

    public static List<StringValue> getNames(XPathContext context) {
        EnvironmentVariableResolver resolver = (EnvironmentVariableResolver)context.getConfiguration().getConfigurationProperty("http://saxon.sf.net/feature/environmentVariableResolver");
        ArrayList<StringValue> myList = new ArrayList<StringValue>();
        for (String s : resolver.getAvailableEnvironmentVariables()) {
            myList.add(new StringValue(s));
        }
        return myList;
    }
}

