/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.w3c.dom.Element;

abstract class NoRowsResultSetImpl
implements ResultSet {
    final Activation activation;
    private NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isOpen;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;
    private int firstColumn = -1;
    private int[] generatedColumnPositions;
    private DataValueDescriptor[] normalizedGeneratedValues;

    NoRowsResultSetImpl(Activation activation) {
        this.activation = activation;
        if (activation == null) {
            SanityManager.THROWASSERT((String)("activation is null in result set " + String.valueOf(this.getClass())));
        }
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        this.isOpen = true;
        StatementContext sc = this.lcc.getStatementContext();
        sc.setTopResultSet(this, this.subqueryTrackingArray);
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
        }
    }

    @Override
    public final boolean returnsRows() {
        return false;
    }

    @Override
    public long modifiedRowCount() {
        return 0L;
    }

    @Override
    public ResultDescription getResultDescription() {
        return null;
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    @Override
    public final ExecRow getAbsoluteRow(int row) throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"absolute"});
    }

    @Override
    public final ExecRow getRelativeRow(int row) throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"relative"});
    }

    @Override
    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"beforeFirst"});
    }

    @Override
    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"first"});
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"next"});
    }

    @Override
    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"previous"});
    }

    @Override
    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"last"});
    }

    @Override
    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException((String)"XCL01.S", (Object[])new Object[]{"afterLast"});
    }

    @Override
    public final void clearCurrentRow() {
    }

    @Override
    public final boolean checkRowPosition(int isType) {
        return false;
    }

    @Override
    public final int getRowNumber() {
        return 0;
    }

    public void close(boolean underMerge) throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit() && !this.activation.isClosed() && !this.lcc.getStatementContext().getStatementWasInvalidated()) {
            this.endExecutionTime = this.getCurrentTimeMillis();
            ResultSetStatisticsFactory rssf = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory();
            RunTimeStatistics rsImpl = rssf.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
            this.lcc.setRunTimeStatisticsObject(rsImpl);
            XPLAINVisitor visitor = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getXPLAINFactory().getXPLAINVisitor();
            visitor.doXPLAIN(rsImpl, this.activation);
        }
        int staLength = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int index = 0; index < staLength; ++index) {
            if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
            this.subqueryTrackingArray[index].close();
        }
        this.isOpen = false;
        if (this.activation.isSingleExecution() && !underMerge) {
            this.activation.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
    }

    @Override
    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int depth) {
        return MessageService.getTextMessage((String)"42Z47.U", (Object[])new Object[]{this.getClass().getName()});
    }

    @Override
    public long getTimeSpent(int type) {
        return 0L;
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateGenerationClauses(GeneratedMethod generationClauses, Activation activation, NoPutResultSet source, ExecRow newRow, boolean isUpdate) throws StandardException {
        if (generationClauses != null) {
            ExecRow oldRow = (ExecRow)activation.getCurrentRow(source.resultSetNumber());
            try {
                source.setCurrentRow(newRow);
                activation.setCurrentRow(newRow, source.resultSetNumber());
                generationClauses.invoke(activation);
                if (this.firstColumn < 0) {
                    this.firstColumn = NormalizeResultSet.computeStartColumn(isUpdate, activation.getResultDescription());
                }
                if (this.generatedColumnPositions == null) {
                    this.setupGeneratedColumns(activation, (ValueRow)newRow);
                }
                ResultDescription resultDescription = activation.getResultDescription();
                int count = this.generatedColumnPositions.length;
                for (int i = 0; i < count; ++i) {
                    int position = this.generatedColumnPositions[i];
                    DataValueDescriptor normalizedColumn = NormalizeResultSet.normalizeColumn(resultDescription.getColumnDescriptor(position).getType(), newRow, position, this.normalizedGeneratedValues[i], resultDescription);
                    newRow.setColumn(position, normalizedColumn);
                }
            }
            finally {
                if (oldRow == null) {
                    source.clearCurrentRow();
                } else {
                    source.setCurrentRow(oldRow);
                }
            }
        }
    }

    private void setupGeneratedColumns(Activation activation, ValueRow newRow) throws StandardException {
        ResultDescription resultDescription = activation.getResultDescription();
        int columnCount = resultDescription.getColumnCount();
        ExecRow emptyRow = newRow.getNewNullRow();
        int generatedColumnCount = 0;
        for (int i = 1; i <= columnCount; ++i) {
            ResultColumnDescriptor rcd;
            if (i < this.firstColumn || !(rcd = resultDescription.getColumnDescriptor(i)).hasGenerationClause()) continue;
            ++generatedColumnCount;
        }
        this.generatedColumnPositions = new int[generatedColumnCount];
        this.normalizedGeneratedValues = new DataValueDescriptor[generatedColumnCount];
        int idx = 0;
        for (int i = 1; i <= columnCount; ++i) {
            ResultColumnDescriptor rcd;
            if (i < this.firstColumn || !(rcd = resultDescription.getColumnDescriptor(i)).hasGenerationClause()) continue;
            this.generatedColumnPositions[idx] = i;
            this.normalizedGeneratedValues[idx] = emptyRow.getColumn(i);
            ++idx;
        }
    }

    public boolean doesCommit() {
        return false;
    }

    @Override
    public void addWarning(SQLWarning w) {
        this.getActivation().addWarning(w);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Element toXML(Element parentNode, String tag) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(parentNode, tag, this), this);
    }
}

