/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;

public class EmbedParameterSetMetaData
implements ParameterMetaData {
    private final ParameterValueSet pvs;
    private final DataTypeDescriptor[] types;
    private final int paramCount;

    protected EmbedParameterSetMetaData(ParameterValueSet pvs, DataTypeDescriptor[] types) {
        int paramCount = pvs.getParameterCount();
        this.pvs = pvs;
        this.paramCount = paramCount;
        this.types = types;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkPosition(param);
        if (this.types[param - 1].isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().isNumericTypeId();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkPosition(param);
        int outparamPrecision = -1;
        if (param == 1 && this.pvs.hasReturnOutputParameter()) {
            outparamPrecision = this.pvs.getPrecision(param);
        }
        if (outparamPrecision == -1) {
            return DataTypeUtilities.getPrecision(this.types[param - 1]);
        }
        return outparamPrecision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkPosition(param);
        if (param == 1 && this.pvs.hasReturnOutputParameter()) {
            return this.pvs.getScale(param);
        }
        return this.types[param - 1].getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().getJDBCTypeId();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().getSQLTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkPosition(param);
        return this.types[param - 1].getTypeId().getResultSetMetaDataTypeName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkPosition(param);
        if (param == 1 && this.pvs.hasReturnOutputParameter()) {
            return 4;
        }
        return this.pvs.getParameterMode(param);
    }

    private void checkPosition(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Util.generateCsSQLException("XCL13.S", parameterIndex, this.paramCount);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw Util.generateCsSQLException("XJ128.S", iface);
        }
    }
}

