/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.jfree.report.modules.misc.tablemodel.CSVTableModel;
import org.jfree.report.util.CSVTokenizer;

public class CSVTableModelProducer {
    private BufferedReader reader;
    private String separator;
    private CSVTableModel tableModel;
    private boolean columnNameFirst;

    public CSVTableModelProducer(InputStream inputStream) {
        this(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public CSVTableModelProducer(String string) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(string)));
    }

    public CSVTableModelProducer(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            throw new NullPointerException("The input stream must not be null");
        }
        this.reader = bufferedReader;
        this.separator = ",";
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public synchronized TableModel parse() throws IOException {
        String[] stringArray;
        String string;
        Object object;
        if (this.tableModel != null) {
            return this.tableModel;
        }
        this.tableModel = new CSVTableModel();
        if (this.columnNameFirst) {
            object = this.reader.readLine();
            if (object == null) {
                return this.tableModel;
            }
            this.tableModel.setColumnNames(this.splitLine((String)object));
        }
        object = new ArrayList();
        int n = 0;
        while ((string = this.reader.readLine()) != null) {
            stringArray = this.splitLine(string);
            if (stringArray.length > n) {
                n = stringArray.length;
            }
            ((ArrayList)object).add(stringArray);
        }
        this.close();
        stringArray = new Object[((ArrayList)object).size()][];
        ((ArrayList)object).toArray(stringArray);
        this.tableModel.setData((Object[][])stringArray);
        return this.tableModel;
    }

    private String[] splitLine(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, this.getSeparator());
        while (cSVTokenizer.hasMoreElements()) {
            arrayList.add(cSVTokenizer.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public TableModel getTableModel() throws IOException {
        return this.parse();
    }

    public boolean isColumnNameFirstLine() {
        return this.columnNameFirst;
    }

    public void setColumnNameFirstLine(boolean bl) {
        this.columnNameFirst = bl;
    }
}

