<?php
/**
 * DashboardsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * DashboardsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DashboardsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteDashboardsID
     *
     * Delete a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDashboardsID($dashboard_id, $zap_trace_span = null)
    {
        $this->deleteDashboardsIDWithHttpInfo($dashboard_id, $zap_trace_span);
    }

    /**
     * Operation deleteDashboardsIDWithHttpInfo
     *
     * Delete a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDashboardsIDWithHttpInfo($dashboard_id, $zap_trace_span = null)
    {
        $request = $this->deleteDashboardsIDRequest($dashboard_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDashboardsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDashboardsIDRequest($dashboard_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling deleteDashboardsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteDashboardsIDCellsID
     *
     * Delete a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to delete. (required)
     * @param  string $cell_id The ID of the cell to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDashboardsIDCellsID($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $this->deleteDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span);
    }

    /**
     * Operation deleteDashboardsIDCellsIDWithHttpInfo
     *
     * Delete a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to delete. (required)
     * @param  string $cell_id The ID of the cell to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $request = $this->deleteDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDashboardsIDCellsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to delete. (required)
     * @param  string $cell_id The ID of the cell to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling deleteDashboardsIDCellsID'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling deleteDashboardsIDCellsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteDashboardsIDLabelsID
     *
     * Delete a label from a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDashboardsIDLabelsID($dashboard_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteDashboardsIDLabelsIDWithHttpInfo($dashboard_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteDashboardsIDLabelsIDWithHttpInfo
     *
     * Delete a label from a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDashboardsIDLabelsIDWithHttpInfo($dashboard_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteDashboardsIDLabelsIDRequest($dashboard_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDashboardsIDLabelsID'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDashboardsIDLabelsIDRequest($dashboard_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling deleteDashboardsIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteDashboardsIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteDashboardsIDMembersID
     *
     * Remove a member from a dashboard
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDashboardsIDMembersID($user_id, $dashboard_id, $zap_trace_span = null)
    {
        $this->deleteDashboardsIDMembersIDWithHttpInfo($user_id, $dashboard_id, $zap_trace_span);
    }

    /**
     * Operation deleteDashboardsIDMembersIDWithHttpInfo
     *
     * Remove a member from a dashboard
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDashboardsIDMembersIDWithHttpInfo($user_id, $dashboard_id, $zap_trace_span = null)
    {
        $request = $this->deleteDashboardsIDMembersIDRequest($user_id, $dashboard_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDashboardsIDMembersID'
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDashboardsIDMembersIDRequest($user_id, $dashboard_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteDashboardsIDMembersID'
            );
        }
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling deleteDashboardsIDMembersID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteDashboardsIDOwnersID
     *
     * Remove an owner from a dashboard
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDashboardsIDOwnersID($user_id, $dashboard_id, $zap_trace_span = null)
    {
        $this->deleteDashboardsIDOwnersIDWithHttpInfo($user_id, $dashboard_id, $zap_trace_span);
    }

    /**
     * Operation deleteDashboardsIDOwnersIDWithHttpInfo
     *
     * Remove an owner from a dashboard
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDashboardsIDOwnersIDWithHttpInfo($user_id, $dashboard_id, $zap_trace_span = null)
    {
        $request = $this->deleteDashboardsIDOwnersIDRequest($user_id, $dashboard_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDashboardsIDOwnersID'
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDashboardsIDOwnersIDRequest($user_id, $dashboard_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteDashboardsIDOwnersID'
            );
        }
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling deleteDashboardsIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboards
     *
     * List all dashboards
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending descending (optional, default to false)
     * @param  string $owner A user identifier. Returns only dashboards where this user has the &#x60;owner&#x60; role. (optional)
     * @param  string $sort_by The column to sort by. (optional)
     * @param  string[] $id A list of dashboard identifiers. Returns only the listed dashboards. If both &#x60;id&#x60; and &#x60;owner&#x60; are specified, only &#x60;id&#x60; is used. (optional)
     * @param  string $org_id The identifier of the organization. (optional)
     * @param  string $org The name of the organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Dashboards|\InfluxDB2\Model\Error
     */
    public function getDashboards($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $owner = null, $sort_by = null, $id = null, $org_id = null, $org = null)
    {
        list($response) = $this->getDashboardsWithHttpInfo($zap_trace_span, $offset, $limit, $descending, $owner, $sort_by, $id, $org_id, $org);
        return $response;
    }

    /**
     * Operation getDashboardsWithHttpInfo
     *
     * List all dashboards
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending (optional, default to false)
     * @param  string $owner A user identifier. Returns only dashboards where this user has the &#x60;owner&#x60; role. (optional)
     * @param  string $sort_by The column to sort by. (optional)
     * @param  string[] $id A list of dashboard identifiers. Returns only the listed dashboards. If both &#x60;id&#x60; and &#x60;owner&#x60; are specified, only &#x60;id&#x60; is used. (optional)
     * @param  string $org_id The identifier of the organization. (optional)
     * @param  string $org The name of the organization. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Dashboards|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsWithHttpInfo($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $owner = null, $sort_by = null, $id = null, $org_id = null, $org = null)
    {
        $request = $this->getDashboardsRequest($zap_trace_span, $offset, $limit, $descending, $owner, $sort_by, $id, $org_id, $org);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Dashboards';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboards'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     * @param  bool $descending (optional, default to false)
     * @param  string $owner A user identifier. Returns only dashboards where this user has the &#x60;owner&#x60; role. (optional)
     * @param  string $sort_by The column to sort by. (optional)
     * @param  string[] $id A list of dashboard identifiers. Returns only the listed dashboards. If both &#x60;id&#x60; and &#x60;owner&#x60; are specified, only &#x60;id&#x60; is used. (optional)
     * @param  string $org_id The identifier of the organization. (optional)
     * @param  string $org The name of the organization. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsRequest($zap_trace_span = null, $offset = null, $limit = 20, $descending = false, $owner = null, $sort_by = null, $id = null, $org_id = null, $org = null)
    {
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling DashboardsService.getDashboards, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling DashboardsService.getDashboards, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling DashboardsService.getDashboards, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/dashboards';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($descending !== null) {
            $queryParams['descending'] = ObjectSerializer::toQueryValue($descending);
        }
        // query params
        if ($owner !== null) {
            $queryParams['owner'] = ObjectSerializer::toQueryValue($owner);
        }
        // query params
        if ($sort_by !== null) {
            $queryParams['sortBy'] = ObjectSerializer::toQueryValue($sort_by);
        }
        // query params
        if (is_array($id)) {
            $id = ObjectSerializer::serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboardsID
     *
     * Retrieve a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $include If &#x60;properties&#x60;, includes the cell view properties in the response. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getDashboardsID($dashboard_id, $zap_trace_span = null, $include = null)
    {
        list($response) = $this->getDashboardsIDWithHttpInfo($dashboard_id, $zap_trace_span, $include);
        return $response;
    }

    /**
     * Operation getDashboardsIDWithHttpInfo
     *
     * Retrieve a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $include If &#x60;properties&#x60;, includes the cell view properties in the response. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDWithHttpInfo($dashboard_id, $zap_trace_span = null, $include = null)
    {
        $request = $this->getDashboardsIDRequest($dashboard_id, $zap_trace_span, $include);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Dashboard';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $include If &#x60;properties&#x60;, includes the cell view properties in the response. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDRequest($dashboard_id, $zap_trace_span = null, $include = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($include !== null) {
            $queryParams['include'] = ObjectSerializer::toQueryValue($include);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboardsIDCellsIDView
     *
     * Retrieve the view for a cell
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getDashboardsIDCellsIDView($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        list($response) = $this->getDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getDashboardsIDCellsIDViewWithHttpInfo
     *
     * Retrieve the view for a cell
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $request = $this->getDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\View';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsIDCellsIDView'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling getDashboardsIDCellsIDView'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboardsIDLabels
     *
     * List all labels for a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getDashboardsIDLabels($dashboard_id, $zap_trace_span = null)
    {
        list($response) = $this->getDashboardsIDLabelsWithHttpInfo($dashboard_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getDashboardsIDLabelsWithHttpInfo
     *
     * List all labels for a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDLabelsWithHttpInfo($dashboard_id, $zap_trace_span = null)
    {
        $request = $this->getDashboardsIDLabelsRequest($dashboard_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsIDLabels'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDLabelsRequest($dashboard_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsIDLabels'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboardsIDMembers
     *
     * List all dashboard members
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error
     */
    public function getDashboardsIDMembers($dashboard_id, $zap_trace_span = null)
    {
        list($response) = $this->getDashboardsIDMembersWithHttpInfo($dashboard_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getDashboardsIDMembersWithHttpInfo
     *
     * List all dashboard members
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDMembersWithHttpInfo($dashboard_id, $zap_trace_span = null)
    {
        $request = $this->getDashboardsIDMembersRequest($dashboard_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsIDMembers'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDMembersRequest($dashboard_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsIDMembers'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboardsIDOwners
     *
     * List all dashboard owners
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error
     */
    public function getDashboardsIDOwners($dashboard_id, $zap_trace_span = null)
    {
        list($response) = $this->getDashboardsIDOwnersWithHttpInfo($dashboard_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getDashboardsIDOwnersWithHttpInfo
     *
     * List all dashboard owners
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDOwnersWithHttpInfo($dashboard_id, $zap_trace_span = null)
    {
        $request = $this->getDashboardsIDOwnersRequest($dashboard_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsIDOwners'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDOwnersRequest($dashboard_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsIDOwners'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDashboardsID
     *
     * Update a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  \InfluxDB2\Model\PatchDashboardRequest $patch_dashboard_request patch_dashboard_request (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDashboardsID($dashboard_id, $zap_trace_span = null, $patch_dashboard_request = null)
    {
        list($response) = $this->patchDashboardsIDWithHttpInfo($dashboard_id, $zap_trace_span, $patch_dashboard_request);
        return $response;
    }

    /**
     * Operation patchDashboardsIDWithHttpInfo
     *
     * Update a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  \InfluxDB2\Model\PatchDashboardRequest $patch_dashboard_request (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDashboardsIDWithHttpInfo($dashboard_id, $zap_trace_span = null, $patch_dashboard_request = null)
    {
        $request = $this->patchDashboardsIDRequest($dashboard_id, $zap_trace_span, $patch_dashboard_request);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Dashboard';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDashboardsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  \InfluxDB2\Model\PatchDashboardRequest $patch_dashboard_request (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDashboardsIDRequest($dashboard_id, $zap_trace_span = null, $patch_dashboard_request = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling patchDashboardsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($patch_dashboard_request)) {
            $_tempBody = $patch_dashboard_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDashboardsIDCellsID
     *
     * Update the non-positional information related to a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\CellUpdate $cell_update cell_update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDashboardsIDCellsID($dashboard_id, $cell_id, $cell_update, $zap_trace_span = null)
    {
        list($response) = $this->patchDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $cell_update, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchDashboardsIDCellsIDWithHttpInfo
     *
     * Update the non-positional information related to a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\CellUpdate $cell_update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $cell_update, $zap_trace_span = null)
    {
        $request = $this->patchDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $cell_update, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Cell';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDashboardsIDCellsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\CellUpdate $cell_update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $cell_update, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling patchDashboardsIDCellsID'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling patchDashboardsIDCellsID'
            );
        }
        // verify the required parameter 'cell_update' is set
        if ($cell_update === null || (is_array($cell_update) && count($cell_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_update when calling patchDashboardsIDCellsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($cell_update)) {
            $_tempBody = $cell_update;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDashboardsIDCellsIDView
     *
     * Update the view for a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDashboardsIDCellsIDView($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        list($response) = $this->patchDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $view, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchDashboardsIDCellsIDViewWithHttpInfo
     *
     * Update the view for a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        $request = $this->patchDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $view, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\View';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDashboardsIDCellsIDView'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling patchDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling patchDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'view' is set
        if ($view === null || (is_array($view) && count($view) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view when calling patchDashboardsIDCellsIDView'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($view)) {
            $_tempBody = $view;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDashboards
     *
     * Create a dashboard
     *
     * @param  \InfluxDB2\Model\CreateDashboardRequest $create_dashboard_request Dashboard to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error
     */
    public function postDashboards($create_dashboard_request, $zap_trace_span = null)
    {
        list($response) = $this->postDashboardsWithHttpInfo($create_dashboard_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDashboardsWithHttpInfo
     *
     * Create a dashboard
     *
     * @param  \InfluxDB2\Model\CreateDashboardRequest $create_dashboard_request Dashboard to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDashboardsWithHttpInfo($create_dashboard_request, $zap_trace_span = null)
    {
        $request = $this->postDashboardsRequest($create_dashboard_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Dashboard';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDashboards'
     *
     * @param  \InfluxDB2\Model\CreateDashboardRequest $create_dashboard_request Dashboard to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDashboardsRequest($create_dashboard_request, $zap_trace_span = null)
    {
        // verify the required parameter 'create_dashboard_request' is set
        if ($create_dashboard_request === null || (is_array($create_dashboard_request) && count($create_dashboard_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_dashboard_request when calling postDashboards'
            );
        }

        $resourcePath = '/api/v2/dashboards';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($create_dashboard_request)) {
            $_tempBody = $create_dashboard_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDashboardsIDCells
     *
     * Create a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\CreateCell $create_cell Cell that will be added (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postDashboardsIDCells($dashboard_id, $create_cell, $zap_trace_span = null)
    {
        list($response) = $this->postDashboardsIDCellsWithHttpInfo($dashboard_id, $create_cell, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDashboardsIDCellsWithHttpInfo
     *
     * Create a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\CreateCell $create_cell Cell that will be added (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDashboardsIDCellsWithHttpInfo($dashboard_id, $create_cell, $zap_trace_span = null)
    {
        $request = $this->postDashboardsIDCellsRequest($dashboard_id, $create_cell, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Cell';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDashboardsIDCells'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\CreateCell $create_cell Cell that will be added (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDashboardsIDCellsRequest($dashboard_id, $create_cell, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling postDashboardsIDCells'
            );
        }
        // verify the required parameter 'create_cell' is set
        if ($create_cell === null || (is_array($create_cell) && count($create_cell) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_cell when calling postDashboardsIDCells'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($create_cell)) {
            $_tempBody = $create_cell;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDashboardsIDLabels
     *
     * Add a label to a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postDashboardsIDLabels($dashboard_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postDashboardsIDLabelsWithHttpInfo($dashboard_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDashboardsIDLabelsWithHttpInfo
     *
     * Add a label to a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDashboardsIDLabelsWithHttpInfo($dashboard_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postDashboardsIDLabelsRequest($dashboard_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDashboardsIDLabels'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDashboardsIDLabelsRequest($dashboard_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling postDashboardsIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postDashboardsIDLabels'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDashboardsIDMembers
     *
     * Add a member to a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error
     */
    public function postDashboardsIDMembers($dashboard_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postDashboardsIDMembersWithHttpInfo($dashboard_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDashboardsIDMembersWithHttpInfo
     *
     * Add a member to a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDashboardsIDMembersWithHttpInfo($dashboard_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postDashboardsIDMembersRequest($dashboard_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMember';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDashboardsIDMembers'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDashboardsIDMembersRequest($dashboard_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling postDashboardsIDMembers'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postDashboardsIDMembers'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDashboardsIDOwners
     *
     * Add an owner to a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error
     */
    public function postDashboardsIDOwners($dashboard_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postDashboardsIDOwnersWithHttpInfo($dashboard_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDashboardsIDOwnersWithHttpInfo
     *
     * Add an owner to a dashboard
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDashboardsIDOwnersWithHttpInfo($dashboard_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postDashboardsIDOwnersRequest($dashboard_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwner';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDashboardsIDOwners'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDashboardsIDOwnersRequest($dashboard_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling postDashboardsIDOwners'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postDashboardsIDOwners'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putDashboardsIDCells
     *
     * Replace cells in a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\Cell[] $cell cell (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function putDashboardsIDCells($dashboard_id, $cell, $zap_trace_span = null)
    {
        list($response) = $this->putDashboardsIDCellsWithHttpInfo($dashboard_id, $cell, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putDashboardsIDCellsWithHttpInfo
     *
     * Replace cells in a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\Cell[] $cell (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function putDashboardsIDCellsWithHttpInfo($dashboard_id, $cell, $zap_trace_span = null)
    {
        $request = $this->putDashboardsIDCellsRequest($dashboard_id, $cell, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Dashboard';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putDashboardsIDCells'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\Cell[] $cell (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putDashboardsIDCellsRequest($dashboard_id, $cell, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling putDashboardsIDCells'
            );
        }
        // verify the required parameter 'cell' is set
        if ($cell === null || (is_array($cell) && count($cell) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell when calling putDashboardsIDCells'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($cell)) {
            $_tempBody = $cell;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
