/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Midi-Pyrenees for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_73 : {
					width : 172.01219,
					height : 163.17259,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = 14.83805;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 2971.1414;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-65" : "m 11.62,95.16 c -0.75,-0.04 -0.78,0.82 -1.23,1.14 -0.97,-0.08 -0.45,1.14 -0.44,1.67 -0.01,0.46 -0.14,1.47 0.65,1.16 0.74,-0.04 1.1,0.96 1.48,1.48 0.56,0.76 -0.56,1.91 0.42,2.43 0.23,0.41 0.47,0.83 0.82,1.16 -0.5,0.55 -1.88,0.11 -2.01,1.16 -0.34,0.7 -0.26,1.49 0.37,1.97 -0.27,0.26 -0.45,0.96 0.17,0.67 0.7,-0.66 0.89,-2.08 2.06,-2.14 0.39,0.31 0.13,1.09 0.64,1.42 -0.23,1.04 -0.58,2.2 -0.23,3.29 0.22,0.48 0.29,1.09 0.82,1.43 0.64,0.79 -0.44,1.9 -1.34,1.59 -1.06,-0.18 -1,1.1 -1.54,1.64 -0.39,0.61 0.01,1.27 0.62,1.45 1.02,0.8 -0.13,2.07 -0.53,2.92 -0.29,0.44 -0.25,1.43 -1.02,1.18 -0.74,0.32 -0.21,1.48 -0.38,2.09 0.36,1.02 -0.96,0.55 -1.31,1.26 -0.43,0.25 -0.47,-0.81 -0.9,-0.31 -0.45,0.46 -0.34,1.16 -0.81,1.59 -0.23,0.72 -0.32,1.57 -1.15,1.85 -0.42,0.26 -0.55,0.81 -1.1,0.79 -0.83,0.51 0.26,1.41 -0.32,2.07 -0.5,0.64 0.02,1.22 0.36,1.69 -0.46,0.39 -1.01,1.04 -1.63,1.06 -0.34,-0.41 -1.21,-0.45 -1.07,0.29 0.27,0.86 -0.37,1.5 -1.13,1.75 -0.96,1.06 -2.5e-4,2.63 0.02,3.83 0.23,0.61 -0.15,1.23 -0.77,1.27 -0.76,0.34 -1.5,1.22 -0.9,2.03 0.42,0.93 0.4,1.97 0.47,2.93 0.78,1.12 1.98,1.96 3.3,2.3 0.7,0.53 1.13,1.39 1.98,1.68 0.7,0.81 1.63,-0.82 2.22,-0.46 -0.65,1.04 0.24,1.97 0.86,2.73 0.69,0.72 0.69,2.41 1.98,2.26 0.85,0.13 0.91,1.08 1.3,1.65 0.83,0.4 1.9,0.85 2.82,0.56 0.3,-0.31 0.44,-0.85 1.03,-0.67 0.88,0.13 1.64,-0.21 2.33,-0.69 0.91,-0.43 1.94,-0.04 2.83,-0.61 0.67,-0.17 1.19,-0.68 1.76,-0.96 1.28,0.15 2.3,1.15 3.64,1.16 0.73,0.7 0.55,2.54 1.91,2.61 1.02,0.01 1.3,-1.1 1.46,-1.89 0.6,-0.32 1.41,-0.98 2.12,-0.7 0.84,0.49 1.05,1.77 2.19,1.75 0.84,0.09 2.16,0.15 2.55,-0.75 -0.22,-0.39 -0.05,-0.93 -0.59,-1.16 -0.37,-0.27 -1.06,-0.61 -1.09,-1.03 0.66,-0.32 0.12,-1.33 0.19,-1.89 -0.01,-2.01 -0.01,-4.12 0.34,-6.07 0.44,-0.41 0.29,-1.95 1.27,-1.32 0.44,0.45 1.09,0.47 1.62,0.79 0.8,0.27 1.71,-0.05 1.79,-1 0.56,-1.09 0.6,-2.43 1.26,-3.45 0.71,-0.62 1.61,-1.19 1.85,-2.16 -0.62,-0.19 -1.78,-0.85 -1.36,-1.65 0.93,-0.37 -0.02,-1.27 -0.04,-1.85 0.04,-0.66 -0.73,-1.69 -0.95,-0.52 -0.31,0.57 -1.19,0.13 -1.53,0.76 -0.29,0.41 -0.92,1.2 -1.36,0.5 -0.44,-0.32 0.29,-0.67 0.13,-1.11 -0.21,-0.73 0.34,-1.59 1.1,-1.36 0.39,-0.51 -0.1,-1.28 -0.04,-1.91 -0.23,-0.56 -0.96,-0.61 -1.33,-1.06 -0.53,-0.29 -1.2,-0.44 -1.31,-1.13 -0.43,-0.61 -1.41,-0.28 -1.89,-0.54 0.2,-0.57 -0.22,-0.93 -0.64,-1.13 0.34,-1.21 1.63,-1.98 2.41,-2.91 0.48,-0.43 1.26,-1.16 0.51,-1.74 0.32,-1.25 1.87,-0.48 2.72,-1.03 0.7,-0.5 -0.08,-1.18 -0.58,-1.4 0.29,-0.95 1.24,-1.74 1.98,-2.43 0.48,-0.23 0.84,-0.6 1.01,-1.08 0.49,-0.23 0.74,-0.88 0.03,-1.03 -0.82,-0.55 -1.74,-0.83 -2.63,-1.12 -0.71,-0.31 -1.5,-0.48 -2.27,-0.54 -0.45,0.09 -0.87,0.72 -1.26,0.13 -0.64,-0.43 -1.6,-0.79 -2.06,0.03 -0.68,0.28 -1.58,-0.08 -2.08,-0.53 0.09,-0.53 -0.15,-1.35 -0.85,-1.02 -0.63,0.04 -1.25,0.32 -1.76,0.57 -0.88,-0.06 0.01,-1.64 -0.97,-1.63 -0.67,0.14 -0.85,-0.5 -0.77,-1.03 -0.34,-0.58 -1.15,0.2 -1.62,0.29 -0.91,0.56 -2.2,1.11 -3.15,0.47 -0.49,0.15 -0.89,0.04 -0.83,-0.57 0.1,-0.57 -0.12,-1.51 -0.87,-1.23 -0.62,-0.51 -1.43,-1.66 -0.79,-2.43 0.39,-0.25 1.25,-0.47 0.81,-1.1 -0.64,-0.71 -1.54,-1.34 -1.44,-2.43 -0.07,-0.64 -0.4,-2.03 -1.31,-1.5 -0.57,0.36 -0.77,-0.75 -1.42,-0.49 -1.16,0.31 -1.06,-1.77 -2.27,-1.6 -0.39,-0.41 -0.48,-1.12 -0.9,-1.54 -0.24,-0.9 -0.08,-2.52 -1.39,-2.61 -0.33,-0.05 -0.67,-0.09 -1.01,-0.05 z",
					    "department-32" : "m 41.02,64.02 c -0.66,0.38 -0.9,1.38 -1.81,1.44 -0.66,0.25 -1.57,-0.53 -1.96,0.25 -0.7,-0.43 -1.92,-0.33 -2.43,0.36 -0.21,0.52 -0.34,1.16 -1.03,1.23 -0.91,0.21 -1.63,0.79 -2.35,1.32 -0.83,-0.38 -2.04,-0.39 -2.66,0.36 -0.23,0.85 -1.28,0.77 -1.88,0.34 -0.62,-0.46 -1.67,-0.33 -2.09,-1 -0.1,-1.02 -1.36,-0.51 -1.76,0.01 -0.79,0.61 -1.38,1.46 -1.53,2.41 -0.42,0.46 -1.36,-0.07 -1.09,-0.71 0.14,-0.6 -0.56,-0.89 -0.86,-0.35 -0.58,0.68 -1.79,0.24 -2.2,1.2 -0.71,0.84 -0.32,1.89 0.03,2.76 0.38,0.82 -0.05,2.55 -1.23,2.1 -1.15,-0.32 -2.02,-1.36 -2.98,-1.91 0.27,-0.63 1.49,-1.03 0.89,-1.87 -0.45,-0.43 -0.93,-1.46 -1.65,-1.26 -0.14,0.51 -0.41,0.97 -0.95,1.18 -0.43,0.46 -0.79,0.99 -1.48,0.98 -0.3,0.31 -0.31,1.37 -0.98,0.82 -0.61,-0.81 -1.83,-0.36 -2.43,0.16 -0.97,-0.59 -1.52,0.94 -2.27,1.29 -0.39,0.15 -1.09,0.29 -0.9,0.89 0.67,0.53 1.93,0.42 2.07,1.51 0.48,0.79 -0.71,0.27 -0.71,0.91 0.16,0.8 0.81,1.49 0.48,2.37 -0.03,0.46 -0.03,1.16 -0.71,0.92 -0.87,-0.03 -0.37,0.99 -0.34,1.46 -0.03,0.63 0.41,1.24 0.36,1.82 -0.58,0.7 1.18,0.77 0.52,1.54 -0.46,0.81 -1.38,1.24 -2.07,1.78 -0.13,0.62 0.23,1.35 -0.42,1.8 -0.17,0.58 0.95,0.84 0.37,1.52 -0.19,0.47 -0.95,0.58 -0.87,1.23 -0.15,0.49 -0.89,-0.09 -0.84,0.57 -0.18,0.92 0.83,1.14 1.52,1.11 0.16,0.52 -0.3,1.64 0.41,1.84 0.58,-0.1 1.15,-0.76 1.61,-0.07 0.62,0.19 1.12,-1.05 1.49,-0.18 0.82,0.71 2.1,0.41 3.08,0.31 0.28,-0.41 0.82,-0.23 1.16,-0.54 0.17,-0.42 0.14,-1 0.79,-0.91 0.73,-0.18 1.45,0.13 2.13,0.3 0.64,0.91 0.42,2.24 1.16,3.11 0.08,0.54 0.53,0.76 0.97,0.9 0.57,0.5 0.79,1.75 1.8,1.41 0.51,-0.26 0.57,0.19 0.73,0.53 0.5,0.28 1.15,-0.6 1.42,0.22 0.84,0.82 0.16,2.21 1.03,2.95 0.57,0.22 1.11,0.97 1.07,1.54 -0.43,0.43 -1.51,0.68 -1.12,1.5 0.22,0.74 0.83,1.28 1.58,1.29 0.36,0.51 0.08,1.24 0.33,1.74 0.42,0.02 0.81,-0.1 1.14,0.23 1.51,0.37 2.72,-1.2 4.17,-1.05 0.08,0.49 0.3,1.17 0.96,0.95 0.76,-0.2 0.34,1.03 0.58,1.39 0.33,0.68 1.45,-0.15 2.1,-0.25 0.6,-0.19 1.2,0.35 0.91,0.97 0.16,0.78 1.52,1.02 2.02,0.44 0.09,-0.81 1.06,-0.14 1.5,-0.03 0.51,0.35 1.17,0.59 1.62,0.04 1.33,0.02 2.5,0.78 3.77,1.02 1.29,0.51 3.1,0.37 3.79,-1.03 0.72,-0.89 1.08,-2.22 1.99,-2.89 0.88,0.38 1.45,-0.54 1.36,-1.32 0.32,-0.31 0.24,-0.83 0.32,-1.19 0.89,-0.37 1.54,0.67 2.35,0.68 0.45,-0.18 0.42,-1.09 1.05,-0.66 0.88,0.25 1.78,-0.26 2.62,0.27 0.78,0.09 1.58,0.26 1.98,1.03 0.34,0.64 1.12,0.48 1.63,0.74 0.14,0.47 0.1,1.41 0.88,1.23 1.02,-0.44 0.63,-1.86 0.49,-2.7 0.1,-0.82 1.53,-0.17 1.33,-1.09 -0.62,-0.68 0.45,-1.29 0.53,-1.98 0.44,-0.69 -0.8,-0.96 -0.7,-1.52 0.49,-0.76 1.55,-0.92 1.77,-1.91 0.24,-0.52 -0.73,-1.11 0.06,-1.42 0.58,-0.4 -0.24,-0.59 -0.33,-0.92 0.5,-0.09 1.15,-0.86 1.68,-0.28 0.31,0.59 1.25,0.43 1.08,-0.3 -0.25,-0.73 0.85,-0.37 1.22,-0.57 0.6,0.02 1.03,-0.47 1.02,-1 0.67,-0.11 2.04,0.6 1.75,-0.6 -0.03,-0.69 -0.35,-1.71 -1.11,-1.84 -0.53,0.62 -1.27,-0.02 -1.42,-0.65 -0.21,-0.48 0.24,-1.37 -0.58,-1.39 -0.63,0.19 -1.77,0.3 -1.97,-0.47 0.07,-0.32 0.74,-0.98 0.05,-1.03 -0.75,0.34 -1.28,-0.5 -1.81,-0.77 -0.26,-0.71 0.9,-1.33 0.27,-1.91 -0.53,-0.51 -1.68,-0.17 -1.78,-1.12 -0.42,-0.71 -1.31,-1.08 -1.56,-1.91 -0.92,-0.69 -1.09,-1.96 -1.92,-2.7 -0.46,-0.25 -0.86,0.04 -1.15,0.31 -0.45,0.23 -1.11,0.1 -0.88,-0.53 -0.03,-0.91 0.93,-1.53 0.94,-2.39 -0.2,-0.6 -1.35,-0.31 -1.07,-1.1 0.2,-0.38 0.66,-0.81 0.14,-1.19 -0.66,-0.52 -1.04,-1.6 -0.22,-2.14 0.06,-0.7 -0.87,-1.1 -1.35,-1.48 -0.48,-0.24 -0.81,0.46 -1.29,0.03 -0.57,-0.05 -0.77,-0.68 -1.24,-0.79 -0.61,-0.03 -1.65,0.99 -1.99,0.1 -0.39,-0.54 -0.41,-1.33 0.36,-1.53 0.91,-0.76 1.37,-1.91 2.18,-2.78 0.32,-0.31 0.29,-0.8 -0.06,-0.97 0.17,-0.44 -0.47,-1.15 0.16,-1.31 0.58,0.06 1.57,-0.17 1.42,-0.94 -0.34,-0.28 -0.88,-0.19 -1.2,-0.58 -1.11,-0.05 -1.92,1.22 -2.93,1.42 -0.67,-0.59 0.04,-1.65 -0.79,-2.14 -1.21,0.1 -2.59,0.89 -2.97,2.09 -0.31,0.39 -1.02,0.65 -1.19,-0.02 -0.7,-1.17 -1.64,-2.33 -2.83,-3.02 -0.09,-0.04 -0.18,-0.04 -0.27,-0.03 z",
					    "department-31" : "m 84.69,74.56 c -0.61,0.38 -0.86,1.18 -1.54,1.55 -0.27,0.26 -0.85,0.71 -0.84,0.03 -0.02,-0.67 -0.83,-0.52 -0.95,0.03 -0.41,0.66 -0.68,1.87 -1.74,1.55 -0.78,0.05 -1.12,-0.92 -1.94,-0.86 -0.52,-0.21 -1.41,-0.43 -1.42,0.42 -0.34,0.54 0.59,1.25 0.01,1.62 -0.63,0.2 -1.26,-0.1 -1.81,-0.27 -0.65,0.14 -0.85,1.19 -0.06,1.24 0.67,0.17 1.92,-0.38 1.99,0.7 0.42,0.86 -0.85,1.04 -1.41,1.27 -0.6,0.28 -1.13,0.69 -1.85,0.7 -0.61,0.11 -0.68,0.83 -1.33,0.95 -0.71,0.3 -1.49,0.91 -2.27,0.9 -0.53,-0.49 0.68,-1.11 -0.1,-1.42 -0.61,-0.06 -1.41,-0.08 -1.61,-0.79 -0.46,-0.61 -1.12,-1.57 -1.79,-0.58 -0.51,0.12 -0.58,0.97 -1.07,0.93 -0.47,-0.28 -1.05,-1.48 -1.63,-0.76 -0.32,0.69 -1.07,0.8 -1.7,0.54 -1.01,-0.07 -2,0.29 -2.78,0.88 -0.43,-0.11 -1.15,-0.03 -0.88,0.6 0.65,1.68 2.41,2.66 3.15,4.25 0.6,0.23 1.46,0.36 1.82,0.93 -0.29,0.65 -0.89,1.6 0.03,2.05 0.39,0.51 1.47,0.01 1.55,0.73 -0.17,0.33 -0.76,0.82 -0.13,1.02 0.69,0.47 1.83,-0.52 2.26,0.38 -0.03,0.68 -0.05,1.82 0.89,1.88 0.44,0.08 0.43,-0.67 0.8,-0.17 0.64,0.62 1.1,1.77 0.78,2.6 -0.69,0.21 -1.85,-0.16 -1.97,0.86 -0.63,0.41 -1.79,0.09 -2,1.02 -0.28,0.5 -1.06,0.84 -1.15,0.06 -0.38,-0.54 -1.65,0.12 -0.9,0.65 0.42,0.37 -0.05,0.72 -0.46,0.61 -0.69,0.46 1.13,1.08 0.27,1.29 -0.52,0.39 -0.58,1.18 -1.31,1.29 -1.02,0.37 -0.54,1.02 0.14,1.45 0.29,0.36 -0.38,0.79 -0.25,1.23 -0.29,0.45 -0.66,0.95 -0.28,1.47 0.04,0.8 -0.94,0.55 -1.39,0.8 -0.18,0.81 0.71,1.79 -0.02,2.56 -0.35,0.89 -1.64,0.43 -1.55,-0.42 0.01,-0.83 -0.97,-0.04 -1.24,-0.64 -0.56,-0.77 -1.28,-1.42 -2.27,-1.45 -0.64,-0.28 -1.34,-0.41 -1.97,-0.1 -0.52,-0.22 -1.28,-0.34 -1.48,0.39 -0.17,0.61 -0.91,-0.28 -1.26,-0.36 -0.55,-0.59 -1.36,-0.58 -1.26,0.34 -0.44,0.56 -0.19,1.45 -0.84,1.92 -0.35,0.64 -1.13,-0.57 -1.32,0.4 -0.92,1.23 -1.43,3.11 -2.97,3.7 -0.34,0.07 -1.35,-0.09 -0.95,0.48 0.4,0.16 0.82,0.73 0.19,0.91 -0.46,0.39 -0.47,1.17 -1.18,1.28 -0.56,0.26 -1.01,0.88 -1.24,1.35 -0.64,0.1 -1.11,1.21 -0.21,1.27 0.43,0.73 -0.2,1.61 -1.02,1.57 -0.41,-0.13 -0.64,0.33 -1.07,0.08 -0.67,-0.08 -0.84,0.65 -0.27,0.96 0.02,0.64 -0.92,1.08 -1.23,1.61 -0.64,0.84 -1.75,1.49 -2.09,2.45 0.43,0.33 0.74,0.81 0.88,1.24 0.82,-0.18 1.56,0.22 1.93,0.97 0.34,0.46 1.23,0.07 1.24,0.77 0.27,0.53 1.24,0.53 1.34,1.08 -0.61,0.6 0.36,1.66 0,2.28 -0.37,-0.19 -1.09,-0.54 -1.15,0.16 -0.06,0.63 -0.46,1.44 -0.11,2 0.81,-0.23 1.24,-1.38 2.23,-1.29 0.5,-0.1 0.12,-1.17 0.8,-0.77 0.74,0.53 0.56,1.6 1.09,2.31 0.3,0.56 -0.33,0.63 -0.47,1.02 -0.05,0.9 1.66,1.01 1.15,2.02 -0.5,1.05 -2.01,1.39 -2.05,2.7 -0.46,1.17 -0.64,2.62 -1.57,3.52 -1.03,0.13 -2.17,-0.34 -2.97,-0.96 -0.87,-0.04 -0.62,1 -0.96,1.49 -0.24,1.79 -0.25,3.65 -0.43,5.43 0.45,0.75 0.17,1.69 0.07,2.45 0.41,0.66 1.65,0.87 1.32,1.89 0.24,0.6 1.18,0.92 1.75,0.68 0.8,-0.95 2.17,0.09 3.18,-0.1 0.4,-0.16 0.72,-0.69 1.18,-0.31 0.95,0.32 2.22,0.78 3.14,0.22 0.51,-1.46 -0.21,-3 -1.22,-4.05 0.31,-0.5 0.76,-1.4 0.05,-1.71 1.31,-0.98 0.18,-2.87 1.1,-4 0.78,-0.53 1.98,-1.44 2.81,-0.49 0.9,1.19 2.42,0.6 3.66,0.8 0.31,0.37 1.05,0.86 1.24,0.1 -0.02,-0.73 -0.27,-1.67 -0.93,-2.02 -0.31,-0.68 0.34,-1.44 -0.14,-2.12 -0.36,-0.6 -0.57,-1.22 0.2,-1.5 0.52,-0.53 1.99,-0.08 1.94,-1.08 -0.02,-0.43 -0.78,-1.44 0.1,-1.33 0.96,0.21 1.58,-0.68 2.52,-0.54 1.55,-0.09 2.2,-1.71 2.88,-2.84 0.08,-0.57 -0.64,-0.72 -0.97,-0.88 -0.21,-1.06 -0.43,-2.33 -0.3,-3.36 0.61,0.12 1,-0.64 0.49,-1.02 -0.28,-0.57 0.63,-0.89 0.32,-1.5 0.73,-0.3 1.24,1.27 1.84,0.44 0.62,-0.71 0.25,-1.69 0.54,-2.45 0.27,-0.37 0.66,0.53 1.1,0.37 0.81,-0.15 1.61,-0.6 2.08,-1.22 0.83,0.2 1.25,1.94 2.27,1.15 0.63,-0.25 0.98,0.78 1.41,1.09 0.77,0.59 0.33,2.03 1.46,2.23 0.94,0.24 1.23,-0.68 1.39,-1.35 0.75,-0.17 1.68,-1.16 0.84,-1.81 -0.7,-0.9 -2.11,-0.65 -2.95,-1.14 0.02,-0.79 0.35,-1.68 0.67,-2.33 0.56,0 1.32,0.32 1.63,-0.31 0.84,-0.29 2.2,0.49 2.7,-0.47 0.44,-0.55 1.17,-0.96 1.84,-0.82 0.94,-0.46 0.53,-2.11 -0.58,-1.94 -0.52,-0.11 -1.21,-0.36 -1.58,-0.58 0.29,-0.87 -0.97,-0.59 -1.25,-1.01 0.44,-0.37 0.1,-0.86 0.05,-1.28 0.63,-0.58 1.1,-1.36 1.74,-1.91 0.67,-0.16 1.88,-0.09 1.83,0.85 0.54,1.35 2.36,1.97 2.48,3.49 -0.14,0.65 -0.52,1.64 0.34,1.98 0.6,0.4 1.5,0.69 1.94,-0.09 0.25,-0.42 0.64,-0.44 1.05,-0.35 0.28,-0.39 -0.55,-0.75 -0.08,-1.19 0.27,-0.62 -0.63,-1 -0.3,-1.68 0.02,-0.79 0.01,-1.78 1,-1.41 0.23,0.35 0.2,1.15 0.88,0.94 0.67,-0.32 0.98,0.35 1.27,0.83 0.58,0.39 0.3,-1.04 0.97,-0.66 0.28,0.4 0.9,0.27 1.21,0.7 0.52,0.25 1.8,0.29 1.36,1.19 -0.05,0.68 0.88,0.25 0.72,-0.26 -0.09,-0.76 0.33,-1.8 1.07,-2.02 0.91,0.45 1.94,-0.76 1.36,-1.57 0.23,-0.55 1.51,-0.62 0.97,-1.42 -0.13,-0.4 -0.27,-1.33 0.37,-1.07 0.44,0 0.47,-0.78 0.97,-0.41 0.36,0.3 0.83,0.48 1.16,0.15 0.43,-0.06 1.6,0.35 1.46,-0.44 -0.62,-0.62 -0.27,-1.73 -0.31,-2.53 0.03,-0.41 0.75,-0.38 0.56,-0.92 -0.19,-0.66 0.48,-1.1 1.04,-1.18 0.29,-0.44 0.08,-1.38 0.81,-1.42 0.87,0.22 1.07,1.23 1.71,1.78 0.31,0.39 -0.35,1.54 0.46,1.27 0.42,-0.58 0.33,-1.74 1.31,-1.75 1.04,-0.34 1.82,0.46 2.71,0.72 0.64,-0.1 1.09,-0.72 1.76,-0.74 0.27,-0.88 -1.07,-1.42 -0.8,-2.33 -0.14,-1.15 1.41,-1.27 1.44,-2.36 0.08,-0.49 -0.43,-0.42 -0.7,-0.42 -0.39,-0.64 -0.92,0.2 -0.76,0.67 0.06,1.07 -1.48,0.85 -1.96,0.25 -0.66,-0.32 -1.41,-0.33 -1.98,-0.84 -1.33,-0.21 -2.16,-1.41 -2.67,-2.55 -0.27,-0.57 -1.2,-0.63 -0.98,-1.42 0.08,-1.07 -1.11,-1.4 -1.95,-1.37 -1,-0.05 -1.47,-0.96 -2.25,-1.38 -1.01,-0.23 -1.68,-1.12 -2.69,-1.34 -0.59,-0.33 -0.63,-1.06 -0.16,-1.51 0.25,-0.68 1.37,-0.62 1.4,-1.36 -0.13,-0.82 -0.53,-1.82 -1.55,-1.7 -0.62,-0.05 -1.64,-0.1 -1.29,-1.03 0.65,0.25 1.84,-0.2 1.66,-1 -0.61,-0.85 -2.3,-1.14 -2.23,-2.4 0.48,-0.87 -0.71,-1.47 -0.37,-2.35 -0.01,-0.63 -0.9,-0.38 -1.23,-0.77 -0.8,-0.38 -1.62,-0.77 -1.2,-1.78 0.26,-0.91 -0.85,-0.92 -1.12,-1.59 -0.6,-0.69 -0.29,-1.67 -0.74,-2.38 -0.29,-0.55 0.27,-1.22 -0.09,-1.67 -0.08,-0.05 -0.17,-0.08 -0.27,-0.06 z",
					    "department-09" : "m 75.67,114.53 c -0.95,-0.02 -1.1,1.02 -1.72,1.51 -0.48,0.59 -0.48,2.03 0.59,1.82 0.47,-0.04 0.54,0.33 0.53,0.67 0.42,0.77 1.5,0.31 2.03,0.76 0.45,0.68 0.46,1.71 -0.41,2.06 -0.68,-0.14 -1.59,0.24 -1.7,0.98 -0.96,0.75 -2.43,-0.1 -3.41,0.75 -0.38,0.14 -0.91,-0.46 -1.1,0.24 -0.3,0.57 -0.79,1.78 0.21,1.93 0.95,0.1 1.97,0.25 2.49,1.15 0.2,0.24 0.83,0.95 0.14,0.9 -0.4,0.34 -0.66,0.83 -1.18,0.98 -0.21,0.42 -0.08,1.1 -0.74,1.15 -0.55,0.15 -1.44,0.39 -1.58,-0.44 -0.35,-0.81 -0.45,-1.74 -1.26,-2.27 -0.31,-0.4 -0.78,-0.54 -1.13,-0.21 -0.92,0.06 -1.23,-1.36 -2.09,-1.25 -0.26,0.58 -0.91,0.59 -1.33,1 -0.54,0.19 -1.55,-0.42 -1.64,0.49 -0.17,0.64 -0.28,1.63 -0.92,1.94 -0.56,-0.04 -1.18,-1.22 -1.45,-0.25 -0.38,0.48 -0.25,1.03 0.08,1.46 0.04,0.64 -1.09,0.29 -0.85,1.09 -0.11,0.52 0.21,0.91 0.44,1.28 0.18,0.49 -0.75,0.78 -0.14,1.26 0.57,0.18 1.14,0.83 1.28,1.28 -1.03,2e-4 -0.94,1.38 -1.66,1.87 -0.71,1.13 -2.2,0.63 -3.16,1.32 -0.45,0.13 -1.41,0.04 -1.11,0.8 0.4,0.55 0.08,1.27 -0.58,1.33 -0.59,0.16 -2.01,0.2 -1.7,1.15 0.4,0.66 0.72,1.41 0.32,2.14 0.02,0.62 0.8,0.92 0.81,1.61 0.11,0.88 0.36,1.85 1.34,2.13 1.11,0.43 1.88,1.47 2.97,1.87 0.59,0.12 0.56,-0.86 1.19,-0.57 0.85,0.29 1.55,1.04 2.53,0.89 1.04,0.23 2.08,0.53 3.17,0.38 0.83,0.45 1.91,1.01 2.24,1.97 0.13,1.03 0.6,2.47 1.75,2.69 1.24,-0.24 2.46,-1.06 3.73,-0.5 1.43,0.43 3.07,-0.33 4.41,0.31 0.36,0.47 0.11,1.4 0.93,1.47 1.1,0.25 1.04,1.7 1.76,2.39 0.63,1.21 0.45,3.2 2,3.68 0.89,0.15 1.25,-0.81 1.01,-1.53 -0.12,-0.53 -0.03,-1.59 0.66,-1.63 1.21,0.77 2.42,-0.61 3.61,-0.23 0.67,0.54 1.03,1.52 2.01,1.63 1.83,0.54 4.04,-0.05 5.66,1.01 0.17,0.52 -0.65,1.34 0.19,1.64 0.97,0.38 2.07,0.91 3.05,0.25 0.61,-0.44 1.58,0.64 1.93,-0.14 0.2,-0.45 1.06,-0.56 0.92,-1.26 0.02,-0.47 0.47,-0.9 0.88,-0.46 0.59,0.26 1.35,0.28 1.7,-0.32 0.4,-0.29 1.25,0.01 1.24,-0.71 0.29,-0.81 0.65,-1.69 1.2,-2.32 0.63,0.47 1.63,0.61 2.14,-0.12 1.2,-0.21 2.53,-0.04 3.66,-0.58 0.45,0.47 1.39,0.77 1.75,0.02 0.42,-0.7 0.09,-1.86 -0.8,-1.93 -0.92,-0.8 -1.87,-1.65 -2.81,-2.45 -0.12,-0.43 -0.2,-1 -0.81,-0.96 -1.01,-0.15 -1.69,0.9 -2.65,1.09 -0.96,0.21 -2.12,0.22 -2.98,-0.25 -0.43,-0.48 -0.9,-0.89 -1.48,-1.13 -0.46,-0.31 -0.37,-0.9 0.16,-1 0.18,-0.76 -0.67,-1.44 -1.02,-2.06 -0.35,-0.73 -1.68,-0.49 -1.75,-1.32 0.32,-0.53 0.63,-1.11 0.75,-1.71 1.19,-0.56 2.66,-0.28 3.87,-0.89 0.5,-0.16 1.21,-0.48 0.99,-1.11 0.05,-1.12 0.72,-2.85 -0.68,-3.41 -0.47,-0.32 -1.85,-0.23 -1.42,-1.1 0.14,-0.53 0.72,-0.64 1.12,-0.93 0.52,-0.03 1.22,-0.12 1.1,-0.84 0.09,-0.77 0.21,-1.71 -0.5,-2.19 0.03,-0.67 0.86,-1.34 0.25,-2.04 -0.34,-0.74 -1.69,-0.22 -1.61,-1.24 -0.25,-0.6 0.28,-0.58 0.63,-0.77 0.07,-0.56 -0.39,-1.1 -0.29,-1.71 -0.13,-0.6 0.25,-1.82 -0.69,-1.81 -0.39,-0.37 -1.08,-1.07 -1.5,-0.31 -0.1,0.35 -0.44,0.78 -0.67,0.24 -0.41,-0.43 -0.16,-1.37 -0.98,-1.35 -1.35,-0.16 -2.73,-0.43 -3.97,-0.96 -1.05,-0.65 -1.8,-1.94 -3.12,-2 -0.61,-0.74 0.84,-1.5 0.3,-2.35 -0.41,-0.75 -0.92,-1.45 -0.95,-2.34 -0.21,-0.6 -0.97,-1.87 -1.45,-0.81 -0.79,0.57 -0.11,1.86 -1.03,2.26 -0.82,0.2 0.02,-1.19 -0.78,-1.26 -0.84,-0.02 -1.4,-0.97 -2.26,-0.72 -0.3,0.15 -0.23,1.05 -0.67,0.61 -0.35,-0.49 -0.76,-1.38 -1.52,-0.94 -0.84,0.43 -0.34,-1.33 -1.19,-0.96 -0.55,0.69 -0.55,1.83 0.09,2.46 -0.2,0.37 -0.41,0.83 -0.05,1.16 0.21,0.38 0.02,1 -0.45,0.59 -0.89,-0.25 -1.06,1.54 -1.97,0.69 -0.75,-0.19 -1.77,-0.69 -1.41,-1.64 0.19,-0.64 0.38,-1.38 -0.27,-1.84 -0.95,-0.92 -1.83,-1.94 -2.53,-3.06 -0.17,-0.18 -0.43,-0.2 -0.66,-0.18 z",
					    "department-81" : "m 111.94,56.04 c -0.67,-0.02 -1.45,0.32 -1.36,1.05 -0.71,0.08 -1.46,-0.04 -2.05,-0.4 -0.67,0.17 0.26,1.29 -0.64,1.16 -0.52,-0.01 -0.79,0.42 -0.87,0.83 -1.07,0.6 -2.47,0.84 -3.7,0.64 -0.74,-0.1 -1.32,-1.44 -2.04,-0.82 -0.41,0.77 1.26,1.28 0.32,1.79 -0.41,0.5 -0.68,-0.46 -1.18,-0.35 -0.63,-0.3 -1.2,0.11 -1.79,0.12 -0.76,-0.27 -0.5,0.77 -0.32,1.14 0.22,0.34 -0.11,1.46 -0.5,0.77 -0.31,-0.52 -1.17,-1.22 -1.52,-0.36 -0.27,0.4 0.21,1.12 -0.54,1.09 -0.9,0.04 -1.28,-1.26 -2.28,-1.05 -1.12,0.06 -2.39,-0.3 -3.44,0.15 -0.5,0.79 0.79,1.27 0.49,2.06 -0.28,0.72 0.4,1.03 0.96,1.18 0.64,0.39 0.91,1.3 0.37,1.88 -0.24,0.73 -0.98,0.97 -1.4,1.5 -0.59,-0.05 -0.42,0.51 -0.43,0.87 -0.14,0.63 -0.94,0.15 -1.18,0.73 -0.5,0.46 -0.3,1.28 -0.54,1.77 -1.03,0.37 -2.18,-0.65 -3.1,-0.03 -0.89,0.56 -0.28,0.97 0.51,0.97 0.93,0.22 0.75,1.79 -0.12,1.99 -1.1,0.98 0.3,2.31 0.14,3.46 0.15,0.72 0.96,0.93 1.33,1.42 0.01,0.77 -0.19,1.77 0.76,2.09 0.46,0.4 1.2,0.38 1.65,0.68 -0.03,1.05 0.65,1.97 0.43,3.04 0.26,1.2 2.23,1.3 2.31,2.59 -0.26,0.7 -1.49,0.59 -1.59,1.26 0.76,0.46 2.42,-0.14 2.46,1.02 0.1,0.59 0.48,1.56 -0.38,1.75 -0.78,0.23 -1.7,1.65 -0.59,2.06 0.54,0.08 0.95,0.26 1.27,0.68 0.62,0.64 1.73,0.39 2.14,1.26 0.71,0.84 1.87,0.71 2.8,0.97 0.66,0.48 0.5,1.32 0.9,1.92 0.36,0.36 1.19,0.4 0.95,1.08 0.5,1.73 2.48,2.3 4.01,2.75 0.52,0.38 1.61,1.13 2,0.23 0.16,-0.37 -0.17,-1.21 0.27,-1.35 0.36,0.21 0.88,0.4 1.06,-0.07 0.84,0.49 0.43,1.98 -0.41,2.33 -0.97,0.84 -0.36,2.5 0.81,2.77 0.65,0.56 0.88,1.42 1.16,2.16 1.32,0.47 2.88,-0.12 3.84,-1.07 0.94,-0.19 1.12,1.21 1.83,1.55 0.33,0.42 0.93,0.57 1.03,-0.1 0.41,-0.59 0.3,-1.26 0.05,-1.85 0.31,-0.94 1.19,-1.75 1.81,-2.41 0.45,0.56 1.08,1.24 1.83,0.7 0.61,0.07 1.05,0.7 1.7,0.77 0.96,0.36 1.97,1.33 3.05,0.94 0.48,-0.77 1.45,-0.89 2.28,-0.81 0.84,-0.11 1.82,-0.54 2.47,0.27 1.11,0.57 2.6,0.59 3.73,0.06 0.56,-0.2 0.71,-0.84 1.29,-0.86 0.53,-0.3 1.18,-0.87 1.12,-1.48 0.32,-0.24 1.3,0.2 1.01,-0.51 -1.12,-1.19 0.71,-3.06 -0.72,-4.07 -0.53,-0.8 -1.96,-1.76 -1.14,-2.83 0.46,-0.61 -0.37,-1.19 -0.29,-1.75 0.9,-1.03 0.68,-2.7 1.44,-3.75 0.23,0.13 0.21,0.67 0.67,0.54 1.49,-0.22 3.09,0.53 3.73,1.9 0.44,0.93 1.22,0.02 1.78,-0.21 0.73,0.05 1.1,-0.78 1.74,-0.87 0.66,-0.01 1.21,-0.56 1.92,-0.5 0.64,-0.23 1.05,-0.91 1.83,-0.66 1.05,-0.29 0.41,-1.84 1.15,-2.47 0,-0.83 -0.43,-1.63 -0.44,-2.48 -0.39,-1.04 -1.72,-0.18 -2.39,-0.67 -0.63,-0.5 -1.51,-0.56 -2.08,-1.17 -0.89,-0.14 -1.41,0.78 -1.8,1.41 -0.81,0.35 -1.9,1.04 -2.59,0.2 -0.76,-0.69 -1.98,-0.14 -2.59,-1.1 -1.21,-1.12 -2.29,-2.39 -3,-3.87 -1.05,-1 -2.48,-2.43 -1.53,-3.96 0.81,-0.59 -0.55,-1.11 -0.86,-1.52 -0.06,-0.88 0.27,-1.99 -0.68,-2.54 -0.43,-0.53 -1.34,-0.55 -1.66,-1.11 0.25,-0.65 1.33,-1.05 0.91,-1.92 -0.33,-0.47 -1.05,-0.54 -1.15,-1.23 -0.09,-0.86 -0.25,-1.88 -1.15,-2.27 -0.39,-0.47 -0.23,-1.46 -1.13,-1.4 -0.87,-0.09 -1.74,-0.09 -1.67,-1.15 -0.41,-1.83 -2.79,-1.86 -3.51,-3.45 -0.52,-0.21 -1.75,0.61 -1.79,-0.42 0.24,-0.94 -0.88,-1.41 -1.58,-0.93 -0.48,0.27 -1,0.66 -1.53,0.29 -0.56,-0.27 -1.56,0.19 -1.94,-0.31 0.42,-0.59 1.41,-0.24 1.91,-0.82 1.1,-0.4 -0.45,-1.22 -0.99,-0.82 -0.51,0.61 -0.88,-0.31 -1.13,-0.66 -0.33,-0.37 -1.16,-0.05 -1.1,-0.74 -0.1,-0.36 -0.35,-0.74 -0.77,-0.66 z",
					    "department-82" : "m 65.17,43.24 c -0.85,0.05 -1.45,0.76 -2.24,0.9 -0.25,0.3 -0.07,0.93 -0.67,0.88 -1.1,0.18 -2.39,-0.39 -3.31,0.37 -0.59,0.14 -1.7,-0.13 -1.68,0.81 -0.32,-0.78 -0.49,-2.36 -1.62,-2.33 -0.68,0.44 -0.98,1.29 -0.59,2.01 0.33,1.03 -1.26,1.76 -0.8,2.76 0.52,-0.02 0.56,0.7 1.1,0.58 0.48,-0.18 0.93,-0.12 1.07,0.4 0.37,0.54 0.83,0.99 1.28,1.46 -0.69,0.38 -0.88,1.12 -1.06,1.79 -0.4,0.44 0.24,1.03 -0.18,1.52 -0.5,0.75 -0.48,2.37 -1.65,2.1 -0.51,-0.05 -1.82,-0.04 -1.47,0.79 0.29,0.57 0.94,0.27 1.37,0.39 0.38,0.58 -0.08,1.39 0.31,2.02 -0.14,0.5 -0.81,0.93 -1.23,1.1 -1,-0.28 -1.93,-1.36 -3.01,-1.14 -0.59,0.54 0.11,1.75 -0.37,2.08 -0.97,-0.31 -1.96,0.43 -1.97,1.42 -0.24,0.56 -0.82,1.29 0.01,1.69 0.52,0.56 0.12,1.65 0.77,2.04 0.95,-0.28 1.7,-1.35 2.69,-1.37 0.51,0.45 1.62,0.35 1.74,1.17 -0.36,0.19 -0.75,0.42 -1.06,0.71 -0.35,0.01 -0.94,-0.12 -0.83,0.47 0.1,0.85 0.36,1.88 -0.53,2.4 -0.73,0.78 -0.99,1.91 -2.02,2.37 -0.35,0.47 -0.01,1.76 0.75,1.29 0.59,-0.19 1.32,-0.71 1.76,0.03 0.39,0.35 1.07,0.75 1.48,0.27 0.94,0.05 1.66,1.1 2.33,1.49 -0.33,0.47 -1.21,0.9 -0.76,1.61 0.37,0.55 1.12,1.1 1.07,1.76 -0.38,-0.02 -0.83,0.41 -0.31,0.62 0.44,0.15 1.2,0.48 0.77,1.05 -0.38,0.69 -1.25,1.66 -0.73,2.45 0.64,0.29 0.97,-0.8 1.65,-0.38 0.74,0.16 1.64,0.42 2.19,-0.24 0.94,-0.42 2.01,-0.55 2.99,-0.28 0.62,-0.03 0.92,-1.13 1.51,-0.91 0.41,0.22 0.84,0.42 1.1,0.75 0.7,-0.16 1.07,-1.16 1.79,-1.19 0.95,0.42 1.12,1.79 2.26,1.84 0.61,-0.06 1.16,0.58 0.51,1 -0.11,0.72 0.96,0.13 1.27,0.02 0.56,-0.24 1.71,-0.53 1.29,-1.34 0.45,-0.44 1.26,0.07 1.8,-0.31 0.8,-0.46 2.26,-0.52 2.31,-1.7 -0.45,-1.01 -1.97,0.2 -2.49,-0.86 -0.69,-0.49 0.26,-0.89 0.68,-1.09 0.55,-0.08 1.12,0.68 1.68,0.2 0.44,-0.52 -0.62,-1.21 0.06,-1.76 0.29,-0.87 1.41,-0.22 2.03,-0.19 0.7,0.26 1.31,1.39 2.12,0.6 0.69,-0.55 0.91,-1.65 1.49,-2.15 0.57,0.12 0.35,0.99 0.89,0.99 0.54,-0.24 0.76,-0.87 1.29,-1.1 0.23,-0.43 0.36,-1.04 1,-0.75 0.93,0.41 1.34,-0.21 1.08,-1.04 -0.13,-0.84 -1.79,-0.3 -1.48,-1.36 0.14,-0.35 0.74,-0.46 1.11,-0.57 0.79,-0.04 1.86,0.69 2.53,0.07 -0.07,-0.76 0.38,-1.65 1.01,-2.05 0.8,0.36 0.58,-0.68 0.67,-1.09 0.57,-0.03 0.77,-0.53 1.27,-0.72 0.82,-0.66 1.11,-2.38 -0.19,-2.68 -0.98,0.01 -0.46,-1.07 -0.78,-1.62 -0.44,-0.5 -0.78,-1.52 -0.03,-1.9 0.99,0.1 1.98,-0.02 2.96,-0.05 0.43,0.29 1.06,-0.12 1.4,0.44 0.31,0.32 1.2,1.23 1.44,0.41 -0.05,-0.51 0.43,-1.18 0.83,-1.39 0.47,0.18 0.79,1.08 1.25,0.97 0.42,-0.59 -0.63,-1.7 0.21,-2.2 0.37,0.28 0.82,0.34 1.2,0.1 0.74,-0.14 1.38,0.27 2.01,0.55 0.67,-0.33 -0.24,-1.01 -0.47,-1.36 -0.11,-0.63 1.09,-0.7 1.41,-0.25 0.68,0.72 2.2,0.99 2.79,0.09 -0.23,-0.34 -0.95,-0.42 -0.8,-1.04 0.07,-0.83 -1.32,-0.75 -1.32,0.05 -0.64,0.29 -0.31,-1.14 -1.03,-0.95 -0.84,0.22 -0.64,-1.01 -1.21,-1.29 -0.56,-0.3 0.34,-0.54 0.55,-0.64 0.67,-0.6 0.88,-2.02 1.91,-2.07 0.8,0.01 0.73,-1.3 0.78,-1.88 -0.78,-0.5 -1.96,-0.09 -2.85,-0.37 -0.48,-0.14 -1.59,-0.27 -1.49,-0.96 0.74,-0.72 -0.7,-1.37 -0.35,-2.19 -0.2,-0.47 -1.34,-0.63 -1.45,0.08 -0.46,0.67 -1.35,-0.85 -1.84,0 -0.02,0.52 -0.65,1.27 -1.1,0.62 -0.5,-0.47 -1.19,-0.42 -1.67,0.03 -1.5,0.34 -2.58,1.47 -3.61,2.54 -0.37,0.46 -0.97,0.93 -1.41,0.28 -0.37,-0.43 -0.13,-1.22 -0.83,-1.4 -0.53,-0.44 -1.62,-0.3 -1.27,0.57 -0.14,0.38 -0.45,0.82 0.02,1.15 0.55,0.67 0.71,1.7 -0.1,2.22 -0.68,0.61 -2.05,0.73 -2.32,-0.37 -0.33,-0.59 0.17,-1.99 -0.93,-1.94 -0.44,0.28 -0.85,-0.12 -0.91,-0.54 -0.66,-0.21 -0.66,0.83 -1.19,0.99 -0.32,1.27 -1.82,1.61 -2.75,2.37 -0.77,0.32 -1.22,1.07 -1.76,1.61 -0.63,-0.53 -0.9,-1.76 -1.99,-1.59 -0.71,0.04 -1.93,-0.31 -1.38,-1.26 0.12,-0.57 1.01,-0.93 0.5,-1.57 -0.12,-0.39 0.53,-1.38 -0.27,-1.25 -0.48,0.39 -1.05,0.56 -1.57,0.81 -0.13,0.27 -0.1,0.92 -0.58,0.59 -0.27,-0.4 -0.74,-0.59 -1.15,-0.33 -0.9,-0.23 -1.79,-0.91 -1.94,-1.85 -0.58,-0.41 -1.36,-0.47 -1.95,-0.87 -0.82,0.02 -1.08,-0.87 -1.05,-1.55 -0.08,-0.68 -1.53,-0.47 -1.1,-1.24 0.25,-1.11 1.93,-0.56 2.2,-1.55 0.05,-0.49 -0.37,-0.74 -0.83,-0.66 z",
					    "department-12" : "m 139.51,7.44 c -0.97,0.07 -1.09,1.14 -1.57,1.74 -0.75,0.11 -1.54,0.43 -1.88,1.2 -0.28,0.41 -0.08,1.35 -0.86,1.18 -1.02,-0.37 -0.87,1.08 -1.48,1.5 -0.37,0.49 0.16,1.18 -0.42,1.57 -0.39,0.81 0.23,2.31 -0.89,2.63 -1.16,0.35 -1.15,1.92 -1.29,2.91 0.06,0.77 -0.03,1.56 -0.83,1.89 -1.04,0.94 -2.19,1.96 -2.27,3.46 -0.13,0.49 -0.67,0.77 -1.02,1.03 -0.48,-0.27 -0.96,-0.09 -1.32,0.23 -1.26,-0.37 -2.62,-0.35 -3.93,-0.18 -0.71,0.01 -0.78,-0.79 -0.93,-1.3 -0.98,-0.43 -2.24,-0.07 -3.2,0.34 -0.65,0.47 -2.03,-0.04 -2.15,1.04 -0.04,0.57 0.53,1.21 -0.07,1.65 -0.21,0.47 -0.16,0.91 -0.57,1.27 -0.06,0.52 -0.43,0.75 -0.92,0.53 -1.01,-0.18 -0.86,1.58 -1.94,1.22 -0.42,-0.16 -0.84,-0.37 -1.29,-0.05 -0.57,-0.01 -1.22,-1.16 -1.68,-0.3 -0.09,0.3 -0.58,0.85 -0.55,0.18 -0.25,-0.73 -0.92,0.23 -1.19,0.51 -0.2,0.5 -0.62,0.72 -1.14,0.63 -1.53,0.29 -1.56,2.34 -3.01,2.75 -0.38,0.3 -0.76,0.6 -1.16,0.8 -0.26,0.25 0.18,1.2 -0.36,1.01 -0.37,-0.34 -0.52,-1.75 -0.97,-0.97 -0.16,0.46 -0.16,1.35 -0.91,1.14 -0.62,-0.17 -1.64,0.31 -1.01,1.01 0.51,0.76 -0.3,1.91 0.67,2.46 0.97,0.8 0.13,2.35 1.06,3.23 0.29,0.62 1.26,1.07 1.15,1.79 -0.27,0.57 -1.21,0.46 -1.22,1.23 -0.26,0.35 -0.96,0.45 -0.79,1.07 0.13,0.62 0.87,1.1 0.38,1.76 0.26,0.89 1.58,0.7 2.31,0.83 0.63,0.11 1.64,-0.1 2.02,0.51 -0.26,0.69 -0.09,1.61 -0.53,2.19 -0.47,-0.27 -1.09,-0.29 -1.32,0.32 -0.33,0.68 -0.85,1.29 -1.23,1.89 -0.03,0.67 0.42,1.43 1.13,1.23 0.31,0.11 0.23,0.75 0.69,0.5 0.58,-0.34 1.81,-0.26 1.64,0.65 0.17,0.58 0.79,0.92 1.28,1.17 0.64,0.08 0.91,-0.52 1.05,-0.98 0.36,-0.26 1.3,0.04 1.11,-0.7 -0.33,-0.58 0.65,-0.92 0.94,-0.45 0.66,0.33 1.22,-0.15 1.66,-0.56 0.45,-0.05 0.83,-0.26 1.24,-0.41 0.95,-0.17 0.88,1.32 1.84,1.4 0.39,0.24 0.39,1.28 1.03,0.8 0.42,-0.5 1.27,0.09 1.61,0.46 0.19,0.62 -1.69,0.83 -0.83,1.34 0.79,0.56 1.55,-0.07 2.28,-0.34 0.79,-0.29 1.63,0.51 1.38,1.31 0.17,0.67 0.77,0.28 1.12,0.09 0.83,-0.04 0.95,1.1 1.67,1.36 0.58,0.46 1.4,0.47 1.8,1.19 0.46,0.5 0.73,1.13 0.77,1.76 0.63,0.56 1.91,0.13 2.31,0.94 -0.1,0.67 0.44,0.99 0.88,1.33 0.7,0.64 0.42,1.63 0.85,2.36 0.49,0.32 1.29,0.63 1.01,1.39 -0.04,0.67 -1.49,1.1 -0.53,1.56 0.8,0.59 2.23,1.23 1.89,2.47 -0.27,0.75 0.21,1.34 0.85,1.64 0.41,0.27 0.36,0.83 -0.12,0.98 -0.77,1.09 0.27,2.5 1.11,3.22 0.52,0.13 0.5,0.93 0.91,1.25 0.84,1.41 1.89,2.85 3.36,3.65 0.93,0.07 1.7,0.66 2.57,0.87 0.85,-0.01 1.79,-0.34 2.02,-1.24 0.56,-0.77 1.72,-0.85 2.34,-0.12 0.5,0.23 1.13,0.12 1.45,0.65 0.74,0.31 2.08,-0.31 2.32,0.77 0.15,0.86 0.16,2.08 0.9,2.54 0.93,-0.56 2.24,-1.52 3.26,-0.6 0.45,0.51 1.11,0.56 1.67,0.29 0.71,0.24 0.69,-0.75 0.34,-1.09 -0.08,-0.86 -0.37,-1.91 0.05,-2.68 0.75,-0.28 0.57,-1.13 0.09,-1.56 -0.2,-0.52 -0.44,-1.11 -0.51,-1.67 0.65,-0.5 0.14,-1.56 0.77,-2.01 1.11,-0.48 2.03,0.4 2.89,0.93 1.13,0.25 2.35,0.39 3.52,0.32 0.7,-0.39 1.92,-0.76 1.93,-1.72 -0.28,-0.47 -0.67,-0.93 -0.51,-1.56 0.13,-0.77 1.03,-1.1 1.24,-1.85 0.7,-0.73 1.82,0.08 2.69,-0.09 0.45,0.08 0.99,-0.12 0.89,-0.62 0.73,-0.84 0.3,-2.04 0.68,-2.97 0.65,-0.43 0.85,-1.48 1.77,-1.41 0.88,-0.34 0.74,-1.66 1.68,-1.99 0.7,-0.43 1.05,-1.55 0.16,-1.99 -0.73,-0.57 -1.56,-1 -2.32,-1.49 -0.72,-0.17 -2.13,0.34 -2.28,-0.7 0.08,-0.52 -0.42,-1.42 -0.95,-0.8 -0.3,0.36 -0.72,0.67 -1.02,0.1 -0.31,-0.51 -1.74,-1.15 -0.88,-1.61 0.57,-0.73 1.76,-0.31 2.26,-1 0.13,-0.71 -0.37,-1.57 0.32,-2.09 0.09,-0.95 1.01,-1.44 1.79,-1.78 0.25,-0.65 -0.24,-1.52 -0.74,-1.94 -0.83,-0.07 -1.68,-0.08 -2.5,-0.19 -0.84,0.46 -1.92,0.29 -2.78,0.82 -0.39,0.09 -1.21,0.09 -1.36,-0.23 0.46,-0.67 1.41,-2.05 0.33,-2.62 -0.72,-0.55 -1.64,-0.67 -2.45,-0.88 -0.31,-0.38 0.06,-1.56 -0.74,-1.38 -0.09,0.38 -0.72,0.57 -0.92,0.23 -0.27,-1.05 0.39,-1.87 0.92,-2.65 0.42,-0.88 -0.11,-1.76 -0.64,-2.43 -0.24,-0.48 0.01,-1 -0.31,-1.45 -0.12,-0.66 -0.4,-1.64 0.4,-2 0.55,-0.49 -0.1,-1.07 -0.25,-1.5 0.35,-0.48 0.88,-1.11 0.38,-1.7 -0.16,-1.15 -0.88,-2.23 -1.91,-2.8 -0.87,-0.56 -1.31,-1.31 -0.95,-2.35 -0.05,-1.22 0.92,-2.7 -0.22,-3.68 -1.03,-1.03 -2.18,-1.94 -2.81,-3.27 -0.42,-0.7 -1.05,-1.19 -1.71,-1.59 -1.36,-1.5 -1.87,-3.58 -2.02,-5.53 0.6,-0.58 0.24,-1.47 -0.46,-1.73 -0.22,-0.46 0.3,-0.59 0.62,-0.57 0.69,-0.55 -0.15,-2.04 -0.96,-1.24 -1,0.36 -1.22,-1.14 -1.47,-1.76 -0.38,-1.26 -0.98,-2.51 -0.91,-3.83 -1.12,0.09 -2.74,-0.34 -3.43,0.86 -0.55,0.43 -0.69,-0.73 -0.51,-1.08 0.42,-1.24 0.33,-2.97 -0.83,-3.78 -0.17,-0.1 -0.37,-0.13 -0.56,-0.11 z",
					    "department-46" : "m 84.19,0.11 c -1.02,0.15 -2.06,0.77 -2.57,1.62 -0.61,0.48 -1.43,0.01 -2.06,0.54 -1.14,0.23 -0.44,1.55 -0.5,2.35 -0.01,1.31 1.13,2.38 0.97,3.67 -0.53,0.07 -1.19,0.48 -0.81,1.1 0.36,0.51 1.46,1.44 0.62,2.01 -0.72,-0.04 -1.41,0.45 -1.32,1.23 -0.36,0.51 -1.17,0.56 -1.75,0.7 -0.7,0.66 0.54,2.24 -0.81,2.28 -0.79,0.36 -2.44,0.36 -2.2,1.64 -0.08,0.91 1.35,1.17 0.85,2.14 0.01,0.46 -0.23,0.75 -0.69,0.69 -0.48,0.38 -0.19,1.22 -0.76,1.61 -0.26,0.37 -0.77,-0.26 -1.06,0.2 -0.96,0.89 -1.76,2.32 -3.3,2.09 -0.66,-0.07 -1.16,0.28 -1.58,0.67 -0.86,0.15 -0.25,1.41 -0.34,1.96 0.23,1.09 -1.23,1.57 -1.76,2.39 -1.31,0.36 0.1,2.34 -0.92,2.32 -1,-0.08 -1.87,0.63 -2.62,1.21 -0.38,0.24 -0.7,1.01 -1.16,0.91 0.01,-0.6 -1.04,-0.95 -0.98,-0.18 0.28,1.17 1.68,2.14 1.18,3.46 -0.29,0.68 0.6,0.92 0.46,1.59 0,0.81 0.01,2.2 1.11,2.14 0.99,0.72 0.27,2.26 0.68,3.23 0.83,0.48 1.52,-0.73 2.39,-0.6 0.88,-0.41 0.89,0.62 0.8,1.22 -0.56,0.62 -2.25,0.36 -2.14,1.53 0.42,0.2 0.97,0.33 1.1,0.9 0.12,0.59 0.31,1.29 1.02,1.34 0.56,0.54 1.44,0.42 2.07,0.66 -0.15,1.08 0.93,1.93 1.91,2 0.48,-0.31 1.25,0.73 1.46,-0.08 -0.02,-0.67 0.92,-0.25 1.25,-0.65 0.3,-0.16 1.1,-0.78 1,-0.01 -0.05,0.79 0.37,1.9 -0.51,2.33 -0.73,0.64 0.04,1.73 0.91,1.49 0.99,-0.23 1.65,0.76 2.09,1.45 1.16,-1.2 2.8,-1.85 4.05,-2.97 0.47,-0.64 0.88,-1.32 1.4,-1.91 0.47,0.27 0.85,0.86 1.53,0.66 1.14,0.52 0.21,2.44 1.55,2.69 1.06,0.21 2.4,-0.94 1.59,-1.99 -0.22,-0.52 -0.85,-1.01 -0.32,-1.58 0.2,-0.36 -0.27,-0.9 0.33,-0.99 0.65,-0.21 1.44,0.11 1.92,0.49 -0.31,0.74 0.57,2.01 1.21,1.07 0.33,-0.46 -0.89,-1.01 -0.27,-1.27 0.56,-0.22 0.81,0.71 1.3,0.18 0.75,-0.71 1.54,-1.43 2.59,-1.57 0.48,-0.39 1.29,-0.84 1.78,-0.19 0.34,0.5 1.17,0.32 0.98,-0.32 0.18,-0.56 0.87,-0.99 1.28,-0.33 0.56,0.62 0.8,-0.53 1.4,-0.4 0.82,0.07 1.66,-0.1 2.11,-0.84 0.32,-0.24 1.12,-0.21 0.75,-0.83 -0.92,-1.01 -1.81,-2.25 -1.67,-3.73 -0.11,-0.86 -1.18,-1.28 -0.94,-2.24 0.09,-0.66 -0.32,-1.26 -0.45,-1.83 0.5,-0.55 1.27,-0.43 1.87,-0.67 0.26,-0.34 0.17,-1.42 0.84,-0.98 1.11,0.19 1.86,-0.78 2.76,-1.2 0.78,-0.89 1.33,-2.4 2.74,-2.3 0.69,-0.26 0.75,-1.24 1.56,-1.41 0.42,-0.18 0.93,0.35 1.12,-0.31 0.7,-0.22 1.14,1.03 1.88,0.49 0.56,-0.41 1.04,0.83 1.55,0.11 0.41,-0.45 0.57,-1.47 1.41,-1.14 0.64,0.2 0.53,-0.52 0.85,-0.77 0.77,-0.44 -0.28,-1.29 -0.65,-1.62 -1.01,-0.4 -1.06,-1.71 -0.79,-2.6 0.54,-0.59 -0.16,-1.56 -0.74,-1.84 -0.45,0.11 -1.27,0.04 -1.09,-0.62 0.53,-0.97 1.12,-1.95 0.92,-3.12 0.06,-0.57 -0.21,-1.45 0.55,-1.57 0.46,-0.77 0.28,-1.93 -0.21,-2.65 -0.81,-0.41 -1.25,-1.19 -1.62,-1.98 -0.81,-0.84 -1.55,-1.96 -1.82,-3.13 0.08,-0.68 1.34,-1.14 0.64,-1.89 -0.46,-0.49 -1.16,-0.97 -0.88,-1.74 -0.04,-1.12 -0.88,-2.48 -2.17,-2.11 -1.41,0.11 -2.62,0.86 -3.73,1.66 -0.55,0.05 -0.27,-0.94 -0.66,-1.2 -0.65,-0.78 -1.71,-0.13 -1.96,0.67 -0.32,0.9 -1.72,0.75 -2.14,1.62 -0.67,0.04 -0.88,0.89 -1.58,0.85 -0.27,0.31 -0.67,0.29 -0.59,-0.19 -0.36,-0.77 -0.89,0.64 -1.28,0.02 -0.5,-0.36 -0.82,-0.85 -0.84,-1.44 -0.36,-0.73 -1.22,-1.12 -1.9,-1.33 -0.23,-0.62 -0.42,-1.3 -1.01,-1.69 -0.04,-0.62 -0.87,-0.49 -1.11,-1.03 -0.61,-0.74 -1.34,-1.79 -2.45,-1.38 -0.77,-0.46 -1.93,-0.62 -2.56,0.18 -0.58,0.12 -0.54,-0.64 -0.79,-0.9 -0.09,-0.05 -0.19,-0.05 -0.28,-0.04 z"
					}
				}
			}
		}
	);
})(jQuery);