/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.type.BindableType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class BindingTypeHelper {
    private BindingTypeHelper() {
    }

    public static <T> BindableType<T> resolveTemporalPrecision(TemporalType precision, BindableType<T> declaredParameterType, BindingContext bindingContext) {
        TemporalJavaType<T> temporalJtd;
        if (precision != null && ((temporalJtd = BindingTypeHelper.getTemporalJavaType(declaredParameterType, bindingContext)) == null || temporalJtd.getPrecision() != precision)) {
            TypeConfiguration typeConfiguration = bindingContext.getTypeConfiguration();
            TemporalJavaType<T> temporalTypeForPrecision = BindingTypeHelper.getTemporalTypeForPrecision(precision, temporalJtd, typeConfiguration);
            return typeConfiguration.getBasicTypeRegistry().resolve(temporalTypeForPrecision, TemporalJavaType.resolveJdbcTypeCode(precision));
        }
        return declaredParameterType;
    }

    private static <T> TemporalJavaType<T> getTemporalTypeForPrecision(TemporalType precision, TemporalJavaType<T> temporalJtd, TypeConfiguration typeConfiguration) {
        if (temporalJtd == null || Date.class.isAssignableFrom(temporalJtd.getJavaTypeClass())) {
            JavaType descriptor = typeConfiguration.getJavaTypeRegistry().getDescriptor(TemporalJavaType.resolveJavaTypeClass(precision));
            return (TemporalJavaType)descriptor;
        }
        return temporalJtd.resolveTypeForPrecision(precision, typeConfiguration);
    }

    private static <T> TemporalJavaType<T> getTemporalJavaType(BindableType<T> declaredParameterType, BindingContext bindingContext) {
        if (declaredParameterType != null) {
            SqmBindableType<T> sqmExpressible = bindingContext.resolveExpressible(declaredParameterType);
            if (!JavaTypeHelper.isTemporal(sqmExpressible.getExpressibleJavaType())) {
                throw new UnsupportedOperationException("Cannot treat non-temporal parameter type with temporal precision");
            }
            return (TemporalJavaType)sqmExpressible.getExpressibleJavaType();
        }
        return null;
    }

    public static JdbcMapping resolveBindType(Object value, JdbcMapping baseType, TypeConfiguration typeConfiguration) {
        if (value == null || !JavaTypeHelper.isTemporal(baseType.getJdbcJavaType())) {
            return baseType;
        }
        Class<?> javaType = value.getClass();
        TemporalJavaType temporalJavaType = (TemporalJavaType)baseType.getJdbcJavaType();
        TemporalType temporalType = temporalJavaType.getPrecision();
        BindableType bindableType = (BindableType)((Object)baseType);
        return switch (temporalType) {
            default -> throw new IncompatibleClassChangeError();
            case TemporalType.TIMESTAMP -> (JdbcMapping)((Object)BindingTypeHelper.resolveTimestampTemporalTypeVariant(javaType, bindableType, typeConfiguration));
            case TemporalType.DATE -> (JdbcMapping)((Object)BindingTypeHelper.resolveDateTemporalTypeVariant(javaType, bindableType, typeConfiguration));
            case TemporalType.TIME -> (JdbcMapping)((Object)BindingTypeHelper.resolveTimeTemporalTypeVariant(javaType, bindableType, typeConfiguration));
        };
    }

    private static BindableType<?> resolveTimestampTemporalTypeVariant(Class<?> javaType, BindableType<?> baseType, TypeConfiguration typeConfiguration) {
        if (baseType.getJavaType().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.TIMESTAMP);
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT);
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.ZONED_DATE_TIME);
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIMESTAMP");
    }

    private static BindableType<?> resolveDateTemporalTypeVariant(Class<?> javaType, BindableType<?> baseType, TypeConfiguration typeConfiguration) {
        if (baseType.getJavaType().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR_DATE);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DATE);
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT);
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.ZONED_DATE_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#DATE");
    }

    private static BindableType<?> resolveTimeTemporalTypeVariant(Class<?> javaType, BindableType<?> baseType, TypeConfiguration typeConfiguration) {
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR_TIME);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.TIME);
        }
        if (LocalTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LOCAL_TIME);
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIME");
    }
}

