/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmInListPredicate<T>
extends AbstractNegatableSqmPredicate
implements SqmInPredicate<T> {
    private final SqmExpression<T> testExpression;
    private final List<SqmExpression<T>> listExpressions;

    public SqmInListPredicate(SqmExpression<T> testExpression, NodeBuilder nodeBuilder) {
        this(testExpression, new ArrayList(), nodeBuilder);
    }

    public SqmInListPredicate(SqmExpression<T> testExpression, NodeBuilder nodeBuilder, SqmExpression<T> ... listExpressions) {
        this(testExpression, ArrayHelper.toExpandableList(listExpressions), nodeBuilder);
    }

    public SqmInListPredicate(SqmExpression<T> testExpression, List<? extends SqmExpression<T>> listExpressions, NodeBuilder nodeBuilder) {
        this(testExpression, listExpressions, false, nodeBuilder);
    }

    public SqmInListPredicate(SqmExpression<T> testExpression, List<? extends SqmExpression<T>> listExpressions, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.testExpression = testExpression;
        this.listExpressions = listExpressions;
        for (SqmExpression<T> listExpression : listExpressions) {
            this.implyListElementType(listExpression);
        }
    }

    @Override
    public SqmInListPredicate<T> copy(SqmCopyContext context) {
        SqmInListPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmSelectableNode> listExpressions = new ArrayList<SqmSelectableNode>(this.listExpressions.size());
        for (SqmExpression<T> listExpression : this.listExpressions) {
            listExpressions.add(listExpression.copy(context));
        }
        SqmInListPredicate<T> predicate = context.registerCopy(this, new SqmInListPredicate<T>(this.testExpression.copy(context), listExpressions, this.isNegated(), this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    @Override
    public SqmExpression<T> getTestExpression() {
        return this.testExpression;
    }

    @Override
    public SqmExpression<T> getExpression() {
        return this.getTestExpression();
    }

    @Override
    public SqmInPredicate<T> value(Object value) {
        if (value instanceof Collection) {
            for (Object v : (Collection)value) {
                this.addExpression(this.nodeBuilder().value(v, this.testExpression));
            }
        } else {
            this.addExpression(this.nodeBuilder().value(value, this.testExpression));
        }
        return this;
    }

    @Override
    public SqmInPredicate<T> value(Expression<? extends T> value) {
        this.addExpression((SqmExpression)value);
        return this;
    }

    @Override
    public SqmInPredicate<T> value(JpaExpression<? extends T> value) {
        this.addExpression((SqmExpression)value);
        return this;
    }

    public List<? extends SqmExpression<T>> getListExpressions() {
        return this.listExpressions;
    }

    public void addExpression(SqmExpression<T> expression) {
        this.implyListElementType(expression);
        this.listExpressions.add(expression);
    }

    private void implyListElementType(SqmExpression<?> expression) {
        TypecheckUtil.assertComparable(this.getTestExpression(), expression, this.nodeBuilder());
        expression.applyInferableType(QueryHelper.highestPrecedenceType2(this.getTestExpression().getExpressible(), expression.getExpressible()));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInListPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        this.testExpression.appendHqlString(hql, context);
        if (this.isNegated()) {
            hql.append(" not");
        }
        hql.append(" in (");
        this.listExpressions.get(0).appendHqlString(hql, context);
        for (int i = 1; i < this.listExpressions.size(); ++i) {
            hql.append(", ");
            this.listExpressions.get(i).appendHqlString(hql, context);
        }
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmInListPredicate)) return false;
        SqmInListPredicate that = (SqmInListPredicate)object;
        if (this.isNegated() != that.isNegated()) return false;
        if (!Objects.equals(this.testExpression, that.testExpression)) return false;
        if (!Objects.equals(this.listExpressions, that.listExpressions)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isNegated(), this.testExpression, this.listExpressions);
    }

    @Override
    protected SqmNegatablePredicate createNegatedNode() {
        return new SqmInListPredicate<T>(this.testExpression, this.listExpressions, !this.isNegated(), this.nodeBuilder());
    }
}

