/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ClipAnim
extends AnimatingControlsSurface {
    private static Image dimg;
    private static Image cimg;
    static TexturePaint texturePaint;
    private AnimVal[] animval = new AnimVal[3];
    protected boolean doObjects = true;
    private Font originalFont = new Font("Serif", 0, 12);
    private Font font;
    private GradientPaint gradient;
    private int strX;
    private int strY;
    private int dukeX;
    private int dukeY;
    private int dukeWidth;
    private int dukeHeight;

    public ClipAnim() {
        cimg = this.getImage("clouds.jpg");
        dimg = this.getImage("duke.png");
        this.setBackground(Color.WHITE);
        this.animval[0] = new AnimVal(true);
        this.animval[1] = new AnimVal(false);
        this.animval[2] = new AnimVal(false);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void reset(int w, int h) {
        for (AnimVal a : this.animval) {
            a.reset(w, h);
        }
        this.gradient = new GradientPaint(0.0f, h / 2, Color.RED, (float)w * 0.4f, (float)h * 0.9f, Color.YELLOW);
        double scale = 0.4;
        this.dukeHeight = (int)(scale * (double)h);
        this.dukeWidth = (int)((double)dimg.getWidth(this) * scale * (double)h / (double)dimg.getHeight(this));
        this.dukeX = (int)((double)w * 0.25 - (double)(this.dukeWidth / 2));
        this.dukeY = (int)((double)h * 0.25 - (double)(this.dukeHeight / 2));
        FontMetrics fm = this.getFontMetrics(this.originalFont);
        double sw = fm.stringWidth("CLIPPING");
        double sh = fm.getAscent() + fm.getDescent();
        double sx = (double)(w / 2 - 30) / sw;
        double sy = (double)(h / 2 - 30) / sh;
        AffineTransform Tx = AffineTransform.getScaleInstance(sx, sy);
        this.font = this.originalFont.deriveFont(Tx);
        fm = this.getFontMetrics(this.font);
        this.strX = (int)((double)w * 0.75 - (double)(fm.stringWidth("CLIPPING") / 2));
        this.strY = (int)((double)h * 0.72 + (double)(fm.getAscent() / 2));
    }

    @Override
    public void step(int w, int h) {
        for (AnimVal a : this.animval) {
            if (!a.isSelected) continue;
            a.step(w, h);
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        GeneralPath p1 = new GeneralPath();
        GeneralPath p2 = new GeneralPath();
        for (AnimVal a : this.animval) {
            if (!a.isSelected) continue;
            double x = a.x;
            double y = a.y;
            double ew = a.ew;
            double eh = a.eh;
            p1.append(new Ellipse2D.Double(x, y, ew, eh), false);
            p2.append(new Rectangle2D.Double(x + 5.0, y + 5.0, ew - 10.0, eh - 10.0), false);
        }
        if (this.animval[0].isSelected || this.animval[1].isSelected || this.animval[2].isSelected) {
            g2.setClip(p1);
            g2.clip(p2);
        }
        if (this.doObjects) {
            int w2 = w / 2;
            int h2 = h / 2;
            g2.drawImage(cimg, 0, 0, w2, h2, null);
            g2.drawImage(dimg, this.dukeX, this.dukeY, this.dukeWidth, this.dukeHeight, null);
            g2.setPaint(texturePaint);
            g2.fillRect(w2, 0, w2, h2);
            g2.setPaint(this.gradient);
            g2.fillRect(0, h2, w2, h2);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRect(w2, h2, w2, h2);
            g2.setColor(Color.RED);
            g2.drawOval(w2, h2, w2 - 1, h2 - 1);
            g2.setFont(this.font);
            g2.drawString("CLIPPING", this.strX, this.strY);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRect(0, 0, w, h);
        }
    }

    public static void main(String[] argv) {
        ClipAnim.createDemoFrame(new ClipAnim());
    }

    static {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        Graphics2D big = bi.createGraphics();
        big.setBackground(Color.YELLOW);
        big.clearRect(0, 0, 5, 5);
        big.setColor(Color.RED);
        big.fillRect(0, 0, 3, 3);
        texturePaint = new TexturePaint(bi, new Rectangle(0, 0, 5, 5));
    }

    public class AnimVal {
        double ix = 5.0;
        double iy = 3.0;
        double iw = 5.0;
        double ih = 3.0;
        double x;
        double y;
        double ew;
        double eh;
        boolean isSelected;

        public AnimVal(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void step(int w, int h) {
            this.x += this.ix;
            this.y += this.iy;
            this.ew += this.iw;
            this.eh += this.ih;
            if (this.ew > (double)(w / 2)) {
                this.ew = w / 2;
                this.iw = Math.random() * (double)(-w) / 16.0 - 1.0;
            }
            if (this.ew < (double)(w / 8)) {
                this.ew = w / 8;
                this.iw = Math.random() * (double)w / 16.0 + 1.0;
            }
            if (this.eh > (double)(h / 2)) {
                this.eh = h / 2;
                this.ih = Math.random() * (double)(-h) / 16.0 - 1.0;
            }
            if (this.eh < (double)(h / 8)) {
                this.eh = h / 8;
                this.ih = Math.random() * (double)h / 16.0 + 1.0;
            }
            if (this.x + this.ew > (double)w) {
                this.x = (double)w - this.ew - 1.0;
                this.ix = Math.random() * (double)(-w) / 32.0 - 1.0;
            }
            if (this.y + this.eh > (double)h) {
                this.y = (double)h - this.eh - 2.0;
                this.iy = Math.random() * (double)(-h) / 32.0 - 1.0;
            }
            if (this.x < 0.0) {
                this.x = 2.0;
                this.ix = Math.random() * (double)w / 32.0 + 1.0;
            }
            if (this.y < 0.0) {
                this.y = 2.0;
                this.iy = Math.random() * (double)h / 32.0 + 1.0;
            }
        }

        public void reset(int w, int h) {
            this.x = Math.random() * (double)w;
            this.y = Math.random() * (double)h;
            this.ew = Math.random() * (double)w / 2.0;
            this.eh = Math.random() * (double)h / 2.0;
        }
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        ClipAnim demo;
        JToolBar toolbar;

        public DemoControls(ClipAnim demo) {
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Objects", true);
            this.addTool("Clip1", true);
            this.addTool("Clip2", false);
            this.addTool("Clip3", false);
        }

        public void addTool(String str, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            if (b.getText().equals("Objects")) {
                this.demo.doObjects = b.isSelected();
            } else if (b.getText().equals("Clip1")) {
                this.demo.animval[0].isSelected = b.isSelected();
            } else if (b.getText().equals("Clip2")) {
                this.demo.animval[1].isSelected = b.isSelected();
            } else if (b.getText().equals("Clip3")) {
                this.demo.animval[2].isSelected = b.isSelected();
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
            ((AbstractButton)this.toolbar.getComponentAtIndex(2)).doClick();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.getSize().width > 400) {
                ((AbstractButton)this.toolbar.getComponentAtIndex(3)).doClick();
            }
            this.thread = null;
        }
    }
}

