/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.system.OS;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class FileSystemUtil {
    private static final Logger LOG = Logger.getInstance(FileSystemUtil.class);
    private static volatile boolean WINDOWS_CS_API_AVAILABLE = true;
    private static volatile boolean MAC_CS_API_AVAILABLE = true;
    private static volatile boolean LINUX_CS_API_AVAILABLE = true;
    private static volatile boolean ourLibExt2FsPresent = true;

    private FileSystemUtil() {
    }

    @ApiStatus.Obsolete
    @Nullable
    public static FileAttributes getAttributes(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(0);
        }
        path = FileSystemUtil.normalizePath(path);
        try {
            return FileSystemUtil.getAttributes(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            LOG.debug(e);
            return null;
        }
    }

    private static String normalizePath(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(1);
        }
        if (OS.CURRENT == OS.Windows && path.length() == 2 && path.charAt(1) == ':') {
            path = path + '\\';
        }
        return path;
    }

    @ApiStatus.Obsolete
    @Nullable
    public static FileAttributes getAttributes(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(2);
        }
        return FileSystemUtil.getAttributes(file.toPath());
    }

    @ApiStatus.Obsolete
    public static long lastModified(@NotNull File file) {
        FileAttributes attributes;
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(3);
        }
        return (attributes = FileSystemUtil.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    @ApiStatus.Obsolete
    public static boolean isSymLink(@NotNull String path) {
        FileAttributes attributes;
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(4);
        }
        return (attributes = FileSystemUtil.getAttributes(path)) != null && attributes.isSymLink();
    }

    @ApiStatus.Obsolete
    public static boolean isSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(5);
        }
        return FileSystemUtil.isSymLink(file.getAbsolutePath());
    }

    @ApiStatus.Obsolete
    @Nullable
    public static String resolveSymLink(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(6);
        }
        try {
            return FileSystemUtil.resolveSymLink(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            LOG.debug(e);
            return null;
        }
    }

    @ApiStatus.Obsolete
    @Nullable
    public static String resolveSymLink(@NotNull File file) {
        if (file == null) {
            FileSystemUtil.$$$reportNull$$$0(7);
        }
        return FileSystemUtil.resolveSymLink(file.toPath());
    }

    @Nullable
    private static FileAttributes getAttributes(Path path) {
        try {
            return FileSystemUtil.getAttributesNotNull(path);
        }
        catch (NoSuchFileException e) {
            LOG.trace(e.getClass().getName() + ": " + path);
            return null;
        }
        catch (IOException e) {
            LOG.debug(path.toString(), e);
            return null;
        }
    }

    @NotNull
    private static FileAttributes getAttributesNotNull(Path path) throws IOException {
        BasicFileAttributes attributes = NioFiles.readAttributes(path);
        FileAttributes fileAttributes = attributes == NioFiles.BROKEN_SYMLINK ? FileAttributes.BROKEN_SYMLINK : FileAttributes.fromNio(path, attributes);
        if (fileAttributes == null) {
            FileSystemUtil.$$$reportNull$$$0(8);
        }
        return fileAttributes;
    }

    @Nullable
    private static String resolveSymLink(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]).toString();
        }
        catch (NoSuchFileException e) {
            LOG.trace(e.getClass().getName() + ": " + path);
        }
        catch (FileSystemException e) {
            LOG.debug(path.toString(), e);
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static FileAttributes.CaseSensitivity readParentCaseSensitivity(@NotNull File anyChild) {
        FileAttributes.CaseSensitivity detected;
        if (anyChild == null) {
            FileSystemUtil.$$$reportNull$$$0(9);
        }
        if ((detected = FileSystemUtil.readCaseSensitivityByNativeAPI(anyChild)).isKnown()) {
            FileAttributes.CaseSensitivity caseSensitivity = detected;
            if (caseSensitivity == null) {
                FileSystemUtil.$$$reportNull$$$0(10);
            }
            return caseSensitivity;
        }
        return FileSystemUtil.readCaseSensitivityByJavaIO(anyChild);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static FileAttributes.CaseSensitivity readCaseSensitivityByJavaIO(@NotNull File anyChild) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static FileAttributes.CaseSensitivity readCaseSensitivityByNativeAPI(@NotNull File anyChild) {
        if (anyChild == null) {
            FileSystemUtil.$$$reportNull$$$0(19);
        }
        if (JnaLoader.isLoaded()) {
            File parent = anyChild.getParentFile();
            String path = (parent != null ? parent : anyChild).getAbsolutePath();
            if (OS.CURRENT == OS.Windows && OS.CURRENT.isAtLeast(10, 0) && WINDOWS_CS_API_AVAILABLE && OSAgnosticPathUtil.isAbsoluteDosPath(path)) {
                FileAttributes.CaseSensitivity caseSensitivity = FileSystemUtil.getNtfsCaseSensitivity(path);
                if (caseSensitivity == null) {
                    FileSystemUtil.$$$reportNull$$$0(20);
                }
                return caseSensitivity;
            }
            if (OS.CURRENT == OS.macOS && MAC_CS_API_AVAILABLE) {
                FileAttributes.CaseSensitivity caseSensitivity = FileSystemUtil.getMacOsCaseSensitivity(path);
                if (caseSensitivity == null) {
                    FileSystemUtil.$$$reportNull$$$0(21);
                }
                return caseSensitivity;
            }
            if (OS.CURRENT == OS.Linux && LINUX_CS_API_AVAILABLE) {
                FileAttributes.CaseSensitivity caseSensitivity = FileSystemUtil.getLinuxCaseSensitivity(path);
                if (caseSensitivity == null) {
                    FileSystemUtil.$$$reportNull$$$0(22);
                }
                return caseSensitivity;
            }
        }
        FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
        if (caseSensitivity == null) {
            FileSystemUtil.$$$reportNull$$$0(23);
        }
        return caseSensitivity;
    }

    private static String toggleCase(String name) {
        String altName = name.toUpperCase(Locale.getDefault());
        if (altName.equals(name)) {
            altName = name.toLowerCase(Locale.getDefault());
        }
        return altName;
    }

    @ApiStatus.Internal
    public static boolean isCaseToggleable(@NotNull String name) {
        if (name == null) {
            FileSystemUtil.$$$reportNull$$$0(24);
        }
        return !FileSystemUtil.toggleCase(name).equals(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String findCaseToggleableChild(File dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir.toPath());){
            Path path;
            String name;
            Iterator<Path> iterator2 = stream.iterator();
            do {
                if (!iterator2.hasNext()) return null;
            } while ((name = (path = iterator2.next()).getFileName().toString()).toLowerCase(Locale.getDefault()).equals(name.toUpperCase(Locale.getDefault())));
            String string = name;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static FileAttributes.CaseSensitivity getNtfsCaseSensitivity(String path) {
        NtOsKrnl ntOsKrnl;
        Kernel32 kernel32;
        try {
            kernel32 = Kernel32.INSTANCE;
            ntOsKrnl = NtOsKrnl.INSTANCE;
        }
        catch (Throwable t) {
            LOG.warn(t);
            WINDOWS_CS_API_AVAILABLE = false;
            return FileAttributes.CaseSensitivity.UNKNOWN;
        }
        try {
            String name = "\\\\?\\" + path;
            WinNT.HANDLE handle = kernel32.CreateFile(name, 0, 7, null, 3, 0x2000000, null);
            if (handle == WinBase.INVALID_HANDLE_VALUE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CreateFile(" + path + "): 0x" + Integer.toHexString(kernel32.GetLastError()));
                }
                return FileAttributes.CaseSensitivity.UNKNOWN;
            }
            NtOsKrnl.FILE_CASE_SENSITIVE_INFORMATION_P fileInformation = new NtOsKrnl.FILE_CASE_SENSITIVE_INFORMATION_P();
            int result = ntOsKrnl.NtQueryInformationFile(handle, new NtOsKrnl.IO_STATUS_BLOCK_P(), fileInformation, fileInformation.size(), 71);
            kernel32.CloseHandle(handle);
            if (result != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NtQueryInformationFile(" + path + "): 0x" + Integer.toHexString(result));
                }
            } else {
                if (fileInformation.Flags == 0L) {
                    return FileAttributes.CaseSensitivity.INSENSITIVE;
                }
                if (fileInformation.Flags == 1L) {
                    return FileAttributes.CaseSensitivity.SENSITIVE;
                }
                LOG.warn("NtQueryInformationFile(" + path + "): unexpected 'FileCaseSensitiveInformation' value " + fileInformation.Flags);
            }
        }
        catch (Throwable t) {
            LOG.warn("path: " + path, t);
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileAttributes.CaseSensitivity getMacOsCaseSensitivity(String path) {
        CoreFoundation cf;
        try {
            cf = CoreFoundation.INSTANCE;
        }
        catch (Throwable t) {
            LOG.warn(t);
            MAC_CS_API_AVAILABLE = false;
            return FileAttributes.CaseSensitivity.UNKNOWN;
        }
        try {
            byte[] buffer = path.getBytes(StandardCharsets.UTF_8);
            CoreFoundation.CFTypeRef url = cf.CFURLCreateFromFileSystemRepresentation(null, buffer, buffer.length, true);
            try {
                PointerByReference resultPtr = new PointerByReference();
                PointerByReference errorPtr = new PointerByReference();
                if (!cf.CFURLCopyResourcePropertyForKey(url, CoreFoundation.kCFURLVolumeSupportsCaseSensitiveNamesKey, resultPtr, errorPtr)) {
                    if (!LOG.isDebugEnabled()) return FileAttributes.CaseSensitivity.UNKNOWN;
                    Pointer error = errorPtr.getValue();
                    String description = error != null ? cf.CFErrorGetDomain(error).stringValue() + '/' + cf.CFErrorGetCode(error) : "error";
                    LOG.debug("CFURLCopyResourcePropertyForKey(" + path + "): " + description);
                    return FileAttributes.CaseSensitivity.UNKNOWN;
                }
                Pointer result = resultPtr.getValue();
                if (result == null) {
                    if (!LOG.isDebugEnabled()) return FileAttributes.CaseSensitivity.UNKNOWN;
                    LOG.debug("CFURLCopyResourcePropertyForKey(" + path + "): property not available");
                    return FileAttributes.CaseSensitivity.UNKNOWN;
                }
                boolean value = new CoreFoundation.CFBooleanRef(result).booleanValue();
                FileAttributes.CaseSensitivity caseSensitivity = value ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE;
                return caseSensitivity;
            }
            finally {
                url.release();
            }
        }
        catch (Throwable t) {
            LOG.warn("path: " + path, t);
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    private static FileAttributes.CaseSensitivity getLinuxCaseSensitivity(String path) {
        block12: {
            LibC libC;
            try {
                libC = LibC.INSTANCE;
            }
            catch (Throwable t) {
                LOG.warn(t);
                LINUX_CS_API_AVAILABLE = false;
                return FileAttributes.CaseSensitivity.UNKNOWN;
            }
            try {
                E2P e2P;
                long fs;
                Memory buf = new Memory(256L);
                if (libC.statfs(path, buf) != 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("statfs(" + path + "): error");
                    }
                    break block12;
                }
                long l = fs = Native.LONG_SIZE == 4 ? (long)buf.getInt(0L) & 0xFFFFFFFFL : buf.getLong(0L);
                if (fs == 2435016766L || fs == 1481003842L) {
                    return FileAttributes.CaseSensitivity.SENSITIVE;
                }
                if (fs == 19780L) {
                    return FileAttributes.CaseSensitivity.INSENSITIVE;
                }
                if (fs != 61267L && fs != 4076150800L || !ourLibExt2FsPresent) break block12;
                try {
                    e2P = E2P.INSTANCE;
                }
                catch (Throwable t) {
                    LOG.warn(t);
                    ourLibExt2FsPresent = false;
                    return FileAttributes.CaseSensitivity.UNKNOWN;
                }
                LongByReference flags = new LongByReference();
                if (e2P.fgetflags(path, flags) != 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("fgetflags(" + path + "): error");
                    }
                    break block12;
                }
                return (flags.getValue() & 0x40000000L) == 0L ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE;
            }
            catch (Throwable t) {
                LOG.warn("path: " + path, t);
            }
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyChild";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesNotNull";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readParentCaseSensitivity";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readCaseSensitivityByJavaIO";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "readCaseSensitivityByNativeAPI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lastModified";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readParentCaseSensitivity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readCaseSensitivityByJavaIO";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readCaseSensitivityByNativeAPI";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isCaseToggleable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface NtOsKrnl
    extends StdCallLibrary,
    WinNT {
        public static final NtOsKrnl INSTANCE = Native.load("NtDll", NtOsKrnl.class, W32APIOptions.UNICODE_OPTIONS);
        public static final int FILE_SHARE_ALL = 7;
        public static final int FileCaseSensitiveInformation = 71;

        public int NtQueryInformationFile(WinNT.HANDLE var1, IO_STATUS_BLOCK_P var2, Structure var3, long var4, int var6);

        @Structure.FieldOrder(value={"Flags"})
        public static final class FILE_CASE_SENSITIVE_INFORMATION_P
        extends Structure
        implements Structure.ByReference {
            public long Flags = 0xFFFFFFFFL;
        }

        @Structure.FieldOrder(value={"Pointer", "Information"})
        public static final class IO_STATUS_BLOCK_P
        extends Structure
        implements Structure.ByReference {
            public Pointer Pointer;
            public Pointer Information;
        }
    }

    private static interface CoreFoundation
    extends com.sun.jna.platform.mac.CoreFoundation {
        public static final CoreFoundation INSTANCE = Native.load("CoreFoundation", CoreFoundation.class);
        public static final CoreFoundation.CFStringRef kCFURLVolumeSupportsCaseSensitiveNamesKey = CoreFoundation.CFStringRef.createCFString("NSURLVolumeSupportsCaseSensitiveNamesKey");

        public CoreFoundation.CFTypeRef CFURLCreateFromFileSystemRepresentation(CoreFoundation.CFAllocatorRef var1, byte[] var2, long var3, boolean var5);

        public boolean CFURLCopyResourcePropertyForKey(CoreFoundation.CFTypeRef var1, CoreFoundation.CFStringRef var2, PointerByReference var3, PointerByReference var4);

        public CoreFoundation.CFStringRef CFErrorGetDomain(Pointer var1);

        public CoreFoundation.CFIndex CFErrorGetCode(Pointer var1);
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = Native.load(LibC.class);

        public int statfs(String var1, Memory var2);
    }

    static interface E2P
    extends Library {
        public static final E2P INSTANCE = Native.load("e2p", E2P.class);
        public static final long EXT4_CASEFOLD_FL = 0x40000000L;

        public int fgetflags(String var1, LongByReference var2);
    }
}

