/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.run.actions.ColumnHeaderActionBase;
import com.intellij.database.run.actions.LocalFilterActionUtils;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.LocalFilterState;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J(\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/actions/ColumnLocalFilterWithCellAction;", "Lcom/intellij/database/run/actions/ColumnHeaderActionBase;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "columnIdxs", "Lcom/intellij/database/datagrid/ModelIndexSet;", "Lcom/intellij/database/datagrid/GridColumn;", "actionPerformed", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nColumnLocalFilterWithCellAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnLocalFilterWithCellAction.kt\ncom/intellij/database/run/actions/ColumnLocalFilterWithCellAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1869#2,2:47\n*S KotlinDebug\n*F\n+ 1 ColumnLocalFilterWithCellAction.kt\ncom/intellij/database/run/actions/ColumnLocalFilterWithCellAction\n*L\n35#1:47,2\n*E\n"})
public final class ColumnLocalFilterWithCellAction
extends ColumnHeaderActionBase {
    public ColumnLocalFilterWithCellAction() {
        super(true);
    }

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdxs, (String)"columnIdxs");
        GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel gridModel2 = gridModel;
        List list = gridModel2.getColumns(columnIdxs);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        List columns = list;
        e.getPresentation().setEnabledAndVisible(LocalFilterActionUtils.INSTANCE.isGridInNonTransposedTableMode(grid) && columns.size() == 1 && !GridHelper.get(grid).isColumnContainNestedTables((GridModel<GridRow, GridColumn>)gridModel2, (GridColumn)columns.get(0)));
    }

    @Override
    protected void actionPerformed(@Nullable AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdxs, (String)"columnIdxs");
        if (columnIdxs.size() != 1) {
            return;
        }
        ResultView resultView = grid.getResultView();
        Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"getResultView(...)");
        ResultView resultView2 = resultView;
        if (!(resultView2 instanceof TableResultView)) {
            return;
        }
        Index index = columnIdxs.first();
        Intrinsics.checkNotNullExpressionValue((Object)index, (String)"first(...)");
        ModelIndex columnIdx = (ModelIndex)index;
        GridColumn column = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        if (column == null) {
            return;
        }
        List<GridRow> list = GridUtil.getSelectedGridRows(grid);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSelectedGridRows(...)");
        List<GridRow> rows = list;
        ((TableResultView)resultView2).getLocalFilterState().clearFilterForColumn((ModelIndex<GridColumn>)columnIdx);
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String text;
            GridRow row = (GridRow)element$iv;
            boolean bl = false;
            int rowIdx = GridRow.toRealIdx((GridRow)row);
            Intrinsics.checkNotNullExpressionValue((Object)GridUtil.getText(grid, (ModelIndex<GridRow>)ModelIndex.forRow((CoreGrid)grid, (int)rowIdx), (ModelIndex<GridColumn>)columnIdx, DataAccessType.DATA_WITH_MUTATIONS), (String)"getText(...)");
            ((TableResultView)resultView2).getLocalFilterState().enableForColumn((ModelIndex<GridColumn>)columnIdx, new LocalFilterState.Value(column.getValue(row), text));
        }
        ((TableResultView)resultView2).getLocalFilterState().setEnabled(true);
        ((TableResultView)resultView2).updateRowFilter();
        grid.getPanel().getComponent().repaint();
    }
}

