/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util;

import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleExecutorServiceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSingleThreadExecutor(@NotNull String name, @NotNull Function<ExecutorService, T> action) {
        if (name == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(0);
        }
        if (action == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(1);
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor(new SimpleThreadFactory(name));
        try {
            T t = action.apply(executorService);
            return t;
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> void submitTask(@NotNull ExecutorService executor, @NotNull BlockingQueue<Future<T>> queue, @NotNull Callable<T> task) {
        if (executor == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(2);
        }
        if (queue == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(3);
        }
        if (task == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(4);
        }
        Future<T> taskResult = Context.current().wrap(executor).submit(task);
        queue.add(taskResult);
    }

    @NotNull
    public static <T> List<T> pollAllPendingResults(@NotNull BlockingQueue<Future<T>> queue) {
        if (queue == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(5);
        }
        ArrayList<T> results = new ArrayList<T>();
        T result = GradleExecutorServiceUtil.poolPendingResult(queue);
        while (result != null) {
            results.add(result);
            result = GradleExecutorServiceUtil.poolPendingResult(queue);
        }
        ArrayList<T> arrayList = results;
        if (arrayList == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T poolPendingResult(@NotNull BlockingQueue<Future<T>> queue) {
        if (queue == null) {
            GradleExecutorServiceUtil.$$$reportNull$$$0(7);
        }
        try {
            Future future = (Future)queue.poll();
            if (future == null) {
                return null;
            }
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException ignored) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/util/GradleExecutorServiceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleExecutorServiceUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pollAllPendingResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withSingleThreadExecutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "submitTask";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pollAllPendingResults";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "poolPendingResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SimpleThreadFactory
    implements ThreadFactory {
        private final String myName;

        private SimpleThreadFactory(@NotNull String name) {
            if (name == null) {
                SimpleThreadFactory.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                SimpleThreadFactory.$$$reportNull$$$0(1);
            }
            return new Thread(runnable, this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleExecutorServiceUtil$SimpleThreadFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newThread";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

