/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ArrayTypeImpl;
import com.jetbrains.jdi.BaseLineInfo;
import com.jetbrains.jdi.ConcreteMethodImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.LineInfo;
import com.jetbrains.jdi.NonConcreteMethodImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.SDE;
import com.jetbrains.jdi.StratumLineInfo;
import com.jetbrains.jdi.TypeComponentImpl;
import com.jetbrains.jdi.ValueContainer;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class MethodImpl
extends TypeComponentImpl
implements Method {
    public static final int SKIP_ASSIGNABLE_CHECK = 1024;
    private final JNITypeParser signatureParser;
    private volatile Boolean obsolete = null;
    ReturnContainer retValContainer = null;

    abstract int argSlotCount() throws AbsentInformationException;

    abstract List<Location> allLineLocations(SDE.Stratum var1, String var2) throws AbsentInformationException;

    abstract CompletableFuture<List<Location>> allLineLocationsAsync(SDE.Stratum var1, String var2);

    abstract List<Location> locationsOfLine(SDE.Stratum var1, String var2, int var3) throws AbsentInformationException;

    abstract CompletableFuture<List<Location>> locationsOfLineAsync(SDE.Stratum var1, String var2, int var3);

    MethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long ref, String name, String signature, String genericSignature, int modifiers) {
        super(vm, declaringType, ref, name, signature, genericSignature, modifiers);
        this.signatureParser = new JNITypeParser(signature);
    }

    static MethodImpl createMethodImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long ref, String name, String signature, String genericSignature, int modifiers) {
        if ((modifiers & 0x500) != 0) {
            return new NonConcreteMethodImpl(vm, declaringType, ref, name, signature, genericSignature, modifiers);
        }
        return new ConcreteMethodImpl(vm, declaringType, ref, name, signature, genericSignature, modifiers);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MethodImpl) {
            MethodImpl other = (MethodImpl)obj;
            return this.declaringType().equals(other.declaringType()) && this.ref() == other.ref() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.ref());
    }

    @Override
    public final List<Location> allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    public final CompletableFuture<List<Location>> allLineLocationsAsync() {
        return this.allLineLocationsAsync(this.vm.getDefaultStratum(), null);
    }

    @Override
    public List<Location> allLineLocations(String stratumID, String sourceName) throws AbsentInformationException {
        return this.allLineLocations(this.declaringType.stratum(stratumID), sourceName);
    }

    public CompletableFuture<List<Location>> allLineLocationsAsync(String stratumID, String sourceName) {
        return this.declaringType.stratumAsync(stratumID).thenCompose(stratum -> this.allLineLocationsAsync((SDE.Stratum)stratum, sourceName));
    }

    @Override
    public final List<Location> locationsOfLine(int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, lineNumber);
    }

    @Override
    public List<Location> locationsOfLine(String stratumID, String sourceName, int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.declaringType.stratum(stratumID), sourceName, lineNumber);
    }

    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long codeIndex) {
        if (stratum.isJava()) {
            return new BaseLineInfo(-1, this.declaringType);
        }
        return new StratumLineInfo(stratum.id(), -1, null, null);
    }

    @Override
    public String returnTypeName() {
        return this.signatureParser.typeName();
    }

    private String returnSignature() {
        return this.signatureParser.signature();
    }

    @Override
    public Type returnType() throws ClassNotLoadedException {
        return this.findType(this.returnSignature());
    }

    public Type findType(String signature) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.declaringType();
        return enclosing.findType(signature);
    }

    @Override
    public List<String> argumentTypeNames() {
        return this.signatureParser.argumentTypeNames();
    }

    public List<String> argumentSignatures() {
        return this.signatureParser.argumentSignatures();
    }

    Type argumentType(int index) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.declaringType();
        String signature = this.argumentSignatures().get(index);
        return enclosing.findType(signature);
    }

    @Override
    public List<Type> argumentTypes() throws ClassNotLoadedException {
        int size = this.argumentSignatures().size();
        ArrayList<Type> types = new ArrayList<Type>(size);
        for (int i = 0; i < size; ++i) {
            Type type = this.argumentType(i);
            types.add(type);
        }
        return types;
    }

    @Override
    public int compareTo(Method method) {
        if (this == method) {
            return 0;
        }
        ReferenceTypeImpl declaringType = (ReferenceTypeImpl)this.declaringType();
        int rc = declaringType.compareTo(method.declaringType());
        if (rc == 0) {
            rc = declaringType.indexOf(this) - declaringType.indexOf(method);
        }
        return rc;
    }

    @Override
    public boolean isAbstract() {
        return this.isModifierSet(1024);
    }

    @Override
    public boolean isDefault() {
        return !this.isModifierSet(1024) && !this.isModifierSet(8) && !this.isModifierSet(2) && this.declaringType() instanceof InterfaceType;
    }

    @Override
    public boolean isSynchronized() {
        return this.isModifierSet(32);
    }

    @Override
    public boolean isNative() {
        return this.isModifierSet(256);
    }

    @Override
    public boolean isVarArgs() {
        return this.isModifierSet(128);
    }

    @Override
    public boolean isBridge() {
        return this.isModifierSet(64);
    }

    @Override
    public boolean isConstructor() {
        return this.name().equals("<init>");
    }

    @Override
    public boolean isStaticInitializer() {
        return this.name().equals("<clinit>");
    }

    void noticeRedefineClass() {
        this.obsolete = null;
    }

    @Override
    public boolean isObsolete() {
        if (this.obsolete == null) {
            try {
                this.obsolete = JDWP.Method.IsObsolete.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).isObsolete;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.obsolete;
    }

    public CompletableFuture<Boolean> isObsoleteAsync() {
        if (this.obsolete == null) {
            return JDWP.Method.IsObsolete.processAsync(this.vm, this.declaringType, this.ref).thenApply(r -> {
                this.obsolete = r.isObsolete;
                return this.obsolete;
            });
        }
        return CompletableFuture.completedFuture(this.obsolete);
    }

    ReturnContainer getReturnValueContainer() {
        if (this.retValContainer == null) {
            this.retValContainer = new ReturnContainer();
        }
        return this.retValContainer;
    }

    public static void handleVarArgs(Method method, List<Value> arguments) throws ClassNotLoadedException, InvalidTypeException {
        Type nthArgType;
        int paramCount;
        List<Type> paramTypes = method.argumentTypes();
        ArrayType lastParamType = (ArrayType)paramTypes.get(paramTypes.size() - 1);
        int argCount = arguments.size();
        if (argCount < (paramCount = paramTypes.size()) - 1) {
            return;
        }
        if (argCount == paramCount - 1) {
            ArrayReference argArray = lastParamType.newInstance(0);
            arguments.add(argArray);
            return;
        }
        Value nthArgValue = arguments.get(paramCount - 1);
        if (nthArgValue == null && argCount == paramCount) {
            return;
        }
        Type type = nthArgType = nthArgValue == null ? null : nthArgValue.type();
        if (nthArgType instanceof ArrayTypeImpl && argCount == paramCount && ((ArrayTypeImpl)nthArgType).isAssignableTo(lastParamType)) {
            return;
        }
        int count = argCount - paramCount + 1;
        ArrayReference argArray = lastParamType.newInstance(count);
        argArray.setValues(0, arguments, paramCount - 1, count);
        arguments.set(paramCount - 1, argArray);
        if (argCount > paramCount) {
            arguments.subList(paramCount, argCount).clear();
        }
    }

    List<Value> validateAndPrepareArgumentsForInvoke(List<? extends Value> origArguments, int options) throws ClassNotLoadedException, InvalidTypeException {
        ArrayList<Value> arguments = new ArrayList<Value>(origArguments);
        if (this.isVarArgs()) {
            MethodImpl.handleVarArgs(this, arguments);
        }
        int argSize = arguments.size();
        JNITypeParser parser = new JNITypeParser(this.signature());
        List<String> signatures = parser.argumentSignatures();
        if (signatures.size() != argSize) {
            throw new IllegalArgumentException("Invalid argument count: expected " + signatures.size() + ", received " + arguments.size());
        }
        for (int i = 0; i < argSize; ++i) {
            Value value = (Value)arguments.get(i);
            value = ValueImpl.prepareForAssignment(value, new ArgumentContainer(i, MethodImpl.isCheckAssignable(options)));
            arguments.set(i, value);
        }
        return arguments;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.declaringType().name());
        sb.append(".");
        sb.append(this.name());
        sb.append("(");
        boolean first = true;
        for (String name : this.argumentTypeNames()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(name);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    static boolean isCheckAssignable(int options) {
        return (options & 0x400) == 0;
    }

    public abstract CompletableFuture<byte[]> bytecodesAsync();

    public abstract CompletableFuture<List<LocalVariable>> variablesAsync();

    class ReturnContainer
    implements ValueContainer {
        ReturnContainer() {
        }

        @Override
        public Type type() throws ClassNotLoadedException {
            return MethodImpl.this.returnType();
        }

        @Override
        public String typeName() {
            return MethodImpl.this.returnTypeName();
        }

        @Override
        public String signature() {
            return MethodImpl.this.returnSignature();
        }

        @Override
        public Type findType(String signature) throws ClassNotLoadedException {
            return MethodImpl.this.findType(signature);
        }
    }

    class ArgumentContainer
    implements ValueContainer {
        final int index;
        final boolean checkAssignable;

        ArgumentContainer(int index, boolean checkAssignable) {
            this.index = index;
            this.checkAssignable = checkAssignable;
        }

        @Override
        public Type type() throws ClassNotLoadedException {
            return MethodImpl.this.argumentType(this.index);
        }

        @Override
        public String typeName() {
            return MethodImpl.this.argumentTypeNames().get(this.index);
        }

        @Override
        public String signature() {
            return MethodImpl.this.argumentSignatures().get(this.index);
        }

        @Override
        public Type findType(String signature) throws ClassNotLoadedException {
            return MethodImpl.this.findType(signature);
        }

        @Override
        public boolean checkAssignable() {
            return this.checkAssignable;
        }
    }
}

