/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffViewerEx;
import com.intellij.diff.EditorDiffViewer;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.patch.tool.DiffPatchFileEditorProviderKt;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0016H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer;", "Lcom/intellij/diff/DiffViewerEx;", "Lcom/intellij/diff/EditorDiffViewer;", "diffContext", "Lcom/intellij/diff/DiffContext;", "diffRequest", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffRequest;", "<init>", "(Lcom/intellij/diff/DiffContext;Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffRequest;)V", "project", "Lcom/intellij/openapi/project/Project;", "panel", "Lcom/intellij/diff/tools/util/SimpleDiffPanel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "editorHolder", "Lcom/intellij/diff/tools/holders/EditorHolder;", "prevNextDifferenceIterable", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer$MyPrevNextDifferenceIterable;", "editorSettingsAction", "Lcom/intellij/diff/actions/impl/SetEditorSettingsAction;", "hunks", "", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getEditors", "Lcom/intellij/openapi/editor/Editor;", "getDifferenceIterable", "Lcom/intellij/diff/tools/util/PrevNextDifferenceIterable;", "init", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "dispose", "", "onInit", "createToolbarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "MyPrevNextDifferenceIterable", "intellij.platform.vcs.impl"})
public final class PatchDiffViewer
implements DiffViewerEx,
EditorDiffViewer {
    @NotNull
    private final DiffContext diffContext;
    @NotNull
    private final PatchDiffRequest diffRequest;
    @Nullable
    private final Project project;
    @NotNull
    private final SimpleDiffPanel panel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorHolder editorHolder;
    @NotNull
    private final MyPrevNextDifferenceIterable prevNextDifferenceIterable;
    @NotNull
    private final SetEditorSettingsAction editorSettingsAction;
    @NotNull
    private List<? extends PatchChangeBuilder.Hunk> hunks;

    public PatchDiffViewer(@NotNull DiffContext diffContext, @NotNull PatchDiffRequest diffRequest) {
        Intrinsics.checkNotNullParameter((Object)diffContext, (String)"diffContext");
        Intrinsics.checkNotNullParameter((Object)((Object)diffRequest), (String)"diffRequest");
        this.diffContext = diffContext;
        this.diffRequest = diffRequest;
        this.project = this.diffContext.getProject();
        this.hunks = new ArrayList();
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        EditorEx editorEx = DiffUtil.createEditor((Document)document2, (Project)this.project, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
        this.editor = editorEx;
        DiffUtil.setEditorCodeStyle((Project)this.project, (EditorEx)this.editor, null);
        this.editorHolder = (EditorHolder)new TextEditorHolder(this.project, this.editor);
        Object[] objectArray = new String[]{this.diffRequest.getContentTitle1(), this.diffRequest.getContentTitle2()};
        List list = DiffUtil.createPatchTextTitles((FrameDiffTool.DiffViewer)((FrameDiffTool.DiffViewer)this), (DiffRequest)this.diffRequest, (List)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createPatchTextTitles(...)");
        List titles = CollectionsKt.filterNotNull((Iterable)list);
        JComponent titlePanel = !((Collection)titles).isEmpty() ? DiffUtil.createStackedComponents((List)titles, (JBValue)DiffUtil.TITLE_GAP) : null;
        OnesideContentPanel onesideContentPanel = OnesideContentPanel.createFromHolder((EditorHolder)this.editorHolder);
        Intrinsics.checkNotNullExpressionValue((Object)onesideContentPanel, (String)"createFromHolder(...)");
        OnesideContentPanel contentPanel = onesideContentPanel;
        contentPanel.setTitle(titlePanel);
        this.prevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        DiffContext diffContext2 = this.diffContext;
        this.panel = new SimpleDiffPanel(contentPanel, diffContext2){

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                DataKey dataKey = CommonDataKeys.PROJECT;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
                sink.set(dataKey, (Object)project);
                DataKey dataKey2 = DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PREV_NEXT_DIFFERENCE_ITERABLE");
                sink.set(dataKey2, (Object)prevNextDifferenceIterable);
                DataKey dataKey3 = DiffDataKeys.CURRENT_EDITOR;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"CURRENT_EDITOR");
                sink.set(dataKey3, (Object)editor);
                DataKey dataKey4 = DiffDataKeys.CURRENT_CHANGE_RANGE;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"CURRENT_CHANGE_RANGE");
                sink.set(dataKey4, (Object)prevNextDifferenceIterable.getCurrentLineRange());
            }
        };
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings((DiffContext)this.diffContext);
        Intrinsics.checkNotNullExpressionValue((Object)textDiffSettings, (String)"getTextSettings(...)");
        this.editorSettingsAction = new SetEditorSettingsAction(textDiffSettings, this.getEditors());
        this.editorSettingsAction.applyDefaults();
        DiffPatchFileEditorProviderKt.listenTypingAttempts(this.diffContext, (Editor)this.editor);
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.panel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    @NotNull
    public List<Editor> getEditors() {
        return CollectionsKt.listOf((Object)this.editor);
    }

    @NotNull
    public PrevNextDifferenceIterable getDifferenceIterable() {
        return (PrevNextDifferenceIterable)this.prevNextDifferenceIterable;
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.panel.setPersistentNotifications(DiffUtil.createCustomNotifications((FrameDiffTool.DiffViewer)((FrameDiffTool.DiffViewer)this), (UserDataHolder)((UserDataHolder)this.diffContext), (UserDataHolder)((UserDataHolder)this.diffRequest)));
        this.onInit();
        FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
        toolbarComponents.toolbarActions = this.createToolbarActions();
        return toolbarComponents;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.editorHolder));
    }

    private final void onInit() {
        PatchChangeBuilder patchChangeBuilder = new PatchChangeBuilder();
        List list = this.diffRequest.getPatch().getHunks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHunks(...)");
        PatchChangeBuilder.PatchState state = patchChangeBuilder.build(list);
        this.hunks = state.getHunks();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        Document patchDocument = (Document)documentEx;
        ActionsKt.runWriteAction(() -> PatchDiffViewer.onInit$lambda$0(patchDocument, state));
        this.editor.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverterAdapter(state.getLineConvertor1().createConvertor()), (LineNumberConverter)new LineNumberConverterAdapter(state.getLineConvertor2().createConvertor()));
        state.getSeparatorLines().forEach(arg_0 -> PatchDiffViewer.onInit$lambda$1(patchDocument, this, arg_0));
        for (PatchChangeBuilder.Hunk hunk : this.hunks) {
            List<DiffFragment> innerFragments = PatchChangeBuilder.Companion.computeInnerDifferences(patchDocument, hunk);
            DiffDrawUtil.createUnifiedChunkHighlighters((Editor)((Editor)this.editor), (LineRange)hunk.getPatchDeletionRange(), (LineRange)hunk.getPatchInsertionRange(), innerFragments);
        }
        this.editor.getGutterComponentEx().revalidateMarkup();
    }

    @RequiresEdt
    private final List<AnAction> createToolbarActions() {
        List group = new ArrayList();
        group.add(this.editorSettingsAction);
        Separator separator = Separator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"getInstance(...)");
        group.add(separator);
        AnAction anAction = ActionManager.getInstance().getAction("Diff.ViewerToolbar");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        group.add(anAction);
        return group;
    }

    private static final Unit onInit$lambda$0(Document $patchDocument, PatchChangeBuilder.PatchState $state) {
        $patchDocument.setText((CharSequence)((Object)$state.getPatchContent()).toString());
        return Unit.INSTANCE;
    }

    private static final void onInit$lambda$1(Document $patchDocument, PatchDiffViewer this$0, int line) {
        int offset = $patchDocument.getLineStartOffset(line);
        DiffDrawUtil.createLineSeparatorHighlighter((Editor)((Editor)this$0.editor), (int)offset, (int)offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer$MyPrevNextDifferenceIterable;", "Lcom/intellij/diff/tools/util/PrevNextDifferenceIterableBase;", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "<init>", "(Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer;)V", "getChanges", "", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getStartLine", "", "change", "getEndLine", "intellij.platform.vcs.impl"})
    private final class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<PatchChangeBuilder.Hunk> {
        @NotNull
        protected List<PatchChangeBuilder.Hunk> getChanges() {
            return PatchDiffViewer.this.hunks;
        }

        @NotNull
        protected EditorEx getEditor() {
            return PatchDiffViewer.this.editor;
        }

        protected int getStartLine(@NotNull PatchChangeBuilder.Hunk change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            return change.getPatchDeletionRange().start;
        }

        protected int getEndLine(@NotNull PatchChangeBuilder.Hunk change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            return change.getPatchInsertionRange().end;
        }
    }
}

