/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.NoStackTraceFoldingPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.java.frontback.impl.JavaFrontbackBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.CompoundDumpItem;
import com.intellij.unscramble.DumpItem;
import com.intellij.unscramble.DumpItemKt;
import com.intellij.unscramble.MergeableDumpItem;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ThreadDumpPanel
extends JPanel
implements NoStackTraceFoldingPanel {
    private final JBList<DumpItem> myThreadList;
    private final EditorNotificationPanel myNotificationPanel = new EditorNotificationPanel(EditorNotificationPanel.Status.Info);
    private final List<DumpItem> myThreadDump;
    private final List<DumpItem> myMergedThreadDump;
    private Comparator<DumpItem> currentComparator = DumpItem.BY_INTEREST;
    private final JPanel myFilterPanel;
    private final SearchTextField myFilterField;
    private int myDumpItemsTruncated = 0;
    private int myMergedDumpItemsTruncated = 0;

    public ThreadDumpPanel(Project project, ConsoleView consoleView, DefaultActionGroup toolbarActions, List<ThreadState> threadDump) {
        this(project, consoleView, toolbarActions, DumpItemKt.toDumpItems(threadDump), false);
    }

    @ApiStatus.Internal
    public static ThreadDumpPanel createFromDumpItems(Project project, ConsoleView consoleView, DefaultActionGroup toolbarActions, List<MergeableDumpItem> dumpItems) {
        return new ThreadDumpPanel(project, consoleView, toolbarActions, dumpItems, true);
    }

    @ApiStatus.Internal
    public void addDumpItems(List<DumpItem> threadDump, int dumpItemsTruncated, List<DumpItem> mergedThreadDump, int mergedDumpItemsTruncated) {
        this.myThreadDump.addAll(threadDump);
        this.myDumpItemsTruncated += dumpItemsTruncated;
        this.myMergedThreadDump.addAll(mergedThreadDump);
        this.myMergedDumpItemsTruncated += mergedDumpItemsTruncated;
        this.sortAndUpdateThreadDumpItemList();
    }

    private ThreadDumpPanel(final Project project, ConsoleView consoleView, DefaultActionGroup toolbarActions, List<MergeableDumpItem> dumpItems, boolean fromDumpItems) {
        super(new BorderLayout());
        this.myThreadDump = new ArrayList<MergeableDumpItem>(dumpItems);
        this.myMergedThreadDump = CompoundDumpItem.mergeThreadDumpItems(dumpItems);
        this.myFilterField = this.createSearchTextField();
        this.myFilterPanel = this.createFilterPanel();
        this.myThreadList = ThreadDumpPanel.createThreadList(consoleView);
        this.configureToolbar(project, consoleView, toolbarActions);
        this.updateThreadDumpItemList();
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)consoleView.getPreferredFocusableComponent()));
        if (editor != null) {
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    String filter;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (StringUtil.isNotEmpty((String)(filter = ThreadDumpPanel.this.myFilterField.getText()))) {
                        ThreadDumpPanel.highlightOccurrences(filter, project, editor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/unscramble/ThreadDumpPanel$1", "documentChanged"));
                }
            }, (Disposable)consoleView);
        }
    }

    private SearchTextField createSearchTextField() {
        SearchTextField searchTextField = new SearchTextField();
        searchTextField.addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ThreadDumpPanel.this.updateThreadDumpItemList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/unscramble/ThreadDumpPanel$2", "textChanged"));
            }
        });
        return searchTextField;
    }

    private JPanel createFilterPanel() {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)new JLabel(CommonBundle.message((String)"label.filter", (Object[])new Object[0]) + ":"), "West");
        filterPanel.add((Component)this.myFilterField);
        filterPanel.setVisible(false);
        return filterPanel;
    }

    private static JBList<DumpItem> createThreadList(final ConsoleView consoleView) {
        final JBList threadList = new JBList(new DefaultListModel());
        threadList.setCellRenderer((ListCellRenderer)((Object)new ThreadListCellRenderer()));
        threadList.setEmptyText(JavaFrontbackBundle.message("thread.dump.loading.text", new Object[0]));
        threadList.setSelectionMode(0);
        threadList.addListSelectionListener(new ListSelectionListener(){
            int currentSelectedIndex = -2;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = threadList.getSelectedIndex();
                if (index != this.currentSelectedIndex) {
                    if (index >= 0) {
                        DumpItem selection = (DumpItem)threadList.getModel().getElementAt(index);
                        AnalyzeStacktraceUtil.printStacktrace((ConsoleView)consoleView, (String)selection.getStackTrace());
                    } else {
                        AnalyzeStacktraceUtil.printStacktrace((ConsoleView)consoleView, (String)"");
                    }
                    this.currentSelectedIndex = index;
                }
                threadList.repaint();
            }
        });
        ListSpeedSearch.installOn((JList)threadList, DumpItem::getName).setComparator(new SpeedSearchComparator(false, true));
        return threadList;
    }

    private void configureToolbar(Project project, ConsoleView consoleView, DefaultActionGroup toolbarActions) {
        FilterAction filterAction = new FilterAction();
        filterAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("Find").getShortcutSet(), (JComponent)this.myThreadList);
        toolbarActions.add((AnAction)filterAction);
        toolbarActions.add((AnAction)new CopyToClipboardAction(project));
        toolbarActions.add((AnAction)new SortThreadsAction());
        toolbarActions.add((AnAction)new ExportToTextFileToolbarAction(ThreadDumpPanel.createDumpToFileExporter(project, this.myThreadDump)));
        toolbarActions.add((AnAction)new MergeStacktracesAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ThreadDump", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        this.add((Component)toolbar.getComponent(), "West");
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.myNotificationPanel, "North");
        northPanel.add((Component)this.myFilterPanel, "South");
        leftPanel.add((Component)northPanel, "North");
        leftPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myThreadList, (int)5), "Center");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent(consoleView.getComponent());
        this.add((Component)splitter, "Center");
    }

    private void sortAndUpdateThreadDumpItemList() {
        this.myThreadDump.sort(this.currentComparator);
        this.myMergedThreadDump.sort(this.currentComparator);
        this.updateThreadDumpItemList();
    }

    private void updateThreadDumpItemList() {
        int truncated;
        String text = this.myFilterPanel.isVisible() ? this.myFilterField.getText() : "";
        Object selection = this.myThreadList.getSelectedValue();
        int selectedIndex = 0;
        int index = 0;
        ArrayList<DumpItem> filteredThreadStates = new ArrayList<DumpItem>();
        boolean useMerged = UISettings.getInstance().getState().getMergeEqualStackTraces();
        List<DumpItem> threadStates = useMerged ? this.myMergedThreadDump : this.myThreadDump;
        for (DumpItem state : threadStates) {
            if (!StringUtil.containsIgnoreCase((String)state.getStackTrace(), (String)text) && !StringUtil.containsIgnoreCase((String)state.getName(), (String)text)) continue;
            filteredThreadStates.add(state);
            if (selection == state) {
                selectedIndex = index;
            }
            ++index;
        }
        DefaultListModel model = (DefaultListModel)this.myThreadList.getModel();
        model.clear();
        model.addAll(filteredThreadStates);
        int n = truncated = useMerged ? this.myMergedDumpItemsTruncated : this.myDumpItemsTruncated;
        if (truncated > 0) {
            this.myNotificationPanel.text(JavaFrontbackBundle.message("truncated.dump.notification", threadStates.size()));
            this.myNotificationPanel.setVisible(true);
        } else {
            this.myNotificationPanel.setVisible(false);
        }
        if (!model.isEmpty()) {
            this.myThreadList.setSelectedIndex(selectedIndex);
        }
        this.myThreadList.revalidate();
        this.myThreadList.repaint();
    }

    private static void highlightOccurrences(String filter, Project project, Editor editor) {
        int nextOccurrence;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String documentText = editor.getDocument().getText();
        int i = -1;
        while ((nextOccurrence = StringUtil.indexOfIgnoreCase((String)documentText, (String)filter, (int)(i + 1))) >= 0) {
            i = nextOccurrence;
            highlightManager.addOccurrenceHighlight(editor, i, i + filter.length(), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, 4, null);
        }
    }

    public void selectStackFrame(int index) {
        this.myThreadList.setSelectedIndex(index);
    }

    private static ExporterToTextFile createDumpToFileExporter(Project project, List<DumpItem> dumpItems) {
        return new MyToFileExporter(project, dumpItems);
    }

    public static ExporterToTextFile createToFileExporter(Project project, List<ThreadState> threadStates) {
        return new MyToFileExporter(project, DumpItemKt.toDumpItems(threadStates));
    }

    private static class ThreadListCellRenderer
    extends ColoredListCellRenderer<DumpItem> {
        private String iconToolTip;

        private ThreadListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends DumpItem> list, DumpItem threadState, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ThreadListCellRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(threadState.getIcon());
            this.iconToolTip = threadState.getIconToolTip();
            if (!selected) {
                DumpItem selectedThread = list.getSelectedValue();
                this.setBackground(ThreadListCellRenderer.getBackgroundColor(threadState, selectedThread));
            }
            SimpleTextAttributes attrs = threadState.getAttributes();
            this.append(threadState.getName(), attrs);
            this.append(threadState.getStateDesc(), attrs);
        }

        protected String getIconToolTipText() {
            return this.iconToolTip;
        }

        @NotNull
        private static Color getBackgroundColor(DumpItem threadState, DumpItem selectedThread) {
            if (threadState.isDeadLocked()) {
                Color color = LightColors.RED;
                if (color == null) {
                    ThreadListCellRenderer.$$$reportNull$$$0(1);
                }
                return color;
            }
            if (selectedThread != null && threadState.getAwaitingDumpItems().contains(selectedThread)) {
                Color color = LightColors.YELLOW;
                if (color == null) {
                    ThreadListCellRenderer.$$$reportNull$$$0(2);
                }
                return color;
            }
            Color color = UIUtil.getListBackground();
            if (color == null) {
                ThreadListCellRenderer.$$$reportNull$$$0(3);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/unscramble/ThreadDumpPanel$ThreadListCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$ThreadListCellRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackgroundColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class FilterAction
    extends ToggleAction
    implements DumbAware {
        private FilterAction() {
            super(CommonBundle.messagePointer((String)"action.text.filter", (Object[])new Object[0]), JavaFrontbackBundle.lazyMessage("action.description.show.only.threads.containing.a.specific.string", new Object[0]), AllIcons.General.Filter);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                FilterAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(1);
            }
            return ThreadDumpPanel.this.myFilterPanel.isVisible();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(2);
            }
            ThreadDumpPanel.this.myFilterPanel.setVisible(state);
            if (state) {
                IdeFocusManager.getInstance((Project)FilterAction.getEventProject((AnActionEvent)e)).requestFocus((Component)ThreadDumpPanel.this.myFilterField, true);
                ThreadDumpPanel.this.myFilterField.selectText();
            }
            ThreadDumpPanel.this.updateThreadDumpItemList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/unscramble/ThreadDumpPanel$FilterAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$FilterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class CopyToClipboardAction
    extends DumbAwareAction {
        private static final NotificationGroup GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Analyze thread dump");
        private final Project myProject;

        private CopyToClipboardAction(Project project) {
            super(JavaFrontbackBundle.message("action.text.copy.to.clipboard", new Object[0]), JavaFrontbackBundle.message("action.description.copy.whole.thread.dump.to.clipboard", new Object[0]), PlatformIcons.COPY_ICON);
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToClipboardAction.$$$reportNull$$$0(0);
            }
            boolean isTruncated = ThreadDumpPanel.this.myDumpItemsTruncated > 0;
            StringBuilder buf = new StringBuilder();
            String firstLine = isTruncated ? "Truncated thread dump" : "Full thread dump";
            buf.append(firstLine).append("\n\n");
            for (DumpItem state : ThreadDumpPanel.this.myThreadDump) {
                buf.append(state.getStackTrace()).append("\n\n");
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(buf.toString()));
            String message = isTruncated ? JavaFrontbackBundle.message("notification.text.truncated.thread.dump.was.successfully.copied.to.clipboard", new Object[0]) : JavaFrontbackBundle.message("notification.text.full.thread.dump.was.successfully.copied.to.clipboard", new Object[0]);
            GROUP.createNotification(message, MessageType.INFO).notify(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/unscramble/ThreadDumpPanel$CopyToClipboardAction", "actionPerformed"));
        }
    }

    private final class SortThreadsAction
    extends DumbAwareAction {
        private SortThreadsAction() {
            super(JavaFrontbackBundle.message("sort.threads.by.interest.level", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SortThreadsAction.$$$reportNull$$$0(0);
            }
            ThreadDumpPanel.this.currentComparator = ThreadDumpPanel.this.currentComparator == DumpItem.BY_INTEREST ? DumpItem.BY_NAME : DumpItem.BY_INTEREST;
            this.update(e);
            ThreadDumpPanel.this.sortAndUpdateThreadDumpItemList();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SortThreadsAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SortThreadsAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setIcon(ThreadDumpPanel.this.currentComparator == DumpItem.BY_INTEREST ? AllIcons.ObjectBrowser.Sorted : AllIcons.ObjectBrowser.SortByType);
            e.getPresentation().setText(ThreadDumpPanel.this.currentComparator == DumpItem.BY_INTEREST ? JavaFrontbackBundle.message("sort.threads.by.name", new Object[0]) : JavaFrontbackBundle.message("sort.threads.by.interest.level", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/unscramble/ThreadDumpPanel$SortThreadsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$SortThreadsAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class MergeStacktracesAction
    extends ToggleAction
    implements DumbAware {
        private MergeStacktracesAction() {
            super(JavaFrontbackBundle.lazyMessage("action.text.merge.identical.stacktraces", new Object[0]), JavaFrontbackBundle.lazyMessage("action.description.group.threads.with.identical.stacktraces", new Object[0]), AllIcons.Actions.Collapseall);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeStacktracesAction.$$$reportNull$$$0(0);
            }
            return UISettings.getInstance().getState().getMergeEqualStackTraces();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MergeStacktracesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MergeStacktracesAction.$$$reportNull$$$0(2);
            }
            UISettings.getInstance().getState().setMergeEqualStackTraces(state);
            ThreadDumpPanel.this.updateThreadDumpItemList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/unscramble/ThreadDumpPanel$MergeStacktracesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$MergeStacktracesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyToFileExporter
    implements ExporterToTextFile {
        private final Project myProject;
        private final List<? extends DumpItem> myThreadStates;
        @NonNls
        private static final String DEFAULT_REPORT_FILE_NAME = "threads_report.txt";

        private MyToFileExporter(Project project, List<? extends DumpItem> threadStates) {
            this.myProject = project;
            this.myThreadStates = threadStates;
        }

        @NotNull
        public String getReportText() {
            StringBuilder sb = new StringBuilder();
            for (DumpItem dumpItem : this.myThreadStates) {
                sb.append(dumpItem.getStackTrace()).append("\n\n");
            }
            String string = sb.toString();
            if (string == null) {
                MyToFileExporter.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getDefaultFilePath() {
            VirtualFile baseDir = this.myProject.getBaseDir();
            if (baseDir != null) {
                String string = baseDir.getPresentableUrl() + File.separator + DEFAULT_REPORT_FILE_NAME;
                if (string == null) {
                    MyToFileExporter.$$$reportNull$$$0(1);
                }
                return string;
            }
            return "";
        }

        public boolean canExport() {
            return !this.myThreadStates.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/unscramble/ThreadDumpPanel$MyToFileExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReportText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilePath";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

