/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.toolbar.userCircles;

import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.control.CWMDrawingData;
import com.intellij.cwm.plugin.common.control.CWMDrawingDataKt;
import com.intellij.cwm.plugin.common.control.UserCircleUtilsKt;
import com.intellij.cwm.plugin.common.control.icons.coolIcon.CWMCoolUserWidget;
import com.intellij.cwm.plugin.common.control.icons.coolIcon.CWMCoolUserWidgetStroke;
import com.intellij.cwm.plugin.common.toolbar.CWMAction;
import com.intellij.cwm.plugin.common.toolbar.CWMUserCirclesGroup;
import com.intellij.cwm.plugin.common.toolbar.CodeWithMeUsersGroup;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.codeWithMe.model.TelephonyProperties;
import com.jetbrains.rd.util.reactive.IProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0015\u0010\u0018\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/cwm/plugin/common/toolbar/userCircles/UserCircleAction;", "Lcom/intellij/cwm/plugin/common/toolbar/CWMAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "project", "Lcom/intellij/openapi/project/Project;", "userModel", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/codeWithMe/model/RdUserModel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "doUpdate", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "user", "getIcon", "Ljavax/swing/Icon;", "properties", "Lcom/jetbrains/codeWithMe/model/TelephonyProperties;", "intellij.cwm.plugin.common"})
public final class UserCircleAction
extends CWMAction
implements CustomComponentAction {
    @NotNull
    private final Project project;
    @NotNull
    private final RdUserModel userModel;

    public UserCircleAction(@NotNull Project project, @NotNull RdUserModel userModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userModel, (String)"userModel");
        this.project = project;
        this.userModel = userModel;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        CWMCoolUserWidget userCircle = new CWMCoolUserWidget("0", arg_0 -> UserCircleAction.createCustomComponent$lambda$0(this, arg_0), arg_0 -> UserCircleAction.createCustomComponent$lambda$1(this, arg_0), false, 8, null);
        userCircle.setBackground((Color)CWMDrawingDataKt.getBackgroundColor(this.userModel));
        userCircle.setForeground((Color)CWMDrawingDataKt.getForegroundColor(this.userModel));
        return userCircle;
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        ((CWMCoolUserWidget)component).updateFromPresentation(presentation);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        UserManager userManager = UserManager.Companion.getInstance(project2);
        e.getPresentation().setText(String.valueOf(Character.toUpperCase(this.userModel.getName().charAt(0))));
        String info = UserCircleUtilsKt.getCircleTooltipText((RdUserModel)userManager.getLead().getValue(), this.userModel);
        Presentation presentation = e.getPresentation();
        if (((CharSequence)info).length() == 0) {
            string = this.getName(this.userModel);
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.getName(this.userModel);
            Intrinsics.checkNotNullExpressionValue((Object)ColorUtil.toHex((Color)CWMDrawingData.INSTANCE.getToolTipForeground()), (String)"toHex(...)");
            objectArray[2] = info;
            string = CodeWithMeCommonBundle.INSTANCE.message("circle.control.tooltip", objectArray);
        }
        presentation.setDescription(string);
        RdUserProperties rdUserProperties = userManager.getUserProperties(this.userModel);
        IProperty telephonyProperties = rdUserProperties != null ? rdUserProperties.getTelephonyProperty() : null;
        IProperty iProperty = telephonyProperties;
        e.getPresentation().putClientProperty(ActionUtil.SECONDARY_ICON, (Object)this.getIcon((TelephonyProperties)(iProperty != null ? (TelephonyProperties)iProperty.getValue() : null)));
        e.getPresentation().putClientProperty(CWMUserCirclesGroup.Companion.getCircleStateKey$intellij_cwm_plugin_common(), (Object)(userManager.isFullSyncWith(this.userModel) ? CWMCoolUserWidgetStroke.FullSync : (Intrinsics.areEqual((Object)userManager.getLead().getValue(), (Object)this.userModel) ? CWMCoolUserWidgetStroke.Follow : CWMCoolUserWidgetStroke.None)));
    }

    private final String getName(RdUserModel user) {
        return CodeWithMeUsersGroup.Companion.getNameWithInfo(user, CodeWithMeUsersGroup.Companion.getAdditionText(user, UserManagerKt.isMe(user) ? CodeWithMeCommonBundle.INSTANCE.message("circle.control.user.state.you", new Object[0]) : null), false);
    }

    private final Icon getIcon(TelephonyProperties properties) {
        if (properties == null) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)properties.isJoinedToCall().getValueOrNull(), (Object)true)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)properties.isSharingEnabled().getValueOrNull(), (Object)true)) {
            return AllIcons.CodeWithMe.CwmSharingAvatarOn;
        }
        if (Intrinsics.areEqual((Object)properties.isCameraEnabled().getValueOrNull(), (Object)true)) {
            return AllIcons.CodeWithMe.CwmCamAvatarOn;
        }
        if (Intrinsics.areEqual((Object)properties.isMicrophoneEnabled().getValueOrNull(), (Object)true)) {
            return AllIcons.CodeWithMe.CwmMicAvatarOn;
        }
        return AllIcons.CodeWithMe.CwmMicAvatarOff;
    }

    private static final Unit createCustomComponent$lambda$0(UserCircleAction this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (UserManagerKt.isMe(this$0.userModel)) {
            UserCircleUtilsKt.showMakeEveryoneFollowYouPopup(this$0.project, new RelativePoint(e.getComponent(), e.getPoint()));
        } else {
            UserCircleUtilsKt.toggleCircleFollowState(this$0.project, this$0.userModel);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCustomComponent$lambda$1(UserCircleAction this$0, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (UserManagerKt.isMe(this$0.userModel)) {
            return Unit.INSTANCE;
        }
        Project project = this$0.project;
        RdUserModel rdUserModel = this$0.userModel;
        Component component = e.getComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        RelativePoint relativePoint = RelativePoint.getSouthEastOf((JComponent)((JComponent)component));
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getSouthEastOf(...)");
        UserCircleUtilsKt.circleShowUserGroupPopup(project, rdUserModel, relativePoint);
        return Unit.INSTANCE;
    }
}

