/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.GradleTestEventConverter;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventProcessor;

public abstract class AbstractTestEventProcessor
implements TestEventProcessor {
    private final GradleTestsExecutionConsole myExecutionConsole;

    public AbstractTestEventProcessor(GradleTestsExecutionConsole executionConsole) {
        this.myExecutionConsole = executionConsole;
    }

    public GradleTestsExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    protected SMTestRunnerResultsForm getResultsViewer() {
        return this.getExecutionConsole().getResultsViewer();
    }

    protected Project getProject() {
        return this.getProperties().getProject();
    }

    protected GradleConsoleProperties getProperties() {
        return (GradleConsoleProperties)this.getExecutionConsole().getProperties();
    }

    protected boolean isSuite() {
        return false;
    }

    @Nullable
    protected SMTestProxy findTestProxy(@Nullable String testId) {
        return this.getExecutionConsole().getTestsMap().get(testId);
    }

    @NotNull
    protected SMTestProxy findParentTestProxy(@Nullable String parentTestId) {
        SMTestProxy.SMRootTestProxy rootNode = this.getResultsViewer().getTestsRootNode();
        if (StringUtil.isEmpty((String)parentTestId)) {
            SMTestProxy.SMRootTestProxy sMRootTestProxy = rootNode;
            if (sMRootTestProxy == null) {
                AbstractTestEventProcessor.$$$reportNull$$$0(0);
            }
            return sMRootTestProxy;
        }
        SMTestProxy node = this.findTestProxy(parentTestId);
        if (node == null) {
            SMTestProxy.SMRootTestProxy sMRootTestProxy = rootNode;
            if (sMRootTestProxy == null) {
                AbstractTestEventProcessor.$$$reportNull$$$0(1);
            }
            return sMRootTestProxy;
        }
        SMTestProxy sMTestProxy = node;
        if (sMTestProxy == null) {
            AbstractTestEventProcessor.$$$reportNull$$$0(2);
        }
        return sMTestProxy;
    }

    protected void registerTestProxy(String proxyId, SMTestProxy testProxy) {
        this.getExecutionConsole().getTestsMap().put(proxyId, testProxy);
    }

    protected boolean showInternalTestNodes() {
        return GradleConsoleProperties.SHOW_INTERNAL_TEST_NODES.value((AbstractProperty.AbstractPropertyContainer)this.getProperties());
    }

    @NotNull
    protected GradleSMTestProxy createTestProxy(@Nullable String parentTestId, @NotNull String suiteName, @NotNull String className, @Nullable String methodName, @NotNull String displayName) {
        if (suiteName == null) {
            AbstractTestEventProcessor.$$$reportNull$$$0(3);
        }
        if (className == null) {
            AbstractTestEventProcessor.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            AbstractTestEventProcessor.$$$reportNull$$$0(5);
        }
        Project project = this.getProject();
        boolean isSuite = this.isSuite();
        SMTestProxy parentTestProxy = this.findParentTestProxy(parentTestId);
        GradleTestEventConverter eventConverter = new GradleTestEventConverter(project, parentTestProxy, isSuite, suiteName, className, methodName, displayName);
        String aClassName = eventConverter.getConvertedClassName();
        String aMethodName = eventConverter.getConvertedMethodName();
        String aParamName = eventConverter.getConvertedParameterName();
        String aDisplayName = eventConverter.getConvertedDisplayName();
        String locationProtocol = isSuite ? "java:suite" : "java:test";
        String locationUrl = JavaTestLocator.createLocationUrl((String)locationProtocol, (String)aClassName, (String)aMethodName, (String)aParamName);
        GradleSMTestProxy testProxy = new GradleSMTestProxy(aDisplayName, isSuite, locationUrl);
        testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
        testProxy.setParentId(parentTestId);
        GradleSMTestProxy gradleSMTestProxy = testProxy;
        if (gradleSMTestProxy == null) {
            AbstractTestEventProcessor.$$$reportNull$$$0(6);
        }
        return gradleSMTestProxy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEventProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findParentTestProxy";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AbstractTestEventProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProxy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestProxy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

