/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.MetaMethod;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.ArrayTypeUtils;
import org.codehaus.groovy.runtime.InvokerHelper;

public class MethodClosure
extends Closure {
    public static final String NEW = "new";
    public static final String ANY_INSTANCE_METHOD_EXISTS = "anyInstanceMethodExists";
    private static final long serialVersionUID = -2491254866810955844L;
    public static boolean ALLOW_RESOLVE = false;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final String method;
    private final boolean anyInstanceMethodExists;

    public MethodClosure(Object owner, String method) {
        super(owner);
        this.method = method;
        Class<?> clazz = owner.getClass() == Class.class ? (Class<?>)owner : owner.getClass();
        this.maximumNumberOfParameters = 0;
        this.parameterTypes = EMPTY_CLASS_ARRAY;
        List<MetaMethod> methods = InvokerHelper.getMetaClass(clazz).respondsTo(owner, method);
        int instanceMethodCnt = 0;
        for (MetaMethod m : methods) {
            Class[] newParameterTypes = this.makeParameterTypes(owner, m);
            this.setParameterTypesAndNumber(newParameterTypes);
            if (m.isStatic()) continue;
            ++instanceMethodCnt;
        }
        boolean bl = this.anyInstanceMethodExists = instanceMethodCnt > 0;
        if (NEW.equals(method)) {
            if (clazz.isArray()) {
                Object[] sizeTypes = new Class[ArrayTypeUtils.dimension(clazz)];
                Arrays.fill(sizeTypes, Integer.TYPE);
                this.setParameterTypesAndNumber((Class[])sizeTypes);
            } else {
                for (CachedConstructor c : ReflectionCache.getCachedClass(clazz).getConstructors()) {
                    Class[] newParameterTypes = c.getNativeParameterTypes();
                    this.setParameterTypesAndNumber(newParameterTypes);
                }
            }
        }
    }

    private void setParameterTypesAndNumber(Class[] newParameterTypes) {
        if (newParameterTypes.length <= this.maximumNumberOfParameters) {
            return;
        }
        this.maximumNumberOfParameters = newParameterTypes.length;
        this.parameterTypes = newParameterTypes;
    }

    private Class[] makeParameterTypes(Object owner, MetaMethod m) {
        Class[] newParameterTypes;
        if (owner instanceof Class && !m.isStatic()) {
            Class[] nativeParameterTypes = m.getNativeParameterTypes();
            newParameterTypes = new Class[nativeParameterTypes.length + 1];
            System.arraycopy(nativeParameterTypes, 0, newParameterTypes, 1, nativeParameterTypes.length);
            newParameterTypes[0] = (Class)owner;
        } else {
            newParameterTypes = m.getNativeParameterTypes();
        }
        return newParameterTypes;
    }

    public String getMethod() {
        return this.method;
    }

    protected Object doCall(Object arguments) {
        return InvokerHelper.invokeMethod(this.getOwner(), this.method, arguments);
    }

    private Object readResolve() {
        if (ALLOW_RESOLVE) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (ALLOW_RESOLVE) {
            stream.defaultReadObject();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String property) {
        if ("method".equals(property)) {
            return this.getMethod();
        }
        if (ANY_INSTANCE_METHOD_EXISTS.equals(property)) {
            return this.anyInstanceMethodExists;
        }
        return super.getProperty(property);
    }
}

