/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.modelProvider;

import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public class GradleClassProjectModelProvider<T>
implements ProjectImportModelProvider {
    private static final long serialVersionUID = 2L;
    private final Class<T> modelClass;
    private final GradleModelFetchPhase phase;

    public GradleClassProjectModelProvider(Class<T> modelClass) {
        this(modelClass, GradleModelFetchPhase.ADDITIONAL_MODEL_PHASE);
    }

    public GradleClassProjectModelProvider(Class<T> modelClass, GradleModelFetchPhase phase) {
        this.modelClass = modelClass;
        this.phase = phase;
    }

    @Override
    public GradleModelFetchPhase getPhase() {
        return this.phase;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.modelClass.getSimpleName();
        if (string == null) {
            GradleClassProjectModelProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void populateModels(@NotNull BuildController controller, @NotNull Collection<? extends GradleBuild> buildModels, @NotNull ProjectImportModelProvider.GradleModelConsumer modelConsumer) {
        if (controller == null) {
            GradleClassProjectModelProvider.$$$reportNull$$$0(1);
        }
        if (buildModels == null) {
            GradleClassProjectModelProvider.$$$reportNull$$$0(2);
        }
        if (modelConsumer == null) {
            GradleClassProjectModelProvider.$$$reportNull$$$0(3);
        }
        for (GradleBuild gradleBuild : buildModels) {
            for (BasicGradleProject projectModel : gradleBuild.getProjects()) {
                Object instance = controller.findModel((Model)projectModel, this.modelClass);
                if (instance == null) continue;
                modelConsumer.consumeProjectModel(projectModel, instance, this.modelClass);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleClassProjectModelProvider provider = (GradleClassProjectModelProvider)o;
        return this.modelClass.equals(provider.modelClass);
    }

    public int hashCode() {
        return this.modelClass.hashCode();
    }

    public String toString() {
        return "ProjectModel(" + this.modelClass.getName() + ")";
    }

    public static List<? extends GradleClassProjectModelProvider<?>> createAll(Class<?> ... modelClasses) {
        return GradleClassProjectModelProvider.createAll(Arrays.asList(modelClasses));
    }

    public static List<? extends GradleClassProjectModelProvider<?>> createAll(Collection<Class<?>> modelClasses) {
        ArrayList providers = new ArrayList();
        for (Class<?> modelClass : modelClasses) {
            providers.add(new GradleClassProjectModelProvider(modelClass));
        }
        return providers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/modelProvider/GradleClassProjectModelProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModels";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/modelProvider/GradleClassProjectModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "populateModels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

