/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$\u00a8\u0006\u0010"}, d2={"Lgit4idea/rebase/GitAutoSquashCommitAction;", "Lgit4idea/rebase/GitSingleCommitEditingAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "commitEditingData", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "actionPerformedAfterChecks", "getCommitMessage", "", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "GitRebaseAfterCommitExecutor", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitAutoSquashCommitAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAutoSquashCommitAction.kt\ngit4idea/rebase/GitAutoSquashCommitAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n774#2:68\n865#2,2:69\n*S KotlinDebug\n*F\n+ 1 GitAutoSquashCommitAction.kt\ngit4idea/rebase/GitAutoSquashCommitAction\n*L\n32#1:68\n32#1:69,2\n*E\n"})
public abstract class GitAutoSquashCommitAction
extends GitSingleCommitEditingAction {
    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        if (ChangeListManager.getInstance((Project)commitEditingData.getProject()).getDefaultChangeList().getChanges().isEmpty()) {
            e.getPresentation().setDescription(GitBundle.message((String)"action.Git.Fixup.To.Commit.description.nothing.to.commit", (Object[])new Object[0]));
            e.getPresentation().setEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void actionPerformedAfterChecks(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        List list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        VcsCommitMetadata commit = commitEditingData.getSelectedCommit();
        Project project = commitEditingData.getProject();
        LocalChangeList localChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList changeList = localChangeList;
        GitRepository repository2 = commitEditingData.getRepository();
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        GitRepositoryManager gitRepositoryManager2 = gitRepositoryManager;
        Collection collection = changeList.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Change it = (Change)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)gitRepositoryManager2.getRepositoryForFileQuick(ChangesUtil.getFilePath((Change)it)), (Object)repository2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List changes = (List)destination$iv$iv;
        if (changes.isEmpty()) {
            CommitChangeListDialog.showNothingToCommitMessage((Project)project);
            return;
        }
        GitVcs gitVcs = repository2.getVcs();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getVcs(...)");
        GitVcs gitVcs2 = gitVcs;
        Set affectedVcses = SetsKt.setOf((Object)((Object)gitVcs2));
        List<CommitExecutor> list2 = gitVcs2.getCommitExecutors();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCommitExecutors(...)");
        Collection collection2 = list2;
        GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = commitEditingData;
        String string = GitBundle.message((String)"rebase.log.action.operation.rebase.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        if (this.getProhibitedStateMessage(multipleCommitEditingData, string) == null) {
            GitRebaseParams.RebaseUpstream upstream = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor((VcsShortCommitDetails)commit);
            list = CollectionsKt.listOf((Object)new GitRebaseAfterCommitExecutor(project, repository2, upstream));
        } else {
            list = CollectionsKt.emptyList();
        }
        List executors = CollectionsKt.plus((Collection)collection2, (Iterable)list);
        String commitMessage = this.getCommitMessage((VcsShortCommitDetails)commit);
        CommitChangeListDialog.showCommitDialog((Project)project, (Set)affectedVcses, (Collection)changes, (LocalChangeList)changeList, (List)executors, (boolean)true, (String)commitMessage, null);
    }

    @NotNull
    protected abstract String getCommitMessage(@NotNull VcsShortCommitDetails var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lgit4idea/rebase/GitAutoSquashCommitAction$GitRebaseAfterCommitExecutor;", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "upstream", "Lgit4idea/branch/GitRebaseParams$RebaseUpstream;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepository;Lgit4idea/branch/GitRebaseParams$RebaseUpstream;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "getUpstream", "()Lgit4idea/branch/GitRebaseParams$RebaseUpstream;", "getActionText", "", "createCommitSession", "Lcom/intellij/openapi/vcs/changes/CommitSession;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "supportsPartialCommit", "", "intellij.vcs.git"})
    public static final class GitRebaseAfterCommitExecutor
    implements CommitExecutor {
        @NotNull
        private final Project project;
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRebaseParams.RebaseUpstream upstream;

        public GitRebaseAfterCommitExecutor(@NotNull Project project, @NotNull GitRepository repository2, @NotNull GitRebaseParams.RebaseUpstream upstream) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
            this.project = project;
            this.repository = repository2;
            this.upstream = upstream;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRebaseParams.RebaseUpstream getUpstream() {
            return this.upstream;
        }

        @NotNull
        public String getActionText() {
            String string = GitBundle.message((String)"commit.action.commit.and.rebase.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public CommitSession createCommitSession(@NotNull CommitContext commitContext) {
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            CommitSession commitSession = CommitSession.VCS_COMMIT;
            Intrinsics.checkNotNullExpressionValue((Object)commitSession, (String)"VCS_COMMIT");
            return commitSession;
        }

        public boolean supportsPartialCommit() {
            return true;
        }
    }
}

