/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.BaseKotlinImportLayoutPanelKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0004J\b\u0010\u0010\u001a\u00020\u000fH\u0004J\b\u0010\u0011\u001a\u00020\u000fH\u0004J\b\u0010\u0012\u001a\u00020\u000fH\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0004J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/BaseKotlinImportLayoutPanel;", "Ljavax/swing/JPanel;", "title", "", "<init>", "(Ljava/lang/String;)V", "packageTable", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "getPackageTable", "()Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "layoutTable", "Lcom/intellij/ui/table/JBTable;", "getLayoutTable", "()Lcom/intellij/ui/table/JBTable;", "addPackage", "", "removePackage", "movePackageUp", "movePackageDown", "refreshTableModel", "row", "", "resizeColumns", "fixColumnWidthToHeader", "columnIndex", "kotlin.formatter.minimal"})
public class BaseKotlinImportLayoutPanel
extends JPanel {
    @NotNull
    private final KotlinPackageEntryTable packageTable;
    @NotNull
    private final JBTable layoutTable;

    public BaseKotlinImportLayoutPanel(@Nls @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(new BorderLayout());
        this.packageTable = new KotlinPackageEntryTable();
        this.layoutTable = BaseKotlinImportLayoutPanelKt.createTableForPackageEntries(this.packageTable);
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false, (Insets)((Insets)JBInsets.emptyInsets())));
        this.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
    }

    @NotNull
    public final KotlinPackageEntryTable getPackageTable() {
        return this.packageTable;
    }

    @NotNull
    public final JBTable getLayoutTable() {
        return this.layoutTable;
    }

    protected final void addPackage() {
        int row = this.layoutTable.getSelectedRow() + 1;
        if (row < 0) {
            row = this.packageTable.getEntryCount();
        }
        KotlinPackageEntry entry = new KotlinPackageEntry("", true);
        this.packageTable.insertEntryAt(entry, row);
        this.refreshTableModel(row);
    }

    protected final void removePackage() {
        int row = this.layoutTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        KotlinPackageEntry entry = this.packageTable.getEntryAt(row);
        if (entry.isSpecial()) {
            return;
        }
        TableUtil.stopEditing((JTable)((JTable)this.layoutTable));
        this.packageTable.removeEntryAt(row);
        TableModel tableModel = this.layoutTable.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        AbstractTableModel model = (AbstractTableModel)tableModel;
        model.fireTableRowsDeleted(row, row);
        if (row >= this.packageTable.getEntryCount()) {
            --row;
        }
        if (row >= 0) {
            this.layoutTable.setRowSelectionInterval(row, row);
        }
    }

    protected final void movePackageUp() {
        int row = this.layoutTable.getSelectedRow();
        if (row < 1) {
            return;
        }
        TableUtil.stopEditing((JTable)((JTable)this.layoutTable));
        KotlinPackageEntry entry = this.packageTable.getEntryAt(row);
        KotlinPackageEntry previousEntry = this.packageTable.getEntryAt(row - 1);
        this.packageTable.setEntryAt(entry, row - 1);
        this.packageTable.setEntryAt(previousEntry, row);
        TableModel tableModel = this.layoutTable.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        AbstractTableModel model = (AbstractTableModel)tableModel;
        model.fireTableRowsUpdated(row - 1, row);
        this.layoutTable.setRowSelectionInterval(row - 1, row - 1);
    }

    protected final void movePackageDown() {
        int row = this.layoutTable.getSelectedRow();
        if (row >= this.packageTable.getEntryCount() - 1) {
            return;
        }
        TableUtil.stopEditing((JTable)((JTable)this.layoutTable));
        KotlinPackageEntry entry = this.packageTable.getEntryAt(row);
        KotlinPackageEntry nextEntry = this.packageTable.getEntryAt(row + 1);
        this.packageTable.setEntryAt(entry, row + 1);
        this.packageTable.setEntryAt(nextEntry, row);
        TableModel tableModel = this.layoutTable.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        AbstractTableModel model = (AbstractTableModel)tableModel;
        model.fireTableRowsUpdated(row, row + 1);
        this.layoutTable.setRowSelectionInterval(row + 1, row + 1);
    }

    private final void refreshTableModel(int row) {
        TableModel tableModel = this.layoutTable.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
        AbstractTableModel model = (AbstractTableModel)tableModel;
        model.fireTableRowsInserted(row, row);
        this.layoutTable.setRowSelectionInterval(row, row);
        TableUtil.editCellAt((JTable)((JTable)this.layoutTable), (int)row, (int)0);
        Component editorComp = this.layoutTable.getEditorComponent();
        if (editorComp != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> BaseKotlinImportLayoutPanel.refreshTableModel$lambda$0(editorComp));
        }
    }

    protected final void resizeColumns() {
        TableColumnModel tableColumnModel;
        ColoredTableCellRenderer packageRenderer2 = new ColoredTableCellRenderer(this){
            final /* synthetic */ BaseKotlinImportLayoutPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                KotlinPackageEntry entry = this.this$0.getPackageTable().getEntryAt(row);
                TextAttributes attributes = KotlinHighlightingColors.KEYWORD.getDefaultAttributes();
                this.append(KotlinBundle.message("import.text.import", new Object[0]), SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                KotlinPackageEntry kotlinPackageEntry = entry;
                if (Intrinsics.areEqual((Object)kotlinPackageEntry, (Object)KotlinPackageEntry.ALL_OTHER_IMPORTS_ENTRY)) {
                    this.append(KotlinBundle.message("import.text.all.other.imports", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else if (Intrinsics.areEqual((Object)kotlinPackageEntry, (Object)KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY)) {
                    this.append(KotlinBundle.message("import.text.all.alias.imports", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(entry.getPackageName() + ".*", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
        TableColumnModel $this$resizeColumns_u24lambda_u241 = tableColumnModel = this.layoutTable.getColumnModel();
        boolean bl = false;
        $this$resizeColumns_u24lambda_u241.getColumn(0).setCellRenderer((TableCellRenderer)packageRenderer2);
        $this$resizeColumns_u24lambda_u241.getColumn(1).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.fixColumnWidthToHeader(1);
    }

    private final void fixColumnWidthToHeader(int columnIndex) {
        JBTable $this$fixColumnWidthToHeader_u24lambda_u242 = this.layoutTable;
        boolean bl = false;
        TableColumn column = $this$fixColumnWidthToHeader_u24lambda_u242.getColumnModel().getColumn(columnIndex);
        int width = 15 + $this$fixColumnWidthToHeader_u24lambda_u242.getTableHeader().getFontMetrics($this$fixColumnWidthToHeader_u24lambda_u242.getTableHeader().getFont()).stringWidth($this$fixColumnWidthToHeader_u24lambda_u242.getColumnName(columnIndex));
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    private static final void refreshTableModel$lambda$0(Component $editorComp) {
        IdeFocusManager.getGlobalInstance().requestFocus($editorComp, true);
    }
}

