/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.framework.main.EditPluginPathDialog;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.net.DefaultKeyManagerFactory;
import ghidra.net.PKIUtils;
import ghidra.util.HelpLocation;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;

class EditActionManager {
    public static final GhidraFileFilter CERTIFICATE_FILE_FILTER = new ExtensionFileFilter(PKIUtils.PKCS_FILE_EXTENSIONS, "PKCS Key File");
    private FrontEndPlugin plugin;
    private FrontEndTool tool;
    private DockingAction editPluginPathAction;
    private DockingAction editCertPathAction;
    private DockingAction clearCertPathAction;

    EditActionManager(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = (FrontEndTool)plugin.getTool();
        this.createActions();
    }

    private void createActions() {
        this.editPluginPathAction = new DockingAction("Edit Plugin Path", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditActionManager.this.editPluginPath();
            }
        };
        this.editPluginPathAction.setEnabled(true);
        this.editPluginPathAction.setMenuBarData(new MenuData(new String[]{"&Edit", "Plugin Path..."}, "GEdit"));
        this.editCertPathAction = new DockingAction("Set PKI Certificate", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditActionManager.this.editCertPath();
            }
        };
        this.editCertPathAction.setEnabled(true);
        this.editCertPathAction.setMenuBarData(new MenuData(new String[]{"&Edit", "Set PKI Certificate..."}, "PKI"));
        this.clearCertPathAction = new DockingAction("Clear PKI Certificate", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditActionManager.this.clearCertPath();
            }
        };
        this.clearCertPathAction.setEnabled(DefaultKeyManagerFactory.getKeyStore() != null);
        this.clearCertPathAction.setMenuBarData(new MenuData(new String[]{"&Edit", "Clear PKI Certificate..."}, "PKI"));
        this.clearCertPathAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Set_PKI_Certificate"));
        this.tool.addAction((DockingActionIf)this.editCertPathAction);
        this.tool.addAction((DockingActionIf)this.clearCertPathAction);
        this.tool.addAction((DockingActionIf)this.editPluginPathAction);
    }

    private void editPluginPath() {
        EditPluginPathDialog pluginPathDialog = new EditPluginPathDialog();
        pluginPathDialog.show(this.tool);
    }

    private void clearCertPath() {
        String path = DefaultKeyManagerFactory.getKeyStore();
        if (path == null) {
            this.clearCertPathAction.setEnabled(false);
            return;
        }
        if (1 != OptionDialog.showYesNoDialog((Component)this.tool.getToolFrame(), (String)"Clear PKI Certificate", (String)("Clear PKI certificate setting?\n(" + path + ")"))) {
            return;
        }
        DefaultKeyManagerFactory.setDefaultKeyStore(null, (boolean)true);
        this.clearCertPathAction.setEnabled(false);
    }

    private void editCertPath() {
        GhidraFileChooser certFileChooser = this.createCertFileChooser();
        File dir = null;
        File oldFile = null;
        String path = DefaultKeyManagerFactory.getKeyStore();
        if (path != null) {
            oldFile = new File(path);
            dir = oldFile.getParentFile();
            if (!oldFile.isFile()) {
                oldFile = null;
                if (!dir.isDirectory()) {
                    dir = null;
                }
            }
        }
        if (dir == null) {
            dir = new File(System.getProperty("user.home"));
        }
        if (oldFile != null) {
            certFileChooser.setSelectedFile(oldFile);
        } else {
            certFileChooser.setCurrentDirectory(dir);
        }
        boolean validInput = false;
        while (!validInput) {
            File file = certFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            DefaultKeyManagerFactory.setDefaultKeyStore((String)file.getAbsolutePath(), (boolean)true);
            this.clearCertPathAction.setEnabled(true);
            validInput = true;
        }
        certFileChooser.dispose();
    }

    private GhidraFileChooser createCertFileChooser() {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        fileChooser.setTitle("Select Certificate (req'd for PKI authentication only)");
        fileChooser.setApproveButtonText("Set Certificate");
        fileChooser.setFileFilter(CERTIFICATE_FILE_FILTER);
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        fileChooser.setHelpLocation(new HelpLocation(this.plugin.getName(), "Set_PKI_Certificate"));
        return fileChooser;
    }
}

