/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.cmd;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import java.io.File;
import java.io.IOException;

public class ProgramInsertByteProvider
implements ByteProvider {
    private MemoryBufferImpl buffer;
    private ProgramFragment mod;
    private long len;

    public ProgramInsertByteProvider(Memory memory, ProgramFragment mod) {
        this.mod = mod;
        this.len = mod.getMaxAddress().subtract(mod.getMinAddress()) + 1L;
        this.buffer = new MemoryBufferImpl(memory, mod.getMinAddress(), (int)this.len);
    }

    public File getFile() {
        return null;
    }

    public String getName() {
        return this.mod.getName();
    }

    public String getAbsolutePath() {
        return null;
    }

    public long length() {
        return this.len;
    }

    public boolean isValidIndex(long index) {
        if (index < 0L || index > this.len) {
            return false;
        }
        try {
            this.buffer.getByte((int)index);
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
    }

    public void close() throws IOException {
    }

    public byte readByte(long index) throws IOException {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new IOException("index out of range");
        }
        try {
            return this.buffer.getByte((int)index);
        }
        catch (MemoryAccessException e) {
            throw new RuntimeException("index out of range");
        }
    }

    public byte[] readBytes(long index, long length) throws IOException {
        if (index < 0L || index + length - 1L > Integer.MAX_VALUE) {
            throw new IOException("index/length of range");
        }
        int ilen = (int)length;
        byte[] bytes = new byte[ilen];
        if (this.buffer.getBytes(bytes, (int)index) != ilen) {
            throw new RuntimeException("index/length of range");
        }
        return bytes;
    }
}

