/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphCursorRestoringGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphEdgeSelectionGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphEventForwardingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphPickingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphScalingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphScrollWheelPanningPlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphTranslatingGraphMousePlugin;
import ghidra.graph.viewer.event.mouse.VisualGraphZoomingPickingGraphMousePlugin;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class VisualGraphPluggableGraphMouse<V extends VisualVertex, E extends VisualEdge<V>>
implements VisualizationViewer.GraphMouse {
    protected CopyOnWriteArrayList<GraphMousePlugin> mousePlugins = new CopyOnWriteArrayList();

    public VisualGraphPluggableGraphMouse() {
        this.addPlugins();
    }

    protected void addPlugins() {
        this.add((GraphMousePlugin)new VisualGraphEventForwardingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphEdgeSelectionGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphZoomingPickingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphScalingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphScrollWheelPanningPlugin());
        this.add((GraphMousePlugin)new VisualGraphTranslatingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphPickingGraphMousePlugin());
        this.add((GraphMousePlugin)new VisualGraphCursorRestoringGraphMousePlugin());
    }

    public void prepend(GraphMousePlugin p) {
        if (this.mousePlugins.contains(p)) {
            this.mousePlugins.remove(p);
        }
        this.mousePlugins.add(0, p);
    }

    public void add(GraphMousePlugin p) {
        if (this.mousePlugins.contains(p)) {
            this.mousePlugins.remove(p);
        }
        this.mousePlugins.add(p);
    }

    public void remove(GraphMousePlugin p) {
        this.mousePlugins.remove(p);
    }

    public void dispose() {
        for (GraphMousePlugin mp : this.mousePlugins) {
            if (!(mp instanceof VisualGraphMousePlugin)) continue;
            ((VisualGraphMousePlugin)mp).dispose();
        }
        this.mousePlugins.clear();
    }

    private void trace(String s) {
        Msg.trace((Object)this, (Object)s);
    }

    private void trace(String s, MouseEvent e) {
        Msg.trace((Object)this, (Object)("click count = " + e.getClickCount() + " - " + s));
    }

    public void mouseClicked(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseClicked() on " + String.valueOf(p), copy);
            ((MouseListener)p).mouseClicked(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mousePressed(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mousePressed() on " + String.valueOf(p), copy);
            ((MouseListener)p).mousePressed(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseReleased() on " + String.valueOf(p), copy);
            ((MouseListener)p).mouseReleased(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseEntered(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseEntered() on " + String.valueOf(p), copy);
            ((MouseListener)p).mouseEntered(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseExited(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseListener)) continue;
            this.trace("mouseExited() on " + String.valueOf(p), copy);
            ((MouseListener)p).mouseExited(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseDragged(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseMotionListener)) continue;
            this.trace("mouseDragged() on " + String.valueOf(p), copy);
            ((MouseMotionListener)p).mouseDragged(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
        MouseEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseMotionListener)) continue;
            this.trace("mouseMoved() on " + String.valueOf(p), copy);
            ((MouseMotionListener)p).mouseMoved(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        MouseWheelEvent copy = this.copy(e);
        for (GraphMousePlugin p : this.mousePlugins) {
            if (!(p instanceof MouseWheelListener)) continue;
            this.trace("mouseWheelMoved() on " + String.valueOf(p), copy);
            ((MouseWheelListener)p).mouseWheelMoved(copy);
            if (!copy.isConsumed()) continue;
            e.consume();
            this.trace("\tconsumed");
            return;
        }
    }

    private MouseEvent copy(MouseEvent e) {
        Component source = e.getComponent();
        int id = e.getID();
        int button = e.getButton();
        long when = e.getWhen();
        int modifiers = e.getModifiersEx();
        int x = e.getX();
        int y = e.getY();
        int clickCount = e.getClickCount();
        boolean popupTrigger = e.isPopupTrigger();
        return new MouseEvent(source, id, when, modifiers, x, y, clickCount, popupTrigger, button);
    }

    private MouseWheelEvent copy(MouseWheelEvent e) {
        Component source = e.getComponent();
        int id = e.getID();
        long when = e.getWhen();
        int modifiers = e.getModifiersEx();
        int x = e.getX();
        int y = e.getY();
        int clickCount = e.getClickCount();
        boolean popupTrigger = e.isPopupTrigger();
        int scrollType = e.getScrollType();
        int scrollAmount = e.getScrollAmount();
        int wheelRotation = e.getWheelRotation();
        return new MouseWheelEvent(source, id, when, modifiers, x, y, clickCount, popupTrigger, scrollType, scrollAmount, wheelRotation);
    }
}

