/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textpane;

import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class GHtmlTextPane
extends JTextPane {
    public GHtmlTextPane() {
        this.setContentType("text/html");
    }

    @Override
    public String getSelectedText() {
        String html = this.getPrettifiedHtml();
        if (html != null) {
            return html;
        }
        return super.getSelectedText();
    }

    private String getPrettifiedHtml() {
        String selectedHtml = this.getSelectedHtmlText();
        String converted = HTMLUtilities.fromHTML((String)selectedHtml);
        return converted;
    }

    private String getSelectedHtmlText() {
        Document doc = this.getDocument();
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        try {
            Position startPos = doc.createPosition(start);
            Position endPos = doc.createPosition(end);
            int startOffset = startPos.getOffset();
            int endOffset = endPos.getOffset();
            int size = endOffset - startOffset;
            StringWriter stringWriter = new StringWriter(size);
            this.getEditorKit().write(stringWriter, doc, startOffset, size);
            String text = stringWriter.toString();
            return text;
        }
        catch (IOException | BadLocationException e) {
            Msg.error((Object)this, (Object)"Unable to extract HTML text from editor pane", (Throwable)e);
            return null;
        }
    }
}

