/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigTypeSpec;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableTypeSpec
extends CliAbstractTable {
    public CliTableTypeSpec(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliTypeSpecRow row = new CliTypeSpecRow(this.readBlobIndex(reader));
            this.rows.add(row);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            CliTypeSpecRow typeRow = (CliTypeSpecRow)row;
            CliBlob blob = this.metadataStream.getBlobStream().getBlob(typeRow.signatureIndex);
            Address sigAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), typeRow.signatureIndex);
            CliSigTypeSpec typeSig = new CliSigTypeSpec(blob);
            this.metadataStream.getBlobStream().updateBlob(typeSig, sigAddr, program);
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "TypeSpec Row", 0);
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Signature", "index into Blob heap");
        return rowDt;
    }

    public class CliTypeSpecRow
    extends CliAbstractTableRow {
        public int signatureIndex;

        public CliTypeSpecRow(int signatureIndex) {
            this.signatureIndex = signatureIndex;
        }

        @Override
        public String getRepresentation() {
            String sigRep = Integer.toHexString(this.signatureIndex);
            CliBlob blob = CliTableTypeSpec.this.metadataStream.getBlobStream().getBlob(this.signatureIndex);
            try {
                CliSigTypeSpec sig = new CliSigTypeSpec(blob);
                sigRep = sig.getRepresentation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format("%s", sigRep);
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            String sigRep = Integer.toHexString(this.signatureIndex);
            CliBlob blob = stream.getBlobStream().getBlob(this.signatureIndex);
            try {
                CliSigTypeSpec sig = new CliSigTypeSpec(blob);
                sigRep = sig.getRepresentation(stream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format("%s", sigRep);
        }
    }
}

