/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.DockingUtils;
import docking.UndoRedoKeeper;
import ghidra.program.model.symbol.Symbol;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class SymbolEditor
extends DefaultCellEditor {
    private JTextField symbolField = (JTextField)super.getComponent();
    private UndoRedoKeeper undoRedoKeeper;

    public SymbolEditor() {
        super(new JTextField());
        this.symbolField.setBorder(BorderFactory.createEmptyBorder());
        this.undoRedoKeeper = DockingUtils.installUndoRedo((JTextComponent)this.symbolField);
    }

    @Override
    public boolean stopCellEditing() {
        if (super.stopCellEditing()) {
            this.undoRedoKeeper.clear();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.undoRedoKeeper.clear();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Symbol symbol = (Symbol)value;
        if (symbol != null && !symbol.isDeleted()) {
            this.symbolField.setText(symbol.getName());
        } else {
            this.symbolField.setText("");
        }
        return this.symbolField;
    }
}

