/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.menu.MultiActionDockingAction;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.TransactionInfo;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class AbstractUndoRedoAction
extends MultiActionDockingAction {
    private PluginTool tool;
    private Program activeProgram;
    private ProgramManagerPlugin plugin;
    private TransactionListener transactionListener;
    private HelpLocation helpLocation;

    public AbstractUndoRedoAction(PluginTool tool, ProgramManagerPlugin plugin, String name, String iconId, String keyBinding, String subGroup) {
        super(name, plugin.getName());
        this.tool = tool;
        this.plugin = plugin;
        String[] menuPath = new String[]{"&Edit", "&" + name};
        GIcon icon = new GIcon(iconId);
        this.helpLocation = new HelpLocation("Tool", name);
        String group = "Undo";
        MenuData menuData = new MenuData(menuPath, (Icon)icon, group);
        menuData.setMenuSubGroup(subGroup);
        this.setMenuBarData(menuData);
        this.setToolBarData(new ToolBarData((Icon)icon, group));
        this.setKeyBindingData(new KeyBindingData(keyBinding));
        this.setHelpLocation(this.helpLocation);
        this.setDescription(name);
        this.addToWindowWhen(ProgramActionContext.class);
        this.transactionListener = new ContextProgramTransactionListener();
    }

    protected abstract void doAction(Program var1, int var2) throws IOException;

    protected abstract boolean canPerformAction(Program var1);

    protected abstract String getUndoRedoDescription(Program var1);

    public boolean isEnabledForContext(ActionContext context) {
        Program program = this.getProgram(context);
        if (program != this.activeProgram) {
            this.removeTransactionListener(this.activeProgram);
            this.activeProgram = program;
            this.addTransactionListener(this.activeProgram);
            this.updateActionNameAndDescription();
        }
        return this.canPerformAction(this.activeProgram);
    }

    public void actionPerformed(ActionContext context) {
        this.executeAction(context, 1);
    }

    private void executeAction(ActionContext context, int repeatCount) {
        Program program = this.getProgram(context);
        if (program == null) {
            return;
        }
        this.saveCurrentLocationToHistory();
        try {
            this.doAction(program, repeatCount);
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)(this.getName() + " Error"), (Object)("Error occured while attempting " + this.getName() + "!"), (Throwable)e);
        }
    }

    protected abstract List<String> getDescriptions(Program var1);

    public List<DockingActionIf> getActionList(ActionContext context) {
        Program program = this.getProgram(context);
        List<String> descriptions = this.getDescriptions(program);
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        int repeatCount = 1;
        for (String string : descriptions) {
            actions.add((DockingActionIf)new RepeatedAction(string, repeatCount));
            ++repeatCount;
        }
        return actions;
    }

    private Program getProgram(ActionContext context) {
        if (context instanceof ProgramActionContext) {
            return ((ProgramActionContext)context).getProgram();
        }
        return this.plugin.getCurrentProgram();
    }

    private void removeTransactionListener(Program program) {
        if (program != null) {
            program.removeTransactionListener(this.transactionListener);
        }
    }

    private void addTransactionListener(Program program) {
        if (program != null) {
            program.addTransactionListener(this.transactionListener);
        }
    }

    private void updateAction() {
        this.updateActionNameAndDescription();
        this.setEnabled(this.canPerformAction(this.activeProgram));
    }

    private void updateActionNameAndDescription() {
        String actionName;
        String description = actionName = this.getName();
        Object menuName = actionName;
        if (this.activeProgram != null) {
            menuName = actionName + " " + this.activeProgram.getDomainFile().getName();
            description = actionName;
        }
        if (this.canPerformAction(this.activeProgram)) {
            String programName = this.activeProgram.getDomainFile().getName();
            String undoRedoDescription = this.getUndoRedoDescription(this.activeProgram);
            String text = actionName + " " + HTMLUtilities.escapeHTML((String)(undoRedoDescription + " (" + programName + ")"));
            description = HTMLUtilities.toWrappedHTML((String)text);
        }
        this.getMenuBarData().setMenuItemNamePlain((String)menuName);
        this.setDescription(description);
    }

    private void saveCurrentLocationToHistory() {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (goToService != null && historyService != null) {
            historyService.addNewLocation(goToService.getDefaultNavigatable());
        }
    }

    private class ContextProgramTransactionListener
    implements TransactionListener {
        private ContextProgramTransactionListener() {
        }

        public void transactionStarted(DomainObjectAdapterDB domainObj, TransactionInfo tx) {
        }

        public void transactionEnded(DomainObjectAdapterDB domainObj) {
        }

        public void undoStackChanged(DomainObjectAdapterDB domainObj) {
            AbstractUndoRedoAction.this.updateAction();
        }

        public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
        }
    }

    private class RepeatedAction
    extends DockingAction {
        private int repeatCount;

        public RepeatedAction(String name, int repeatCount) {
            super(name, AbstractUndoRedoAction.this.getOwner());
            this.repeatCount = repeatCount;
            this.setHelpLocation(AbstractUndoRedoAction.this.helpLocation);
            this.setMenuBarData(new MenuData(new String[]{name}));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            AbstractUndoRedoAction.this.executeAction(context, this.repeatCount);
        }
    }
}

