/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileItemInputIteratorImpl;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.apache.commons.fileupload2.core.ProgressListener;
import org.apache.commons.fileupload2.core.RequestContext;
import org.apache.commons.io.IOUtils;

public abstract class AbstractFileUpload<R, I extends FileItem<I>, F extends FileItemFactory<I>> {
    private static final String BOUNDARY_KEY = "boundary";
    private static final String NAME_KEY = "name";
    private static final String FILENAME_KEY = "filename";
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private long fileCountMax = -1L;
    private Charset headerCharset;
    private ProgressListener progressListener = ProgressListener.NOP;
    private F fileItemFactory;

    public static final boolean isMultipartContent(RequestContext ctx) {
        String contentType = ctx.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public byte[] getBoundary(String contentType) {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = params.get(BOUNDARY_KEY);
        return boundaryStr != null ? boundaryStr.getBytes(StandardCharsets.ISO_8859_1) : null;
    }

    public String getFieldName(FileItemHeaders headers) {
        return this.getFieldName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String contentDisposition) {
        String fieldName = null;
        if (contentDisposition != null && contentDisposition.toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            fieldName = params.get(NAME_KEY);
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    public F getFileItemFactory() {
        return this.fileItemFactory;
    }

    public String getFileName(FileItemHeaders headers) {
        return this.getFileName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String contentDisposition) {
        String cdl;
        String fileName = null;
        if (contentDisposition != null && ((cdl = contentDisposition.toLowerCase(Locale.ENGLISH)).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(contentDisposition, ';');
            if (params.containsKey(FILENAME_KEY)) {
                fileName = params.get(FILENAME_KEY);
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public Charset getHeaderCharset() {
        return this.headerCharset;
    }

    public abstract FileItemInputIterator getItemIterator(R var1) throws FileUploadException, IOException;

    public FileItemInputIterator getItemIterator(RequestContext requestContext) throws FileUploadException, IOException {
        return new FileItemInputIteratorImpl(this, requestContext);
    }

    public FileItemHeaders getParsedHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        FileItemHeaders headers = this.newFileItemHeaders();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            StringBuilder header = new StringBuilder(headerPart.substring(start, end));
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header.append(' ').append(headerPart, nonWs, end);
                start = end + 2;
            }
            this.parseHeaderLine(headers, header.toString());
        }
        return headers;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    protected FileItemHeaders newFileItemHeaders() {
        return FileItemFactory.AbstractFileItemBuilder.newFileItemHeaders();
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(FileItemHeaders headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim();
        String headerValue = header.substring(colonOffset + 1).trim();
        headers.addHeader(headerName, headerValue);
    }

    public abstract Map<String, List<I>> parseParameterMap(R var1) throws FileUploadException;

    public Map<String, List<I>> parseParameterMap(RequestContext ctx) throws FileUploadException {
        List<I> items = this.parseRequest(ctx);
        HashMap<String, List<I>> itemsMap = new HashMap<String, List<I>>(items.size());
        for (FileItem fileItem : items) {
            String fieldName = fileItem.getFieldName();
            List mappedItems = itemsMap.computeIfAbsent(fieldName, k -> new ArrayList());
            mappedItems.add(fileItem);
        }
        return itemsMap;
    }

    public abstract List<I> parseRequest(R var1) throws FileUploadException;

    public List<I> parseRequest(RequestContext requestContext) throws FileUploadException {
        ArrayList itemList = new ArrayList();
        boolean successful = false;
        try {
            FileItemFactory fileItemFactory = (FileItemFactory)Objects.requireNonNull(this.getFileItemFactory(), "No FileItemFactory has been set.");
            byte[] buffer = new byte[8192];
            this.getItemIterator(requestContext).forEachRemaining(fileItemInput -> {
                if ((long)itemList.size() == this.fileCountMax) {
                    throw new FileUploadFileCountLimitException(ATTACHMENT, this.getFileCountMax(), itemList.size());
                }
                FileItem fileItem = (FileItem)((FileItemFactory.AbstractFileItemBuilder)((FileItemFactory.AbstractFileItemBuilder)((FileItemFactory.AbstractFileItemBuilder)((FileItemFactory.AbstractFileItemBuilder)fileItemFactory.fileItemBuilder().setFieldName(fileItemInput.getFieldName())).setContentType(fileItemInput.getContentType())).setFormField(fileItemInput.isFormField())).setFileName(fileItemInput.getName())).setFileItemHeaders(fileItemInput.getHeaders()).get();
                itemList.add(fileItem);
                try (InputStream inputStream = fileItemInput.getInputStream();
                     OutputStream outputStream = fileItem.getOutputStream();){
                    IOUtils.copyLarge(inputStream, outputStream, buffer);
                }
                catch (FileUploadException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new FileUploadException(String.format("Processing of %s request failed. %s", MULTIPART_FORM_DATA, e.getMessage()), e);
                }
            });
            successful = true;
            ArrayList arrayList = itemList;
            return arrayList;
        }
        catch (FileUploadException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileUploadException(e.getMessage(), e);
        }
        finally {
            if (!successful) {
                for (FileItem fileItem : itemList) {
                    try {
                        fileItem.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void setFileCountMax(long fileCountMax) {
        this.fileCountMax = fileCountMax;
    }

    public void setFileItemFactory(F factory) {
        this.fileItemFactory = factory;
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public void setHeaderCharset(Charset headerCharset) {
        this.headerCharset = headerCharset;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener != null ? progressListener : ProgressListener.NOP;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }
}

