/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.trans.XPathException;

public class NoOpenStartTagException
extends XPathException {
    public static NoOpenStartTagException makeNoOpenStartTagException(int nodeKind, String name, int hostLanguage, boolean parentIsDocument, boolean isSerializing) {
        String errorCode;
        String message;
        String kind;
        if (parentIsDocument) {
            if (isSerializing) {
                String article;
                kind = nodeKind == 2 ? "attribute" : "namespace";
                String string = article = nodeKind == 2 ? "an " : "a ";
                if (hostLanguage == 50) {
                    message = "Cannot have " + article + kind + " node (" + name + ") whose parent is a document node";
                    errorCode = "XTDE0420";
                } else {
                    message = "Cannot serialize a free-standing " + kind + " node (" + name + ')';
                    errorCode = "SENR0001";
                }
            } else {
                kind = nodeKind == 2 ? "an attribute" : "a namespace";
                message = "Cannot create " + kind + " node (" + name + ") whose parent is a document node";
                errorCode = hostLanguage == 50 ? "XTDE0420" : "XPTY0004";
            }
        } else {
            kind = nodeKind == 2 ? "An attribute" : "A namespace";
            message = kind + " node (" + name + ") cannot be created after the children of the containing element";
            errorCode = hostLanguage == 50 ? "XTDE0410" : "XQTY0024";
        }
        NoOpenStartTagException err = new NoOpenStartTagException(message);
        err.setErrorCode(errorCode);
        return err;
    }

    public NoOpenStartTagException(String message) {
        super(message);
    }
}

