/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.regex;

import java.util.HashMap;
import java.util.Map;

public class RegularExpressions {
    private static final Map<String, String> LONGFORM_CHARACTER_PROPERTIES = new HashMap<String, String>();

    private RegularExpressions() {
    }

    public static String replaceDollarAnchors(String regex) {
        if (regex.indexOf(36) == -1) {
            return regex;
        }
        StringBuilder result = new StringBuilder();
        boolean inCharacterClass = false;
        boolean inLiteralSection = false;
        for (int i = 0; i < regex.length(); ++i) {
            char ch = regex.charAt(i);
            if (inLiteralSection) {
                if (ch == '\\' && i + 1 < regex.length() && regex.charAt(i + 1) == 'E') {
                    result.append("\\E");
                    inLiteralSection = false;
                    ++i;
                    continue;
                }
                result.append(ch);
                continue;
            }
            if (ch == '\\') {
                result.append(ch);
                if (i + 1 >= regex.length()) continue;
                char escapedChar = regex.charAt(i + 1);
                result.append(escapedChar);
                if (escapedChar == 'Q') {
                    inLiteralSection = true;
                }
                ++i;
                continue;
            }
            if (ch == '[') {
                inCharacterClass = true;
                result.append(ch);
                continue;
            }
            if (ch == ']') {
                inCharacterClass = false;
                result.append(ch);
                continue;
            }
            if (ch == '$') {
                if (inCharacterClass) {
                    result.append(ch);
                    continue;
                }
                result.append("\\z");
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String replaceLongformCharacterProperties(String regex) {
        return RegularExpressions.replaceCharacterProperties(regex, LONGFORM_CHARACTER_PROPERTIES);
    }

    public static String replaceCharacterProperties(String regex, Map<String, String> replacements) {
        if (regex.indexOf("\\p{") == -1) {
            return regex;
        }
        StringBuilder result = new StringBuilder();
        boolean inCharacterClass = false;
        boolean inLiteralSection = false;
        for (int i = 0; i < regex.length(); ++i) {
            int end;
            char ch = regex.charAt(i);
            if (inLiteralSection) {
                if (ch == '\\' && i + 1 < regex.length() && regex.charAt(i + 1) == 'E') {
                    result.append("\\E");
                    inLiteralSection = false;
                    ++i;
                    continue;
                }
                result.append(ch);
                continue;
            }
            if (!inCharacterClass && regex.length() >= i + 3 && regex.startsWith("\\p{", i) && (end = RegularExpressions.findClosingBrace(regex, i + 3)) != -1) {
                result.append("\\p{");
                String characterClass = regex.substring(i + 3, end);
                String replacement = replacements.get(characterClass);
                if (replacement == null) {
                    result.append(characterClass);
                } else {
                    result.append(replacement);
                }
                result.append("}");
                i = end;
                continue;
            }
            if (ch == '\\') {
                result.append(ch);
                if (i + 1 >= regex.length()) continue;
                char escapedChar = regex.charAt(i + 1);
                result.append(escapedChar);
                if (escapedChar == 'Q') {
                    inLiteralSection = true;
                }
                ++i;
                continue;
            }
            if (ch == '[') {
                inCharacterClass = true;
                result.append(ch);
                continue;
            }
            if (ch == ']') {
                inCharacterClass = false;
                result.append(ch);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    private static int findClosingBrace(String regex, int start) {
        for (int i = start; i < regex.length(); ++i) {
            if (regex.charAt(i) == '}') {
                return i;
            }
            if (regex.charAt(i) != '\\' || i + 1 >= regex.length()) continue;
            ++i;
        }
        return -1;
    }

    static {
        LONGFORM_CHARACTER_PROPERTIES.put("Letter", "L");
        LONGFORM_CHARACTER_PROPERTIES.put("Lowercase_Letter", "Ll");
        LONGFORM_CHARACTER_PROPERTIES.put("Uppercase_Letter", "Lu");
        LONGFORM_CHARACTER_PROPERTIES.put("Titlecase_Letter", "Lt");
        LONGFORM_CHARACTER_PROPERTIES.put("Cased_Letter", "L&");
        LONGFORM_CHARACTER_PROPERTIES.put("Modifier_Letter", "Lm");
        LONGFORM_CHARACTER_PROPERTIES.put("Other_Letter", "Lo");
        LONGFORM_CHARACTER_PROPERTIES.put("Mark", "M");
        LONGFORM_CHARACTER_PROPERTIES.put("Non_Spacing_Mark", "Mn");
        LONGFORM_CHARACTER_PROPERTIES.put("Spacing_Combining_Mark", "Mc");
        LONGFORM_CHARACTER_PROPERTIES.put("Enclosing_Mark", "Me");
        LONGFORM_CHARACTER_PROPERTIES.put("Separator", "Z");
        LONGFORM_CHARACTER_PROPERTIES.put("Space_Separator", "Zs");
        LONGFORM_CHARACTER_PROPERTIES.put("Line_Separator", "Zl");
        LONGFORM_CHARACTER_PROPERTIES.put("Paragraph_Separator", "Zp");
        LONGFORM_CHARACTER_PROPERTIES.put("Symbol", "S");
        LONGFORM_CHARACTER_PROPERTIES.put("Math_Symbol", "Sm");
        LONGFORM_CHARACTER_PROPERTIES.put("Currency_Symbol", "Sc");
        LONGFORM_CHARACTER_PROPERTIES.put("Modifier_Symbol", "Sk");
        LONGFORM_CHARACTER_PROPERTIES.put("Other_Symbol", "So");
        LONGFORM_CHARACTER_PROPERTIES.put("Number", "N");
        LONGFORM_CHARACTER_PROPERTIES.put("Decimal_Digit_Number", "Nd");
        LONGFORM_CHARACTER_PROPERTIES.put("Letter_Number", "Nl");
        LONGFORM_CHARACTER_PROPERTIES.put("Other_Number", "No");
        LONGFORM_CHARACTER_PROPERTIES.put("Punctuation", "P");
        LONGFORM_CHARACTER_PROPERTIES.put("Dash_Punctuation", "Pd");
        LONGFORM_CHARACTER_PROPERTIES.put("Open_Punctuation", "Ps");
        LONGFORM_CHARACTER_PROPERTIES.put("Close_Punctuation", "Pe");
        LONGFORM_CHARACTER_PROPERTIES.put("Initial_Punctuation", "Pi");
        LONGFORM_CHARACTER_PROPERTIES.put("Final_Punctuation", "Pf");
        LONGFORM_CHARACTER_PROPERTIES.put("Connector_Punctuation", "Pc");
        LONGFORM_CHARACTER_PROPERTIES.put("Other_Punctuation", "Po");
        LONGFORM_CHARACTER_PROPERTIES.put("Other", "C");
        LONGFORM_CHARACTER_PROPERTIES.put("Control", "Cc");
        LONGFORM_CHARACTER_PROPERTIES.put("Format", "Cf");
        LONGFORM_CHARACTER_PROPERTIES.put("Private_Use", "Co");
        LONGFORM_CHARACTER_PROPERTIES.put("Surrogate", "Cs");
        LONGFORM_CHARACTER_PROPERTIES.put("Unassigned", "Cn");
        LONGFORM_CHARACTER_PROPERTIES.put("digit", "Nd");
    }
}

