/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerStatus<T extends EventListener> {
    public static final boolean SYNCHRONOUS = true;
    public static final boolean ASYNCHRONOUS = false;
    private final T _listener;
    private final boolean _synch;

    public ListenerStatus(T listener, boolean synch) {
        this._listener = listener;
        this._synch = synch;
    }

    public T getListener() {
        return this._listener;
    }

    public boolean isSynchronous() {
        return this._synch;
    }

    public int hashCode() {
        return this.getListener().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ListenerStatus && this.getListener().equals(((ListenerStatus)obj).getListener());
    }

    public String toString() {
        return "[Status for " + this.getListener().toString() + "]";
    }

    public static class ServiceTypeListenerStatus
    extends ListenerStatus<ServiceTypeListener> {
        private static Logger logger = LoggerFactory.getLogger(ServiceTypeListenerStatus.class);
        private final ConcurrentMap<String, String> _addedTypes = new ConcurrentHashMap<String, String>(32);

        public ServiceTypeListenerStatus(ServiceTypeListener listener, boolean synch) {
            super(listener, synch);
        }

        void serviceTypeAdded(ServiceEvent event) {
            if (null == this._addedTypes.putIfAbsent(event.getType(), event.getType())) {
                ((ServiceTypeListener)this.getListener()).serviceTypeAdded(event);
            } else {
                logger.trace("Service Type Added called for a service type already added: {}", (Object)event);
            }
        }

        void subTypeForServiceTypeAdded(ServiceEvent event) {
            if (null == this._addedTypes.putIfAbsent(event.getType(), event.getType())) {
                ((ServiceTypeListener)this.getListener()).subTypeForServiceTypeAdded(event);
            } else {
                logger.trace("Service Sub Type Added called for a service sub type already added: {}", (Object)event);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(2048);
            sb.append("[Status for ");
            sb.append(((ServiceTypeListener)this.getListener()).toString());
            if (this._addedTypes.isEmpty()) {
                sb.append(" no type event ");
            } else {
                sb.append(" (");
                for (String type : this._addedTypes.keySet()) {
                    sb.append(type + ", ");
                }
                sb.append(") ");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static class ServiceListenerStatus
    extends ListenerStatus<ServiceListener> {
        private static Logger logger = LoggerFactory.getLogger(ServiceListenerStatus.class);
        private final ConcurrentMap<String, ServiceInfo> _addedServices = new ConcurrentHashMap<String, ServiceInfo>(32);

        public ServiceListenerStatus(ServiceListener listener, boolean synch) {
            super(listener, synch);
        }

        void serviceAdded(ServiceEvent event) {
            String qualifiedName = event.getName() + "." + event.getType();
            if (null == this._addedServices.putIfAbsent(qualifiedName, event.getInfo().clone())) {
                ((ServiceListener)this.getListener()).serviceAdded(event);
                ServiceInfo info = event.getInfo();
                if (info != null && info.hasData()) {
                    ((ServiceListener)this.getListener()).serviceResolved(event);
                }
            } else {
                logger.debug("Service Added called for a service already added: {}", (Object)event);
            }
        }

        void serviceRemoved(ServiceEvent event) {
            String qualifiedName = event.getName() + "." + event.getType();
            if (this._addedServices.remove(qualifiedName, this._addedServices.get(qualifiedName))) {
                ((ServiceListener)this.getListener()).serviceRemoved(event);
            } else {
                logger.debug("Service Removed called for a service already removed: {}", (Object)event);
            }
        }

        synchronized void serviceResolved(ServiceEvent event) {
            ServiceInfo info = event.getInfo();
            if (info != null && info.hasData()) {
                String qualifiedName = event.getName() + "." + event.getType();
                ServiceInfo previousServiceInfo = (ServiceInfo)this._addedServices.get(qualifiedName);
                if (!ServiceListenerStatus._sameInfo(info, previousServiceInfo)) {
                    if (null == previousServiceInfo) {
                        if (null == this._addedServices.putIfAbsent(qualifiedName, info.clone())) {
                            ((ServiceListener)this.getListener()).serviceResolved(event);
                        }
                    } else if (this._addedServices.replace(qualifiedName, previousServiceInfo, info.clone())) {
                        ((ServiceListener)this.getListener()).serviceResolved(event);
                    }
                } else {
                    logger.debug("Service Resolved called for a service already resolved: {}", (Object)event);
                }
            } else {
                logger.warn("Service Resolved called for an unresolved event: {}", (Object)event);
            }
        }

        private static final boolean _sameInfo(ServiceInfo info, ServiceInfo lastInfo) {
            byte[] lastText;
            if (info == null) {
                return false;
            }
            if (lastInfo == null) {
                return false;
            }
            if (!info.equals(lastInfo)) {
                return false;
            }
            byte[] text = info.getTextBytes();
            if (text.length != (lastText = lastInfo.getTextBytes()).length) {
                return false;
            }
            for (int i = 0; i < text.length; ++i) {
                if (text[i] == lastText[i]) continue;
                return false;
            }
            return info.hasSameAddresses(lastInfo);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(2048);
            sb.append("[Status for ");
            sb.append(((ServiceListener)this.getListener()).toString());
            if (this._addedServices.isEmpty()) {
                sb.append(" no type event ");
            } else {
                sb.append(" (");
                for (String service : this._addedServices.keySet()) {
                    sb.append(service + ", ");
                }
                sb.append(") ");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

