/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jupnp.binding.LocalServiceBindingException;
import org.jupnp.binding.annotations.AnnotationLocalServiceBinder;
import org.jupnp.binding.annotations.UpnpAction;
import org.jupnp.binding.annotations.UpnpInputArgument;
import org.jupnp.binding.annotations.UpnpOutputArgument;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.action.MethodActionExecutor;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.state.GetterStateVariableAccessor;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationActionBinder {
    private final Logger logger = LoggerFactory.getLogger(AnnotationLocalServiceBinder.class);
    protected UpnpAction annotation;
    protected Method method;
    protected Map<StateVariable, StateVariableAccessor> stateVariables;
    protected Set<Class> stringConvertibleTypes;

    public AnnotationActionBinder(Method method, Map<StateVariable, StateVariableAccessor> stateVariables, Set<Class> stringConvertibleTypes) {
        this.annotation = method.getAnnotation(UpnpAction.class);
        this.stateVariables = stateVariables;
        this.method = method;
        this.stringConvertibleTypes = stringConvertibleTypes;
    }

    public UpnpAction getAnnotation() {
        return this.annotation;
    }

    public Map<StateVariable, StateVariableAccessor> getStateVariables() {
        return this.stateVariables;
    }

    public Method getMethod() {
        return this.method;
    }

    public Set<Class> getStringConvertibleTypes() {
        return this.stringConvertibleTypes;
    }

    public Action appendAction(Map<Action, ActionExecutor> actions) throws LocalServiceBindingException {
        String name = !this.getAnnotation().name().isEmpty() ? this.getAnnotation().name() : AnnotationLocalServiceBinder.toUpnpActionName(this.getMethod().getName());
        this.logger.trace("Creating action and executor: {}", (Object)name);
        List<ActionArgument> inputArguments = this.createInputArguments();
        Map<ActionArgument<LocalService>, StateVariableAccessor> outputArguments = this.createOutputArguments();
        inputArguments.addAll(outputArguments.keySet());
        ActionArgument[] actionArguments = inputArguments.toArray(new ActionArgument[inputArguments.size()]);
        Action action = new Action(name, actionArguments);
        ActionExecutor executor = this.createExecutor(outputArguments);
        actions.put(action, executor);
        return action;
    }

    protected ActionExecutor createExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArguments) {
        return new MethodActionExecutor(outputArguments, this.getMethod());
    }

    protected List<ActionArgument> createInputArguments() throws LocalServiceBindingException {
        ArrayList<ActionArgument> list = new ArrayList<ActionArgument>();
        int annotatedParams = 0;
        Annotation[][] params = this.getMethod().getParameterAnnotations();
        int i = 0;
        while (i < params.length) {
            Annotation[] param;
            Annotation[] annotationArray = param = params[i];
            int n = param.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation paramAnnotation = annotationArray[n2];
                if (paramAnnotation instanceof UpnpInputArgument) {
                    UpnpInputArgument inputArgumentAnnotation = (UpnpInputArgument)paramAnnotation;
                    ++annotatedParams;
                    String argumentName = inputArgumentAnnotation.name();
                    StateVariable stateVariable = this.findRelatedStateVariable(inputArgumentAnnotation.stateVariable(), argumentName, this.getMethod().getName());
                    if (stateVariable == null) {
                        throw new LocalServiceBindingException("Could not detected related state variable of argument: " + argumentName);
                    }
                    this.validateType(stateVariable, this.getMethod().getParameterTypes()[i]);
                    ActionArgument inputArgument = new ActionArgument(argumentName, inputArgumentAnnotation.aliases(), stateVariable.getName(), ActionArgument.Direction.IN);
                    list.add(inputArgument);
                }
                ++n2;
            }
            ++i;
        }
        if (annotatedParams < this.getMethod().getParameterTypes().length && !RemoteClientInfo.class.isAssignableFrom(this.method.getParameterTypes()[this.method.getParameterTypes().length - 1])) {
            throw new LocalServiceBindingException("Method has parameters that are not input arguments: " + this.getMethod().getName());
        }
        return list;
    }

    protected Map<ActionArgument<LocalService>, StateVariableAccessor> createOutputArguments() throws LocalServiceBindingException {
        LinkedHashMap<ActionArgument<LocalService>, StateVariableAccessor> map = new LinkedHashMap<ActionArgument<LocalService>, StateVariableAccessor>();
        UpnpAction actionAnnotation = this.getMethod().getAnnotation(UpnpAction.class);
        if (actionAnnotation.out().length == 0) {
            return map;
        }
        boolean hasMultipleOutputArguments = actionAnnotation.out().length > 1;
        UpnpOutputArgument[] upnpOutputArgumentArray = actionAnnotation.out();
        int n = upnpOutputArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            UpnpOutputArgument outputArgumentAnnotation = upnpOutputArgumentArray[n2];
            String argumentName = outputArgumentAnnotation.name();
            StateVariable stateVariable = this.findRelatedStateVariable(outputArgumentAnnotation.stateVariable(), argumentName, this.getMethod().getName());
            if (stateVariable == null && !outputArgumentAnnotation.getterName().isEmpty()) {
                stateVariable = this.findRelatedStateVariable(null, null, outputArgumentAnnotation.getterName());
            }
            if (stateVariable == null) {
                throw new LocalServiceBindingException("Related state variable not found for output argument: " + argumentName);
            }
            StateVariableAccessor accessor = this.findOutputArgumentAccessor(stateVariable, outputArgumentAnnotation.getterName(), hasMultipleOutputArguments);
            this.logger.trace("Found related state variable for output argument '{}': {}", (Object)argumentName, (Object)stateVariable);
            ActionArgument outputArgument = new ActionArgument(argumentName, stateVariable.getName(), ActionArgument.Direction.OUT, !hasMultipleOutputArguments);
            map.put(outputArgument, accessor);
            ++n2;
        }
        return map;
    }

    protected StateVariableAccessor findOutputArgumentAccessor(StateVariable stateVariable, String getterName, boolean multipleArguments) throws LocalServiceBindingException {
        boolean isVoid = this.getMethod().getReturnType().equals(Void.TYPE);
        if (isVoid) {
            if (getterName != null && !getterName.isEmpty()) {
                this.logger.trace("Action method is void, will use getter method named: {}", (Object)getterName);
                Method getter = Reflections.getMethod(this.getMethod().getDeclaringClass(), getterName);
                if (getter == null) {
                    throw new LocalServiceBindingException("Declared getter method '" + getterName + "' not found on: " + String.valueOf(this.getMethod().getDeclaringClass()));
                }
                this.validateType(stateVariable, getter.getReturnType());
                return new GetterStateVariableAccessor(getter);
            }
            this.logger.trace("Action method is void, trying to find existing accessor of related: {}", (Object)stateVariable);
            return this.getStateVariables().get(stateVariable);
        }
        if (getterName != null && !getterName.isEmpty()) {
            this.logger.trace("Action method is not void, will use getter method on returned instance: {}", (Object)getterName);
            Method getter = Reflections.getMethod(this.getMethod().getReturnType(), getterName);
            if (getter == null) {
                throw new LocalServiceBindingException("Declared getter method '" + getterName + "' not found on return type: " + String.valueOf(this.getMethod().getReturnType()));
            }
            this.validateType(stateVariable, getter.getReturnType());
            return new GetterStateVariableAccessor(getter);
        }
        if (!multipleArguments) {
            this.logger.trace("Action method is not void, will use the returned instance: {}", this.getMethod().getReturnType());
            this.validateType(stateVariable, this.getMethod().getReturnType());
        }
        return null;
    }

    protected StateVariable findRelatedStateVariable(String declaredName, String argumentName, String methodName) throws LocalServiceBindingException {
        String methodPropertyName;
        Object actualName;
        StateVariable relatedStateVariable = null;
        if (declaredName != null && !declaredName.isEmpty()) {
            relatedStateVariable = this.getStateVariable(declaredName);
        }
        if (relatedStateVariable == null && argumentName != null && !argumentName.isEmpty()) {
            actualName = AnnotationLocalServiceBinder.toUpnpStateVariableName(argumentName);
            this.logger.trace("Finding related state variable with argument name (converted to UPnP name): {}", actualName);
            relatedStateVariable = this.getStateVariable(argumentName);
        }
        if (relatedStateVariable == null && argumentName != null && !argumentName.isEmpty()) {
            actualName = AnnotationLocalServiceBinder.toUpnpStateVariableName(argumentName);
            actualName = "A_ARG_TYPE_" + (String)actualName;
            this.logger.trace("Finding related state variable with prefixed argument name (converted to UPnP name): {}", actualName);
            relatedStateVariable = this.getStateVariable((String)actualName);
        }
        if (relatedStateVariable == null && methodName != null && !methodName.isEmpty() && (methodPropertyName = Reflections.getMethodPropertyName(methodName)) != null) {
            this.logger.trace("Finding related state variable with method property name: {}", (Object)methodPropertyName);
            relatedStateVariable = this.getStateVariable(AnnotationLocalServiceBinder.toUpnpStateVariableName(methodPropertyName));
        }
        return relatedStateVariable;
    }

    protected void validateType(StateVariable stateVariable, Class type) throws LocalServiceBindingException {
        Datatype.Default expectedDefaultMapping = ModelUtil.isStringConvertibleType(this.getStringConvertibleTypes(), type) ? Datatype.Default.STRING : Datatype.Default.getByJavaType(type);
        this.logger.trace("Expecting '{}' to match default mapping: {}", (Object)stateVariable, (Object)expectedDefaultMapping);
        if (expectedDefaultMapping != null && !stateVariable.getTypeDetails().getDatatype().isHandlingJavaType(expectedDefaultMapping.getJavaType())) {
            throw new LocalServiceBindingException("State variable '" + String.valueOf(stateVariable) + "' datatype can't handle action argument's Java type (change one): " + String.valueOf(expectedDefaultMapping.getJavaType()));
        }
        if (expectedDefaultMapping == null && stateVariable.getTypeDetails().getDatatype().getBuiltin() != null) {
            throw new LocalServiceBindingException("State variable '" + String.valueOf(stateVariable) + "' should be custom datatype (action argument type is unknown Java type): " + type.getSimpleName());
        }
        this.logger.trace("State variable matches required argument datatype (or can't be validated because it is custom)");
    }

    protected StateVariable getStateVariable(String name) {
        for (StateVariable stateVariable : this.getStateVariables().keySet()) {
            if (!stateVariable.getName().equals(name)) continue;
            return stateVariable;
        }
        return null;
    }
}

