/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.items.DimmerItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.IncreaseDecreaseType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class ColorItem
extends DimmerItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(HSBType.class, PercentType.class, OnOffType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(HSBType.class, PercentType.class, OnOffType.class, IncreaseDecreaseType.class, RefreshType.class);

    public ColorItem(String name) {
        super("Color", name);
    }

    public void send(HSBType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void setState(State state) {
        if (!this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            this.logSetTypeError(state);
            return;
        }
        State currentState = this.state;
        State state2 = currentState;
        if (state2 instanceof HSBType) {
            State state3;
            void hsbType;
            HSBType hSBType = (HSBType)state2;
            HSBType cfr_ignored_0 = (HSBType)state2;
            DecimalType hue = hsbType.getHue();
            PercentType saturation = hsbType.getSaturation();
            if (state == OnOffType.OFF) {
                this.applyState(new HSBType(hue, saturation, PercentType.ZERO));
                return;
            }
            if (state == OnOffType.ON) {
                this.applyState(new HSBType(hue, saturation, PercentType.HUNDRED));
                return;
            }
            State state4 = state;
            if (state4 instanceof PercentType) {
                PercentType percentType = (PercentType)state4;
                PercentType cfr_ignored_1 = (PercentType)state4;
                if (!(state instanceof HSBType)) {
                    void percentType2;
                    this.applyState(new HSBType(hue, saturation, (PercentType)percentType2));
                    return;
                }
            }
            if ((state3 = state) instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)state3;
                DecimalType cfr_ignored_2 = (DecimalType)state3;
                if (!(state instanceof HSBType)) {
                    void decimalType2;
                    this.applyState(new HSBType(hue, saturation, new PercentType(decimalType2.toBigDecimal().multiply(BigDecimal.valueOf(100L)))));
                    return;
                }
            }
            this.applyState(state);
            return;
        }
        HSBType convertedState = state.as(HSBType.class);
        if (convertedState != null) {
            this.applyState(convertedState);
            return;
        }
        this.applyState(state);
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof HSBType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

