/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiFace")
public class AIFace
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNUMINDICES;
    public static final int MINDICES;

    public AIFace(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIFace.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mNumIndices() {
        return AIFace.nmNumIndices(this.address());
    }

    @NativeType(value="unsigned int *")
    public IntBuffer mIndices() {
        return AIFace.nmIndices(this.address());
    }

    public AIFace mIndices(@NativeType(value="unsigned int *") IntBuffer value) {
        AIFace.nmIndices(this.address(), value);
        return this;
    }

    public AIFace set(AIFace src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIFace malloc() {
        return (AIFace)AIFace.wrap(AIFace.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIFace calloc() {
        return (AIFace)AIFace.wrap(AIFace.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIFace create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIFace)AIFace.wrap(AIFace.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIFace create(long address) {
        return (AIFace)AIFace.wrap(AIFace.class, (long)address);
    }

    @Nullable
    public static AIFace createSafe(long address) {
        return address == 0L ? null : (AIFace)AIFace.wrap(AIFace.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIFace.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIFace.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIFace.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIFace.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIFace.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIFace.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIFace.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static AIFace mallocStack() {
        return AIFace.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFace callocStack() {
        return AIFace.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFace mallocStack(MemoryStack stack) {
        return AIFace.malloc(stack);
    }

    @Deprecated
    public static AIFace callocStack(MemoryStack stack) {
        return AIFace.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIFace.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIFace.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFace.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFace.calloc(capacity, stack);
    }

    public static AIFace malloc(MemoryStack stack) {
        return (AIFace)AIFace.wrap(AIFace.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIFace calloc(MemoryStack stack) {
        return (AIFace)AIFace.wrap(AIFace.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)AIFace.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)AIFace.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmNumIndices(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMINDICES);
    }

    public static IntBuffer nmIndices(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MINDICES)), (int)AIFace.nmNumIndices(struct));
    }

    public static void nmNumIndices(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMINDICES, value);
    }

    public static void nmIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MINDICES), (long)MemoryUtil.memAddress((IntBuffer)value));
        AIFace.nmNumIndices(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MINDICES)));
    }

    static {
        Struct.Layout layout = AIFace.__struct((Struct.Member[])new Struct.Member[]{AIFace.__member((int)4), AIFace.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNUMINDICES = layout.offsetof(0);
        MINDICES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIFace, Buffer>
    implements NativeResource {
        private static final AIFace ELEMENT_FACTORY = AIFace.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIFace getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mNumIndices() {
            return AIFace.nmNumIndices(this.address());
        }

        @NativeType(value="unsigned int *")
        public IntBuffer mIndices() {
            return AIFace.nmIndices(this.address());
        }

        public Buffer mIndices(@NativeType(value="unsigned int *") IntBuffer value) {
            AIFace.nmIndices(this.address(), value);
            return this;
        }
    }
}

