/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.kubernetes;

import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractJWTClientValidator;
import org.keycloak.authentication.authenticators.client.FederatedJWTClientValidator;
import org.keycloak.broker.kubernetes.KubernetesIdentityProviderConfig;
import org.keycloak.broker.kubernetes.KubernetesJwksEndpointLoader;
import org.keycloak.broker.provider.ClientAssertionIdentityProvider;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.models.KeycloakSession;

public class KubernetesIdentityProvider
implements ClientAssertionIdentityProvider<KubernetesIdentityProviderConfig> {
    private static final Logger LOGGER = Logger.getLogger(KubernetesIdentityProvider.class);
    private final KeycloakSession session;
    private final KubernetesIdentityProviderConfig config;

    public KubernetesIdentityProvider(KeycloakSession session, KubernetesIdentityProviderConfig config) {
        this.session = session;
        this.config = config;
    }

    public boolean verifyClientAssertion(ClientAuthenticationFlowContext context) throws Exception {
        FederatedJWTClientValidator validator = new FederatedJWTClientValidator(context, this::verifySignature, this.config.getIssuer(), this.config.getAllowedClockSkew(), true);
        validator.setMaximumExpirationTime(3600);
        return validator.validate();
    }

    private boolean verifySignature(AbstractJWTClientValidator validator) {
        try {
            JWSInput jws = validator.getState().getJws();
            JWSHeader header = jws.getHeader();
            String kid = header.getKeyId();
            String alg = header.getRawAlgorithm();
            String modelKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)validator.getContext().getRealm().getId(), (String)this.config.getInternalId());
            PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)this.session.getProvider(PublicKeyStorageProvider.class);
            KeyWrapper publicKey = keyStorage.getPublicKey(modelKey, kid, alg, (PublicKeyLoader)new KubernetesJwksEndpointLoader(this.session, this.config.getIssuer()));
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, alg);
            if (signatureProvider == null) {
                LOGGER.debugf("Failed to verify token, signature provider not found for algorithm %s", (Object)alg);
                return false;
            }
            return signatureProvider.verifier(publicKey).verify(jws.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jws.getSignature());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Failed to verify token signature", (Throwable)e);
            return false;
        }
    }

    public KubernetesIdentityProviderConfig getConfig() {
        return this.config;
    }

    public void close() {
    }
}

