/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.Objects;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.WorkflowStepProvider;
import org.keycloak.models.workflow.Workflows;

public class WorkflowStep
implements Comparable<WorkflowStep> {
    private KeycloakSession session;
    private String id;
    private final String providerId;
    private MultivaluedHashMap<String, String> config;

    public WorkflowStep(String providerId, MultivaluedHashMap<String, String> config) {
        this.providerId = providerId;
        this.config = config;
    }

    public WorkflowStep(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.id = model.getId();
        this.providerId = model.getProviderId();
        this.config = model.getConfig();
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public WorkflowStep setConfig(String key, String value) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.putSingle((Object)key, (Object)value);
        return this;
    }

    public MultivaluedHashMap<String, String> getConfig() {
        if (this.config == null) {
            return new MultivaluedHashMap();
        }
        return this.config;
    }

    public void setPriority(int priority) {
        this.setConfig("priority", String.valueOf(priority));
    }

    public int getPriority() {
        String value = (String)this.getConfig().getFirst((Object)"priority");
        if (value == null) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return Integer.MAX_VALUE;
        }
    }

    public void setAfter(String after) {
        this.setConfig("after", after);
    }

    public String getAfter() {
        return (String)this.getConfig().getFirst((Object)"after");
    }

    public String getNotificationSubject() {
        WorkflowStepProvider provider;
        if (this.session != null && (provider = Workflows.getStepProvider(this.session, this)) != null) {
            return provider.getNotificationSubject();
        }
        return null;
    }

    public String getNotificationMessage() {
        WorkflowStepProvider provider;
        if (this.session != null && (provider = Workflows.getStepProvider(this.session, this)) != null) {
            return provider.getNotificationMessage();
        }
        return null;
    }

    @Override
    public int compareTo(WorkflowStep other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }

    public boolean equals(Object o) {
        if (!(o instanceof WorkflowStep)) {
            return false;
        }
        WorkflowStep that = (WorkflowStep)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

