/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class StringJavaType
extends AbstractClassJavaType<String> {
    public static final StringJavaType INSTANCE = new StringJavaType();

    public StringJavaType() {
        super(String.class);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(String value) {
        return value;
    }

    @Override
    public String fromString(CharSequence string) {
        return string.toString();
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof String;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators stdIndicators) {
        TypeConfiguration typeConfiguration = stdIndicators.getTypeConfiguration();
        JdbcTypeRegistry stdRegistry = typeConfiguration.getJdbcTypeRegistry();
        if (stdIndicators.isLob()) {
            return stdIndicators.isNationalized() ? stdRegistry.getDescriptor(2011) : stdRegistry.getDescriptor(2005);
        }
        if (stdIndicators.isNationalized()) {
            return stdRegistry.getDescriptor(-9);
        }
        return super.getRecommendedJdbcType(stdIndicators);
    }

    @Override
    public <X> X unwrap(String value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)value.getBytes(StandardCharsets.UTF_8);
        }
        if (Reader.class.isAssignableFrom(type)) {
            return (X)new StringReader(value);
        }
        if (CharacterStream.class.isAssignableFrom(type)) {
            return (X)new CharacterStreamImpl(value);
        }
        if (NClob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createNClob(value);
        }
        if (Clob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createClob(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(Integer.parseInt(value));
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(Long.parseLong(value));
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> String wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            return new String(chars);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            return DataHelper.extractString(reader);
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return DataHelper.extractString(clob);
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "char", "char[]", "java.lang.Character", "java.lang.Character[]" -> true;
            default -> false;
        };
    }

    @Override
    public <X> String coerce(X value, JavaType.CoercionContext coercionContext) {
        return this.wrap((Object)value, (WrapperOptions)null);
    }
}

