/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.Serializable;
import java.util.function.Supplier;

public final class SecretKeys
implements Serializable {
    private static final long serialVersionUID = -3226034787747746735L;
    private static final ThreadLocal<Boolean> LOCKED = new ThreadLocal();

    public static boolean isLocked() {
        Boolean result = LOCKED.get();
        return result == null || result != false;
    }

    public static void doUnlocked(Runnable runnable) {
        SecretKeys.doUnlocked(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T doUnlocked(Supplier<T> supplier) {
        if (SecretKeys.isLocked()) {
            LOCKED.set(false);
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                LOCKED.remove();
            }
        }
        return supplier.get();
    }

    public static void doLocked(Runnable runnable) {
        SecretKeys.doLocked(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T doLocked(Supplier<T> supplier) {
        if (!SecretKeys.isLocked()) {
            LOCKED.set(true);
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                LOCKED.set(false);
            }
        }
        return supplier.get();
    }
}

