/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import org.openstreetmap.josm.tools.Utils;

public final class ColorHelper {
    private ColorHelper() {
    }

    public static Color html2color(String html) {
        if (!html.isEmpty() && html.charAt(0) == '#') {
            html = html.substring(1);
        }
        if (html.length() == 3) {
            html = new String(new char[]{html.charAt(0), html.charAt(0), html.charAt(1), html.charAt(1), html.charAt(2), html.charAt(2)});
        }
        if (html.length() != 6 && html.length() != 8) {
            return null;
        }
        try {
            return new Color(Integer.parseInt(html.substring(0, 2), 16), Integer.parseInt(html.substring(2, 4), 16), Integer.parseInt(html.substring(4, 6), 16), html.length() == 8 ? Integer.parseInt(html.substring(6, 8), 16) : 255);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String color2html(Color col) {
        return ColorHelper.color2html(col, true);
    }

    public static String color2html(Color color, boolean withAlpha) {
        if (color == null) {
            return null;
        }
        int alpha = color.getAlpha();
        return withAlpha && alpha != 255 ? String.format("#%06X%02X", color.getRGB() & 0xFFFFFF, alpha) : String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }

    public static Color getForegroundColor(Color bg) {
        if (bg == null) {
            return null;
        }
        if (ColorHelper.calculateContrastRatio(Color.WHITE, bg) > ColorHelper.calculateContrastRatio(Color.BLACK, bg)) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    public static Integer float2int(Float val) {
        if (val == null) {
            return null;
        }
        if (val.floatValue() < 0.0f || val.floatValue() > 1.0f) {
            return 255;
        }
        return (int)(255.0f * val.floatValue() + 0.5f);
    }

    public static Float int2float(Integer val) {
        if (val == null) {
            return null;
        }
        if (val < 0 || val > 255) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)val.intValue() / 255.0f);
    }

    public static Color alphaMultiply(Color color, float alphaFactor) {
        int alpha = ColorHelper.float2int(Float.valueOf(ColorHelper.int2float(color.getAlpha()).floatValue() * alphaFactor));
        alpha = Utils.clamp(alpha, 0, 255);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color complement(Color clr) {
        return new Color(255 - clr.getRed(), 255 - clr.getGreen(), 255 - clr.getBlue(), clr.getAlpha());
    }

    private static double calculateLuminance(Color color) {
        double rs = (double)color.getRed() / 255.0;
        double gs = (double)color.getGreen() / 255.0;
        double bs = (double)color.getBlue() / 255.0;
        double r = ColorHelper.calculateLuminanceStepFunction(rs);
        double g = ColorHelper.calculateLuminanceStepFunction(gs);
        double b = ColorHelper.calculateLuminanceStepFunction(bs);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private static double calculateLuminanceStepFunction(double color) {
        if (color <= 0.03928) {
            return color / 12.92;
        }
        return Math.pow((color + 0.055) / 1.055, 2.4);
    }

    public static double calculateContrastRatio(Color first, Color second) {
        double fL = ColorHelper.calculateLuminance(first);
        double sL = ColorHelper.calculateLuminance(second);
        return (Math.max(fL, sL) + 0.05) / (Math.min(fL, sL) + 0.05);
    }
}

