/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;

public class PartialEepGet
extends EepGet {
    private final long _fetchSize;

    public PartialEepGet(I2PAppContext ctx, String proxyHost, int proxyPort, OutputStream outputStream, String url, long size) {
        super(ctx, proxyHost != null && proxyPort > 0, proxyHost, proxyPort, 0, size, size, null, outputStream, url, true, null, null);
        this._fetchSize = size;
    }

    public static void main(String[] args) {
        FileOutputStream out;
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        long size = 56L;
        String saveAs = null;
        String username = null;
        String password = null;
        boolean error = false;
        Getopt g = new Getopt("partialeepget", args, "p:cl:o:u:x:");
        try {
            int c;
            block14: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 112: {
                        String s = g.getOptarg();
                        int colon = s.indexOf(58);
                        if (colon >= 0) {
                            proxyHost = s.substring(0, colon);
                            String port = s.substring(colon + 1);
                            proxyPort = Integer.parseInt(port);
                            continue block14;
                        }
                        proxyHost = s;
                        continue block14;
                    }
                    case 99: {
                        proxyHost = "";
                        proxyPort = 0;
                        continue block14;
                    }
                    case 108: {
                        size = Long.parseLong(g.getOptarg());
                        continue block14;
                    }
                    case 111: {
                        saveAs = g.getOptarg();
                        continue block14;
                    }
                    case 117: {
                        username = g.getOptarg();
                        continue block14;
                    }
                    case 120: {
                        password = g.getOptarg();
                        continue block14;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            PartialEepGet.usage();
            System.exit(1);
        }
        String url = args[g.getOptind()];
        if (saveAs == null) {
            saveAs = PartialEepGet.suggestName(url);
        }
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            out = null;
            System.exit(1);
        }
        PartialEepGet get = new PartialEepGet(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, out, url, size);
        if (username != null) {
            if (password == null) {
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        System.err.print("Proxy password: ");
                        password = r.readLine();
                        if (password != null) continue;
                        throw new IOException();
                    } while ((password = password.trim()).length() <= 0);
                }
                catch (IOException ioe) {
                    System.exit(1);
                }
            }
            get.addAuthorization(username, password);
        }
        PartialEepGet partialEepGet = get;
        Objects.requireNonNull(partialEepGet);
        get.addStatusListener(partialEepGet.new EepGet.CLIStatusListener(1024, 40));
        if (get.fetch(45000L, -1L, 60000L)) {
            System.err.println("Last-Modified: " + get.getLastModified());
            System.err.println("Etag: " + get.getETag());
        } else {
            System.err.println("Failed " + url);
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("PartialEepGet [-p 127.0.0.1[:4444]] [-c] [-o outputFile]\n              [-l #bytes] (default 56)\n              [-u username] [-x password] url\n              (use -c or -p :0 for no proxy)");
    }

    @Override
    protected String getRequest() throws IOException {
        String urlToSend;
        URI url;
        StringBuilder buf = new StringBuilder(2048);
        try {
            url = new URI(this._actualURL);
        }
        catch (URISyntaxException use) {
            MalformedURLException ioe = new MalformedURLException("Bad URL");
            ioe.initCause(use);
            throw ioe;
        }
        String host = url.getHost();
        if (host == null || host.length() <= 0) {
            throw new MalformedURLException("Bad URL, no host");
        }
        int port = url.getPort();
        String path = url.getRawPath();
        String query = url.getRawQuery();
        if (this._log.shouldLog(10)) {
            this._log.debug("Requesting " + this._actualURL);
        }
        if (this._shouldProxy) {
            urlToSend = this._actualURL;
            if (!(path != null && path.length() > 0 || query != null && query.length() > 0)) {
                urlToSend = urlToSend + "/";
            }
        } else {
            urlToSend = path;
            if (urlToSend == null || urlToSend.length() <= 0) {
                urlToSend = "/";
            }
            if (query != null) {
                urlToSend = urlToSend + '?' + query;
            }
        }
        buf.append("GET ").append(urlToSend).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(host);
        if (port >= 0) {
            buf.append(':').append(port);
        }
        buf.append("\r\n");
        buf.append("Range: bytes=");
        buf.append(this._alreadyTransferred);
        buf.append('-');
        buf.append(this._fetchSize - 1L);
        buf.append("\r\n");
        buf.append("Cache-Control: no-cache\r\nPragma: no-cache\r\nAccept-Encoding: \r\nConnection: close\r\n");
        boolean uaOverridden = false;
        if (this._extraHeaders != null) {
            for (String hdr : this._extraHeaders) {
                if (hdr.toLowerCase(Locale.US).startsWith("user-agent: ")) {
                    uaOverridden = true;
                }
                buf.append(hdr).append("\r\n");
            }
        }
        if (!uaOverridden) {
            buf.append("User-Agent: Wget/1.11.4\r\n");
        }
        if (this._authState != null && this._shouldProxy && this._authState.authMode != EepGet.AUTH_MODE.NONE) {
            buf.append("Proxy-Authorization: ");
            buf.append(this._authState.getAuthHeader("GET", urlToSend));
            buf.append("\r\n");
        }
        buf.append("\r\n");
        if (this._log.shouldLog(10)) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }
}

