/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryLoader;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.kitchen.Messages;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.version.BuildVersion;

public class Kitchen {
    public static final String STRING_KITCHEN = "Kitchen";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] a) throws KettleException {
        EnvUtil.environmentInit();
        JndiUtil.initJNDI();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length() <= 0) continue;
            args.add(a[i]);
        }
        RepositoryMeta repinfo = null;
        UserInfo userinfo = null;
        Job job = null;
        NamedParamsDefault optionParams = new NamedParamsDefault();
        CommandLineOption[] commandLineOptionArray = new CommandLineOption[17];
        StringBuffer optionRepname = new StringBuffer();
        commandLineOptionArray[0] = new CommandLineOption("rep", Messages.getString("Kitchen.CmdLine.RepName"), optionRepname);
        StringBuffer optionUsername = new StringBuffer();
        commandLineOptionArray[1] = new CommandLineOption("user", Messages.getString("Kitchen.CmdLine.RepUsername"), optionUsername);
        StringBuffer optionPassword = new StringBuffer();
        commandLineOptionArray[2] = new CommandLineOption("pass", Messages.getString("Kitchen.CmdLine.RepPassword"), optionPassword);
        StringBuffer optionJobname = new StringBuffer();
        commandLineOptionArray[3] = new CommandLineOption("job", Messages.getString("Kitchen.CmdLine.RepJobName"), optionJobname);
        StringBuffer optionDirname = new StringBuffer();
        commandLineOptionArray[4] = new CommandLineOption("dir", Messages.getString("Kitchen.CmdLine.RepDir"), optionDirname);
        StringBuffer optionFilename = new StringBuffer();
        commandLineOptionArray[5] = new CommandLineOption("file", Messages.getString("Kitchen.CmdLine.XMLJob"), optionFilename);
        StringBuffer optionLoglevel = new StringBuffer();
        commandLineOptionArray[6] = new CommandLineOption("level", Messages.getString("Kitchen.CmdLine.LogLevel"), optionLoglevel);
        StringBuffer optionLogfile = new StringBuffer();
        commandLineOptionArray[7] = new CommandLineOption("logfile", Messages.getString("Kitchen.CmdLine.LogFile"), optionLogfile);
        StringBuffer optionLogfileOld = new StringBuffer();
        commandLineOptionArray[8] = new CommandLineOption("log", Messages.getString("Kitchen.CmdLine.LogFileOld"), optionLogfileOld, false, true);
        StringBuffer optionListdir = new StringBuffer();
        commandLineOptionArray[9] = new CommandLineOption("listdir", Messages.getString("Kitchen.CmdLine.ListDir"), optionListdir, true, false);
        StringBuffer optionListjobs = new StringBuffer();
        commandLineOptionArray[10] = new CommandLineOption("listjobs", Messages.getString("Kitchen.CmdLine.ListJobsDir"), optionListjobs, true, false);
        StringBuffer optionListrep = new StringBuffer();
        commandLineOptionArray[11] = new CommandLineOption("listrep", Messages.getString("Kitchen.CmdLine.ListAvailableReps"), optionListrep, true, false);
        StringBuffer optionNorep = new StringBuffer();
        commandLineOptionArray[12] = new CommandLineOption("norep", Messages.getString("Kitchen.CmdLine.NoRep"), optionNorep, true, false);
        StringBuffer optionVersion = new StringBuffer();
        commandLineOptionArray[13] = new CommandLineOption("version", Messages.getString("Kitchen.CmdLine.Version"), optionVersion, true, false);
        commandLineOptionArray[14] = new CommandLineOption("param", Messages.getString("Kitchen.ComdLine.Param"), (NamedParams)optionParams, false);
        StringBuffer optionListParam = new StringBuffer();
        commandLineOptionArray[15] = new CommandLineOption("listparam", Messages.getString("Kitchen.ComdLine.ListParam"), optionListParam, true, false);
        StringBuffer optionExport = new StringBuffer();
        commandLineOptionArray[16] = new CommandLineOption("export", Messages.getString("Kitchen.ComdLine.Export"), optionExport, true, false);
        CommandLineOption[] options = commandLineOptionArray;
        if (args.size() == 0) {
            CommandLineOption.printUsage(options);
            Kitchen.exitJVM(9);
        }
        LogWriter log = LogWriter.getInstance((int)3);
        CommandLineOption.parseArguments(args, options, log);
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (!Const.isEmpty((String)kettleRepname)) {
            optionRepname = new StringBuffer(kettleRepname);
        }
        if (!Const.isEmpty((String)kettleUsername)) {
            optionUsername = new StringBuffer(kettleUsername);
        }
        if (!Const.isEmpty((String)kettlePassword)) {
            optionPassword = new StringBuffer(kettlePassword);
        }
        LogWriter.setConsoleAppenderDebug();
        if (Const.isEmpty((StringBuffer)optionLogfile) && !Const.isEmpty((StringBuffer)optionLogfileOld)) {
            optionLogfile = optionLogfileOld;
        }
        log = Const.isEmpty((StringBuffer)optionLogfile) ? LogWriter.getInstance((int)3) : LogWriter.getInstance((String)optionLogfile.toString(), (boolean)true, (int)3);
        if (!Const.isEmpty((StringBuffer)optionLoglevel)) {
            log.setLogLevel(optionLoglevel.toString());
            log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.LogLevel", log.getLogLevelLongDesc()), new Object[0]);
        }
        if (!Const.isEmpty((StringBuffer)optionVersion)) {
            BuildVersion buildVersion = BuildVersion.getInstance();
            log.logBasic(STRING_KITCHEN, Messages.getString("Kitchen.Log.KettleVersion", buildVersion.getVersion(), buildVersion.getRevision(), buildVersion.getBuildDate()), new Object[0]);
            if (a.length == 1) {
                Kitchen.exitJVM(6);
            }
        }
        if (!Const.isEmpty((StringBuffer)optionRepname) && !Const.isEmpty((StringBuffer)optionUsername) && log.isDetailed()) {
            log.logDetailed(STRING_KITCHEN, Messages.getString("Kitchen.Log.RepUsernameSupplied"), new Object[0]);
        }
        log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.Starting"), new Object[0]);
        try {
            StepLoader.init();
        }
        catch (KettleException e) {
            log.logError(STRING_KITCHEN, Messages.getString("Kitchen.Error.LoadingSteps"), (Throwable)e);
            Kitchen.exitJVM(8);
        }
        StepLoader stepLoader = StepLoader.getInstance();
        try {
            JobEntryLoader.init();
        }
        catch (KettleException e) {
            log.logError(STRING_KITCHEN, Messages.getString("Kitchen.Error.LoadingJobEntries"), (Throwable)e);
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Calendar cal = Calendar.getInstance();
        Date start = cal.getTime();
        if (log.isDebug()) {
            log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.AllocateNewJob"), new Object[0]);
        }
        JobMeta jobMeta = new JobMeta(log);
        Repository repository = null;
        try {
            if (!Const.isEmpty((StringBuffer)optionRepname) || !Const.isEmpty((StringBuffer)optionFilename)) {
                if (log.isDebug()) {
                    log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.ParsingCommandLine"), new Object[0]);
                }
                if (!Const.isEmpty((StringBuffer)optionRepname) && !"Y".equalsIgnoreCase(optionNorep.toString())) {
                    RepositoriesMeta repsinfo;
                    if (log.isDebug()) {
                        log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.LoadingRep"), new Object[0]);
                    }
                    if ((repsinfo = new RepositoriesMeta(log)).readData()) {
                        if (log.isDebug()) {
                            log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.FindingRep", "" + optionRepname), new Object[0]);
                        }
                        if ((repinfo = repsinfo.findRepository(optionRepname.toString())) != null) {
                            if (log.isDebug()) {
                                log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.Alocate&ConnectRep"), new Object[0]);
                            }
                            if ((repository = new Repository(log, repinfo, userinfo)).connect("Kitchen commandline")) {
                                RepositoryDirectory directory = repository.getDirectoryTree();
                                if (!Const.isEmpty((StringBuffer)optionDirname)) {
                                    directory = repository.getDirectoryTree().findDirectory(optionDirname.toString());
                                }
                                if (directory != null) {
                                    if (log.isDebug()) {
                                        log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.CheckUserPass"), new Object[0]);
                                    }
                                    if ((userinfo = new UserInfo(repository, optionUsername.toString(), optionPassword.toString())).getID() > 0L) {
                                        int i;
                                        if (!Const.isEmpty((StringBuffer)optionJobname)) {
                                            if (log.isDebug()) {
                                                log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.LoadingJobInfo"), new Object[0]);
                                            }
                                            jobMeta = new JobMeta(log, repository, optionJobname.toString(), directory);
                                            if (log.isDebug()) {
                                                log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.AllocateJob"), new Object[0]);
                                            }
                                            job = new Job(log, stepLoader, repository, jobMeta);
                                        } else if ("Y".equalsIgnoreCase(optionListjobs.toString())) {
                                            if (log.isDebug()) {
                                                log.logDebug(STRING_KITCHEN, Messages.getString("Kitchen.Log.GettingLostJobsInDirectory", "" + directory), new Object[0]);
                                            }
                                            String[] jobnames = repository.getJobNames(directory.getID());
                                            for (i = 0; i < jobnames.length; ++i) {
                                                System.out.println(jobnames[i]);
                                            }
                                        } else if ("Y".equalsIgnoreCase(optionListdir.toString())) {
                                            String[] dirnames = repository.getDirectoryNames(directory.getID());
                                            for (i = 0; i < dirnames.length; ++i) {
                                                System.out.println(dirnames[i]);
                                            }
                                        }
                                    } else {
                                        System.out.println(Messages.getString("Kitchen.Error.CanNotVerifyUserPass"));
                                        userinfo = null;
                                        repinfo = null;
                                    }
                                } else {
                                    System.out.println(Messages.getString("Kitchen.Error.CanNotFindSuppliedDirectory", optionDirname + ""));
                                    userinfo = null;
                                    repinfo = null;
                                }
                            } else {
                                System.out.println(Messages.getString("Kitchen.Error.CanNotConnectRep"));
                            }
                        } else {
                            System.out.println(Messages.getString("Kitchen.Error.NoRepProvided"));
                        }
                    } else {
                        System.out.println(Messages.getString("Kitchen.Error.NoRepDefinied"));
                    }
                }
                if (!Const.isEmpty((StringBuffer)optionFilename) && job == null) {
                    jobMeta = new JobMeta(log, optionFilename.toString(), null, null);
                    job = new Job(log, stepLoader, null, jobMeta);
                }
            } else if ("Y".equalsIgnoreCase(optionListrep.toString())) {
                RepositoriesMeta ri = new RepositoriesMeta(log);
                if (ri.readData()) {
                    System.out.println(Messages.getString("Kitchen.Log.ListRep"));
                    for (int i = 0; i < ri.nrRepositories(); ++i) {
                        RepositoryMeta rinfo = ri.getRepository(i);
                        System.out.println("#" + (i + 1) + " : " + rinfo.getName() + " [" + rinfo.getDescription() + "] ");
                    }
                } else {
                    System.out.println(Messages.getString("Kitchen.Error.UnableToReadXMLFile"));
                }
            }
        }
        catch (KettleException e) {
            job = null;
            jobMeta = null;
            System.out.println(Messages.getString("Kitchen.Error.StopProcess", e.getMessage()));
        }
        if (job == null) {
            if (!("Y".equalsIgnoreCase(optionListjobs.toString()) || "Y".equalsIgnoreCase(optionListdir.toString()) || "Y".equalsIgnoreCase(optionListrep.toString()))) {
                System.out.println(Messages.getString("Kitchen.Error.canNotLoadJob"));
            }
            Kitchen.exitJVM(7);
        }
        if (!Const.isEmpty((String)optionExport.toString())) {
            try {
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(optionExport.toString(), job.getJobMeta(), job, repository);
                String launchFile = topLevelResource.getResourceName();
                String message = ResourceUtil.getExplanation(optionExport.toString(), launchFile, job.getJobMeta());
                System.out.println();
                System.out.println(message);
                optionListParam = new StringBuffer("Y");
            }
            catch (Exception e) {
                System.out.println(Const.getStackTracker((Throwable)e));
                Kitchen.exitJVM(2);
            }
        }
        Result result = null;
        int returnCode = 0;
        try {
            try {
                String value;
                String[] jobParams;
                if (args.size() == 0) {
                    job.getJobMeta().setArguments(null);
                } else {
                    job.getJobMeta().setArguments(args.toArray(new String[args.size()]));
                }
                job.initializeVariablesFrom(null);
                job.getJobMeta().setInternalKettleVariables(job);
                job.copyParametersFrom(job.getJobMeta());
                for (String param : jobParams = job.listParameters()) {
                    value = optionParams.getParameterValue(param);
                    if (value == null) continue;
                    job.setParameterValue(param, value);
                }
                job.activateParameters();
                if ("Y".equalsIgnoreCase(optionListParam.toString())) {
                    for (String parameterName : job.listParameters()) {
                        value = job.getParameterValue(parameterName);
                        String deflt = job.getParameterDefault(parameterName);
                        String descr = job.getParameterDescription(parameterName);
                        if (deflt != null) {
                            System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + ", default=" + deflt + " : " + Const.NVL((String)descr, (String)""));
                            continue;
                        }
                        System.out.println("Parameter: " + parameterName + "=" + Const.NVL((String)value, (String)"") + " : " + Const.NVL((String)descr, (String)""));
                    }
                    Kitchen.exitJVM(7);
                }
                result = job.execute();
                job.endProcessing("end", result);
            }
            catch (KettleJobException je) {
                if (result == null) {
                    result = new Result();
                }
                result.setNrErrors(1L);
                try {
                    job.endProcessing("error", result);
                }
                catch (KettleJobException je2) {
                    log.logError(job.getJobname(), Messages.getString("Kitchen.Error.SeriousError", je2.getMessage()), new Object[0]);
                    log.logError(job.getJobname(), Messages.getString("Kitchen.Error.SeriousError", je.getMessage()), new Object[0]);
                    returnCode = 2;
                }
                Object var45_66 = null;
                if (repository != null) {
                    repository.disconnect();
                }
            }
            Object var45_65 = null;
            if (repository != null) {
                repository.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var45_67 = null;
            if (repository != null) {
                repository.disconnect();
            }
            throw throwable;
        }
        log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.Finished"), new Object[0]);
        if (result != null && result.getNrErrors() != 0L) {
            log.logError(STRING_KITCHEN, Messages.getString("Kitchen.Error.FinishedWithErrors"), new Object[0]);
            returnCode = 1;
        }
        cal = Calendar.getInstance();
        Date stop = cal.getTime();
        String begin = df.format(start).toString();
        String end = df.format(stop).toString();
        log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.StartStop", begin, end), new Object[0]);
        long seconds = (stop.getTime() - start.getTime()) / 1000L;
        if (seconds <= 60L) {
            log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.ProcessEndAfter", String.valueOf(seconds)), new Object[0]);
        } else if (seconds <= 3600L) {
            int min = (int)(seconds / 60L);
            int rem = (int)(seconds % 60L);
            log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.ProcessEndAfterLong", String.valueOf(min), String.valueOf(rem), String.valueOf(seconds)), new Object[0]);
        } else if (seconds <= 86400L) {
            int hour = (int)(seconds / 3600L);
            int rem = (int)(seconds % 3600L);
            int min = rem / 60;
            log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.ProcessEndAfterLonger", String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)), new Object[0]);
        } else {
            int days = (int)(seconds / 86400L);
            int rem = (int)(seconds % 86400L);
            int hour = rem / 3600;
            int min = (rem %= 3600) / 60;
            log.logMinimal(STRING_KITCHEN, Messages.getString("Kitchen.Log.ProcessEndAfterLongest", String.valueOf(days), String.valueOf(hour), String.valueOf(min), String.valueOf(rem %= 60), String.valueOf(seconds)), new Object[0]);
        }
        Kitchen.exitJVM(returnCode);
    }

    private static final void exitJVM(int status) {
        LogWriter.getInstance().close();
        System.exit(status);
    }
}

