;;; uiso8859-16.el --- tables between UCS and ISO-8859-16   -*- coding: iso-2022-7bit  -*-

;; Copyright (C) 2005 Aidan Kehoe

;; Author: Aidan Kehoe <kehoea@parhasard.net>
;; Keywords: i18n

;; This file is a contribution to Mule-UCS.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(put 'latin-iso8859-16 'unicode-assoc 'iso-8859-16-vs-unicode-assoc)

(defvar
  iso-8859-16-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?\,f (B ."0x00A0")		; NO-BREAK SPACE
       (?,f!(B ."0x0104")		; LATIN CAPITAL LETTER A WITH OGONEK
       (?,f"(B ."0x0105")		; LATIN SMALL LETTER A WITH OGONEK
       (?,f#(B ."0x0141")		; LATIN CAPITAL LETTER L WITH STROKE
       (?,f$(B ."0x20AC")		; EURO SIGN
       (?,f%(B ."0x201E")		; DOUBLE LOW-9 QUOTATION MARK
       (?,f&(B ."0x0160")		; LATIN CAPITAL LETTER S WITH CARON
       (?,f'(B ."0x00A7")		; SECTION SIGN
       (?,f((B ."0x0161")		; LATIN SMALL LETTER S WITH CARON
       (?,f)(B ."0x00A9")		; COPYRIGHT SIGN
       (?,f*(B ."0x0218")		; LATIN CAPITAL LETTER S WITH COMMA BELOW
       (?,f+(B ."0x00AB")		; LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
       (?,f,(B ."0x0179")		; LATIN CAPITAL LETTER Z WITH ACUTE
       (?,f-(B ."0x00AD")		; SOFT HYPHEN
       (?,f.(B ."0x017A")		; LATIN SMALL LETTER Z WITH ACUTE
       (?,f/(B ."0x017B")		; LATIN CAPITAL LETTER Z WITH DOT ABOVE
       (?,f0(B ."0x00B0")		; DEGREE SIGN
       (?,f1(B ."0x00B1")		; PLUS-MINUS SIGN
       (?,f2(B ."0x010C")		; LATIN CAPITAL LETTER C WITH CARON
       (?,f3(B ."0x0142")		; LATIN SMALL LETTER L WITH STROKE
       (?,f4(B ."0x017D")		; LATIN CAPITAL LETTER Z WITH CARON
       (?,f5(B ."0x201D")		; RIGHT DOUBLE QUOTATION MARK
       (?,f6(B ."0x00B6")		; PILCROW SIGN
       (?,f7(B ."0x00B7")		; MIDDLE DOT
       (?,f8(B ."0x017E")		; LATIN SMALL LETTER Z WITH CARON
       (?,f9(B ."0x010D")		; LATIN SMALL LETTER C WITH CARON
       (?,f:(B ."0x0219")		; LATIN SMALL LETTER S WITH COMMA BELOW
       (?,f;(B ."0x00BB")		; RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
       (?,f<(B ."0x0152")		; LATIN CAPITAL LIGATURE OE
       (?,f=(B ."0x0153")		; LATIN SMALL LIGATURE OE
       (?,f>(B ."0x0178")		; LATIN CAPITAL LETTER Y WITH DIAERESIS
       (?,f?(B ."0x017C")		; LATIN SMALL LETTER Z WITH DOT ABOVE
       (?,f@(B ."0x00C0")		; LATIN CAPITAL LETTER A WITH GRAVE
       (?,fA(B ."0x00C1")		; LATIN CAPITAL LETTER A WITH ACUTE
       (?,fB(B ."0x00C2")		; LATIN CAPITAL LETTER A WITH CIRCUMFLEX
       (?,fC(B ."0x0102")		; LATIN CAPITAL LETTER A WITH BREVE
       (?,fD(B ."0x00C4")		; LATIN CAPITAL LETTER A WITH DIAERESIS
       (?,fE(B ."0x0106")		; LATIN CAPITAL LETTER C WITH ACUTE
       (?,fF(B ."0x00C6")		; LATIN CAPITAL LETTER AE
       (?,fG(B ."0x00C7")		; LATIN CAPITAL LETTER C WITH CEDILLA
       (?,fH(B ."0x00C8")		; LATIN CAPITAL LETTER E WITH GRAVE
       (?,fI(B ."0x00C9")		; LATIN CAPITAL LETTER E WITH ACUTE
       (?,fJ(B ."0x00CA")		; LATIN CAPITAL LETTER E WITH CIRCUMFLEX
       (?,fK(B ."0x00CB")		; LATIN CAPITAL LETTER E WITH DIAERESIS
       (?,fL(B ."0x00CC")		; LATIN CAPITAL LETTER I WITH GRAVE
       (?,fM(B ."0x00CD")		; LATIN CAPITAL LETTER I WITH ACUTE
       (?,fN(B ."0x00CE")		; LATIN CAPITAL LETTER I WITH CIRCUMFLEX
       (?,fO(B ."0x00CF")		; LATIN CAPITAL LETTER I WITH DIAERESIS
       (?,fP(B ."0x0110")		; LATIN CAPITAL LETTER D WITH STROKE
       (?,fQ(B ."0x0143")		; LATIN CAPITAL LETTER N WITH ACUTE
       (?,fR(B ."0x00D2")		; LATIN CAPITAL LETTER O WITH GRAVE
       (?,fS(B ."0x00D3")		; LATIN CAPITAL LETTER O WITH ACUTE
       (?,fT(B ."0x00D4")		; LATIN CAPITAL LETTER O WITH CIRCUMFLEX
       (?,fU(B ."0x0150")		; LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
       (?,fV(B ."0x00D6")		; LATIN CAPITAL LETTER O WITH DIAERESIS
       (?,fW(B ."0x015A")		; LATIN CAPITAL LETTER S WITH ACUTE
       (?,fX(B ."0x0170")		; LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
       (?,fY(B ."0x00D9")		; LATIN CAPITAL LETTER U WITH GRAVE
       (?,fZ(B ."0x00DA")		; LATIN CAPITAL LETTER U WITH ACUTE
       (?,f[(B ."0x00DB")		; LATIN CAPITAL LETTER U WITH CIRCUMFLEX
       (?,f\(B ."0x00DC")		; LATIN CAPITAL LETTER U WITH DIAERESIS
       (?,f](B ."0x0118")		; LATIN CAPITAL LETTER E WITH OGONEK
       (?,f^(B ."0x021A")		; LATIN CAPITAL LETTER T WITH COMMA BELOW
       (?,f_(B ."0x00DF")		; LATIN SMALL LETTER SHARP S
       (?,f`(B ."0x00E0")		; LATIN SMALL LETTER A WITH GRAVE
       (?,fa(B ."0x00E1")		; LATIN SMALL LETTER A WITH ACUTE
       (?,fb(B ."0x00E2")		; LATIN SMALL LETTER A WITH CIRCUMFLEX
       (?,fc(B ."0x0103")		; LATIN SMALL LETTER A WITH BREVE
       (?,fd(B ."0x00E4")		; LATIN SMALL LETTER A WITH DIAERESIS
       (?,fe(B ."0x0107")		; LATIN SMALL LETTER C WITH ACUTE
       (?,ff(B ."0x00E6")		; LATIN SMALL LETTER AE
       (?,fg(B ."0x00E7")		; LATIN SMALL LETTER C WITH CEDILLA
       (?,fh(B ."0x00E8")		; LATIN SMALL LETTER E WITH GRAVE
       (?,fi(B ."0x00E9")		; LATIN SMALL LETTER E WITH ACUTE
       (?,fj(B ."0x00EA")		; LATIN SMALL LETTER E WITH CIRCUMFLEX
       (?,fk(B ."0x00EB")		; LATIN SMALL LETTER E WITH DIAERESIS
       (?,fl(B ."0x00EC")		; LATIN SMALL LETTER I WITH GRAVE
       (?,fm(B ."0x00ED")		; LATIN SMALL LETTER I WITH ACUTE
       (?,fn(B ."0x00EE")		; LATIN SMALL LETTER I WITH CIRCUMFLEX
       (?,fo(B ."0x00EF")		; LATIN SMALL LETTER I WITH DIAERESIS
       (?,fp(B ."0x0111")		; LATIN SMALL LETTER D WITH STROKE
       (?,fq(B ."0x0144")		; LATIN SMALL LETTER N WITH ACUTE
       (?,fr(B ."0x00F2")		; LATIN SMALL LETTER O WITH GRAVE
       (?,fs(B ."0x00F3")		; LATIN SMALL LETTER O WITH ACUTE
       (?,ft(B ."0x00F4")		; LATIN SMALL LETTER O WITH CIRCUMFLEX
       (?,fu(B ."0x0151")		; LATIN SMALL LETTER O WITH DOUBLE ACUTE
       (?,fv(B ."0x00F6")		; LATIN SMALL LETTER O WITH DIAERESIS
       (?,fw(B ."0x015B")		; LATIN SMALL LETTER S WITH ACUTE
       (?,fx(B ."0x0171")		; LATIN SMALL LETTER U WITH DOUBLE ACUTE
       (?,fy(B ."0x00F9")		; LATIN SMALL LETTER U WITH GRAVE
       (?,fz(B ."0x00FA")		; LATIN SMALL LETTER U WITH ACUTE
       (?,f{(B ."0x00FB")		; LATIN SMALL LETTER U WITH CIRCUMFLEX
       (?,f|(B ."0x00FC")		; LATIN SMALL LETTER U WITH DIAERESIS
       (?,f}(B ."0x0119")		; LATIN SMALL LETTER E WITH OGONEK
       (?,f~(B ."0x021B")		; LATIN SMALL LETTER T WITH COMMA BELOW
       (?,f(B ."0x00FF")		; LATIN SMALL LETTER Y WITH DIAERESIS
       ))))

(provide 'uiso8859-16)

;;; uiso8859-16.el ends here
