#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# This file is part of the Wapiti project (https://wapiti-scanner.github.io)
# Copyright (C) 2013-2023 Nicolas Surribas
# Copyright (C) 2021-2024 Cyberwatch
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
CRITICAL_LEVEL = 4
HIGH_LEVEL = 3
MEDIUM_LEVEL = 2
LOW_LEVEL = 1
INFO_LEVEL = 0


class Messages:
    MSG_EVIL_URL = "  Evil url: {0}"
    MSG_PARAM_INJECT = "{0} in {1} via injection in the parameter {2}"
    MSG_FROM = "  coming from {0}"
    MSG_QS_INJECT = "{0} in {1} via injection in the query string"
    MSG_PATH_INJECT = "{0} in {1} via injection in the resource path"
    MSG_EVIL_PARAM = "Involved parameter: {0}"
    MSG_EVIL_REQUEST = "Evil request:"

    ERROR_500 = "Internal Server Error"
    RES_CONSUMPTION = "Resource consumption"

    MSG_500 = "Received a HTTP 500 error in {0}"
    MSG_TIMEOUT = "Timeout occurred in {0}"

    MSG_QS_TIMEOUT = "The request timed out while attempting to inject a payload in the query string"
    MSG_PATH_TIMEOUT = "The request timed out while attempting to inject a payload in the resource path"
    MSG_PARAM_TIMEOUT = "The request timed out while attempting to inject a payload in the parameter {0}"

    MSG_QS_500 = (
        "The server responded with a 500 HTTP error code while attempting to inject a payload in the query string"
    )
    MSG_PATH_500 = (
        "The server responded with a 500 HTTP error code while attempting to inject a payload in the resource path"
    )
    MSG_PARAM_500 = (
        "The server responded with a 500 HTTP error code while attempting to inject a payload in the parameter {0}"
    )
