/*-
 * Copyright (c) 2008-2011 Varnish Software AS
 * All rights reserved.
 *
 * Author: Poul-Henning Kamp <phk@phk.freebsd.dk>
 *
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Define which variables we can ban on, and which function does it.
 *
 */

/*lint -save -e525 -e539 */

PVAR("req.url",
     BANS_FLAG_REQ,
     BANS_ARG_URL)
PVAR("req.http.",
     BANS_FLAG_REQ | BANS_FLAG_HTTP,
     BANS_ARG_REQHTTP)
PVAR("obj.status",
     BANS_FLAG_OBJ,
     BANS_ARG_OBJSTATUS)
PVAR("obj.http.",
     BANS_FLAG_OBJ | BANS_FLAG_HTTP,
     BANS_ARG_OBJHTTP)
PVAR("obj.ttl",
     BANS_FLAG_OBJ | BANS_FLAG_DURATION | BANS_FLAG_NODEDUP,
     BANS_ARG_OBJTTL)
PVAR("obj.age",
     BANS_FLAG_OBJ | BANS_FLAG_DURATION | BANS_FLAG_NODEDUP,
     BANS_ARG_OBJAGE)
PVAR("obj.grace",
     BANS_FLAG_OBJ | BANS_FLAG_DURATION,
     BANS_ARG_OBJGRACE)
PVAR("obj.keep",
     BANS_FLAG_OBJ | BANS_FLAG_DURATION,
     BANS_ARG_OBJKEEP)
#undef PVAR

/*lint -restore */
