/*
*  RAL -- Rubrica Addressbook Library
*  file: telephone.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_TELEPHONE_H
#define _R_TELEPHONE_H

#include <glib.h>
#include <glib-object.h>


#define R_TELEPHONE_TYPE           (r_telephone_get_type())

#define R_TELEPHONE(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),    \
                                    R_TELEPHONE_TYPE, RTelephone))

#define R_TELEPHONE_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),     \
                                    R_TELEPHONE_TYPE, RTelephoneClass))

#define IS_R_TELEPHONE(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),    \
                                    R_TELEPHONE_TYPE))

#define IS_R_TELEPHONE_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),       \
                                    R_TELEPHONE_TYPE))

#define R_TELEPHONE_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),     \
                                    R_TELEPHONE_TYPE, RTelephoneClass))


typedef struct _RTelephone        RTelephone;
typedef struct _RTelephoneClass   RTelephoneClass;
typedef struct _RTelephonePrivate RTelephonePrivate;


typedef enum {
  R_TELEPHONE_HOME = 0,
  R_TELEPHONE_WORK,
  R_TELEPHONE_CELLPHONE,
  R_TELEPHONE_FAX,
  R_TELEPHONE_PAGER,
  R_TELEPHONE_OTHER,
  R_TELEPHONE_OPERATOR,
  R_TELEPHONE_GREEN,
  R_TELEPHONE_CUSTOMER_CARE,
  R_TELEPHONE_UNKNOWN,
  R_TELEPHONE_INVALID
} RTelephoneType;


struct _RTelephone {
  GObject parent;

  RTelephonePrivate* private;
};


struct _RTelephoneClass {
  GObjectClass parent;
};



GType          r_telephone_get_type    (void);


RTelephone*    r_telephone_new             (void);
void           r_telephone_free            (RTelephone *telephone);

gboolean       r_telephone_search          (RTelephone *telephone, 
					    const gchar* str);

RTelephone*    r_telephone_copy            (RTelephone *telephone);

RTelephoneType r_telephone_lookup_str2enum (gchar* str);
gchar*         r_telephone_lookup_enum2str (RTelephoneType type);

gchar*         r_telephone_lookup_enum2lbl (RTelephoneType type);
gchar*         r_telephone_lookup_str2lbl  (gchar* str);


#endif
